/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclParametrizedType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;

public class ASMSet
extends ASMCollection {
    public static ASMOclType myType = ASMOclParametrizedType.getASMOclParametrizedType("Set", ASMSet.getOclAnyType(), ASMCollection.myType);
    private Set s;

    public ASMSet() {
        super(myType);
        this.s = new HashSet();
    }

    public ASMSet(ASMSet init) {
        super(myType);
        this.s = new HashSet(init.s);
    }

    public ASMSet(Collection init) {
        super(myType);
        this.s = new HashSet(init);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Set {");
        Iterator i = this.s.iterator();
        while (i.hasNext()) {
            ret.append(i.next());
            if (!i.hasNext()) continue;
            ret.append(", ");
        }
        ret.append("}");
        return ret.toString();
    }

    public void add(ASMOclAny o) {
        this.s.add(o);
    }

    public Iterator iterator() {
        return this.s.iterator();
    }

    public Collection collection() {
        return this.s;
    }

    public boolean equals(Object o) {
        return o instanceof ASMSet && ((ASMSet)o).s.equals(this.s);
    }

    public int hashCode() {
        return this.s.hashCode();
    }

    public static ASMSet union(StackFrame frame, ASMSet self, ASMCollection other) {
        ASMSet ret = new ASMSet(self);
        ret.s.addAll(other.collection());
        return ret;
    }

    public static ASMSet intersection(StackFrame frame, ASMSet self, ASMCollection other) {
        ASMSet ret = new ASMSet(self);
        ret.s.retainAll(other.collection());
        return ret;
    }

    public static ASMSet operatorMinus(StackFrame frame, ASMSet self, ASMSet other) {
        ASMSet ret = new ASMSet(self);
        ret.s.removeAll(other.s);
        return ret;
    }

    public static ASMSet including(StackFrame frame, ASMSet self, ASMOclAny o) {
        ASMSet ret = new ASMSet(self);
        ret.s.add(o);
        return ret;
    }

    public static ASMSet excluding(StackFrame frame, ASMSet self, ASMOclAny o) {
        ASMSet ret = new ASMSet(self);
        ret.s.remove(o);
        return ret;
    }

    public static ASMSet symetricDifference(StackFrame frame, ASMSet self, ASMSet other) {
        ASMSet ret = new ASMSet(self);
        HashSet t = new HashSet(other.s);
        t.removeAll(self.s);
        ret.s.removeAll(other.s);
        ret.s.addAll(t);
        return ret;
    }

    public static ASMSet flatten(StackFrame frame, ASMSet self) {
        boolean containsCollection;
        HashSet<ASMOclAny> base = null;
        HashSet<ASMOclAny> ret = new HashSet<ASMOclAny>(self.collection());
        do {
            base = ret;
            ret = new HashSet();
            containsCollection = false;
            for (ASMOclAny object : base) {
                if (object instanceof ASMCollection) {
                    ASMCollection subCollection = (ASMCollection)object;
                    ret.addAll(subCollection.collection());
                    Iterator subIterator = subCollection.iterator();
                    while (!containsCollection && subIterator.hasNext()) {
                        ASMOclAny subCollectionObject = (ASMOclAny)subIterator.next();
                        if (!(subCollectionObject instanceof ASMCollection)) continue;
                        containsCollection = true;
                    }
                    continue;
                }
                ret.add(object);
            }
        } while (containsCollection);
        return new ASMSet(ret);
    }

    public static ASMSet asSet(StackFrame frame, ASMSet self) {
        return self;
    }
}

