/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.gmf.internal.validate.IDefElementProvider;
import org.eclipse.gmf.internal.validate.LabelProvider;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;
import org.eclipse.gmf.internal.validate.expressions.IModelExpressionProvider;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefUtils {
    private DefUtils() {
    }

    public static Diagnostic statusToDiagnostic(IStatus status, String diagSource, Object destObj) {
        return DefUtils.statusToDiagnostic(status, diagSource, destObj, null);
    }

    public static DiagnosticChain mergeAndFlatten(Diagnostic diagnostic, DiagnosticChain diagnosticChain) {
        List children = diagnostic.getChildren();
        if (children == null || children.isEmpty()) {
            diagnosticChain.add(diagnostic);
        } else {
            for (Diagnostic next : children) {
                DefUtils.mergeAndFlatten(next, diagnosticChain);
            }
        }
        return diagnosticChain;
    }

    public static DiagnosticChain mergeAndFlatten(IStatus status, String diagSource, Object destObj, DiagnosticChain diagnosticChain) {
        Diagnostic diagnostic = DefUtils.statusToDiagnostic(status, diagSource, destObj);
        return DefUtils.mergeAndFlatten(diagnostic, diagnosticChain);
    }

    public static Diagnostic statusToDiagnostic(IStatus status, String diagSource, Object destObj, String prefixMessage) {
        Object[] objectArray;
        int severity = 1;
        switch (status.getSeverity()) {
            case 4: {
                severity = 4;
                break;
            }
            case 2: {
                severity = 2;
                break;
            }
            case 1: {
                severity = 1;
                break;
            }
            case 0: {
                severity = 0;
                break;
            }
            case 8: {
                severity = 8;
            }
        }
        if (destObj != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = destObj;
        } else {
            objectArray = new Object[]{};
        }
        Object[] data = objectArray;
        String message = prefixMessage != null ? String.valueOf(prefixMessage) + status.getMessage() : status.getMessage();
        BasicDiagnostic diagnostic = new BasicDiagnostic(severity, diagSource, status.getCode(), message, data);
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                diagnostic.add(DefUtils.statusToDiagnostic(children[i], diagSource, destObj, prefixMessage));
                ++i;
            }
        }
        return diagnostic;
    }

    public static boolean checkTypeAssignmentCompatibility(EClassifier leftClassifier, EClassifier rightClassifier) {
        EClassifier right;
        EClassifier left = DefUtils.getCanonicalEClassifier(leftClassifier);
        if (left == (right = DefUtils.getCanonicalEClassifier(rightClassifier))) {
            return true;
        }
        if (left instanceof EClass) {
            if (right instanceof EClass && ((EClass)left).isSuperTypeOf((EClass)right)) {
                return true;
            }
        } else {
            Class rightClass = right.getInstanceClass();
            Class leftClass = left.getInstanceClass();
            if (leftClass != null && rightClass != null && leftClass.isAssignableFrom(rightClass)) {
                return true;
            }
        }
        return false;
    }

    public static IStatus getIncompatibleTypesStatus(EClassifier leftClassifier, EClassifier rightClassifier) {
        String message = MessageFormat.format(Messages.incompatibleTypes, LabelProvider.INSTANCE.getObjectLabel((EObject)leftClassifier), LabelProvider.INSTANCE.getObjectLabel((EObject)rightClassifier));
        return GMFValidationPlugin.createStatus(4, StatusCodes.INVALID_EXPRESSION_TYPE, message, null);
    }

    public static Map.Entry<String, String> findAnnotationDetailEntry(EModelElement eModelElement, String sourceURI, String key, String val) {
        for (EAnnotation nextAnnotation : eModelElement.getEAnnotations()) {
            if (!sourceURI.equals(nextAnnotation.getSource()) || !nextAnnotation.getDetails().containsKey((Object)key)) continue;
            for (Map.Entry nextEntry : nextAnnotation.getDetails()) {
                if (nextEntry.getValue() != val && !((String)nextEntry.getKey()).equals(key)) continue;
                return nextEntry;
            }
        }
        return null;
    }

    public static Map.Entry<String, String> getKeyPrefixAnnotation(EAnnotation annotation, String keyPrefix) {
        for (Map.Entry nextEntry : annotation.getDetails()) {
            if (!((String)nextEntry.getKey()).startsWith(keyPrefix)) continue;
            return nextEntry;
        }
        return null;
    }

    public static List<EAnnotation> getAnnotationsWithKeyAndValue(EModelElement eModelElement, String sourceURI, String key, String value) {
        ArrayList<EAnnotation> annotations = null;
        for (EAnnotation nextAnnotation : eModelElement.getEAnnotations()) {
            if (!sourceURI.equals(nextAnnotation.getSource())) continue;
            Object detailVal = nextAnnotation.getDetails().get((Object)key);
            if ((value == null || !value.equals(detailVal)) && value != detailVal) continue;
            if (annotations == null) {
                annotations = new ArrayList<EAnnotation>(eModelElement.getEAnnotations().size());
            }
            annotations.add(nextAnnotation);
        }
        if (annotations != null) {
            return annotations;
        }
        return Collections.emptyList();
    }

    private static boolean isEcorePackageClassifier(EClassifier classifier) {
        EPackage classifierPackage = classifier.getEPackage();
        return EcorePackage.eINSTANCE == classifierPackage || classifierPackage != null && EcorePackage.eINSTANCE.getNsURI().equals(classifierPackage.getNsURI());
    }

    public static EClassifier getCanonicalEcorePackageClassifier(EClassifier classifier) {
        if (!DefUtils.isEcorePackageClassifier(classifier)) {
            return null;
        }
        return EcorePackage.eINSTANCE.getEClassifier(classifier.getName());
    }

    public static EClassifier getCanonicalEClassifier(EClassifier classifier) {
        EClassifier eCoreCanonical = DefUtils.getCanonicalEcorePackageClassifier(classifier);
        return eCoreCanonical == null ? classifier : eCoreCanonical;
    }

    public static IDefElementProvider.ContextProvider getContextClass(EClass resolutionContext, IModelExpressionProvider oclExprProvider, EStructuralFeature bindFeature, EPackage.Registry registry) {
        assert (bindFeature == null || bindFeature.getEContainingClass().isSuperTypeOf(resolutionContext));
        Object annotationTarget = bindFeature != null ? bindFeature : resolutionContext;
        EAnnotation ctxAnnotation = annotationTarget.getEAnnotation("http://www.eclipse.org/gmf/2005/constraints/meta");
        if (ctxAnnotation != null && "context".equals(ctxAnnotation.getDetails().get((Object)"def"))) {
            for (Map.Entry nextDetail : ctxAnnotation.getDetails()) {
                String value;
                String key = (String)nextDetail.getKey();
                String string = value = nextDetail.getValue() != null ? (String)nextDetail.getValue() : "";
                if ("ocl".equals(key)) {
                    if (value == null) continue;
                    IModelExpression contextEpression = oclExprProvider.createExpression(value, (EClassifier)resolutionContext);
                    EClassifier resultType = contextEpression.getResultType();
                    if (String.class.equals((Object)resultType.getInstanceClass())) {
                        return new LookupByNameContextProvider(contextEpression, registry);
                    }
                    if (GenClassifierContextAdapter.isGenClassifier(resultType)) {
                        return new GenClassifierContextAdapter(contextEpression);
                    }
                    return new ExpressionContextProvider(contextEpression);
                }
                if (!"ref".equals(key)) continue;
                return new ReferencedContextProvider(resolutionContext, value, oclExprProvider, registry);
            }
        }
        return null;
    }

    static List<EClass> getSubTypes(EPackage ePackage, EClass superType, List<EClass> foundSubTypes) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass) || !superType.isSuperTypeOf((EClass)classifier)) continue;
            foundSubTypes.add((EClass)classifier);
        }
        for (EPackage next : ePackage.getESubpackages()) {
            DefUtils.getSubTypes(next, superType, foundSubTypes);
        }
        return foundSubTypes;
    }

    static EPackage getRootEPackage(EPackage ePackage) {
        EPackage root = ePackage;
        EPackage parent = ePackage;
        while (parent != null) {
            root = parent;
            parent = parent.getESuperPackage();
        }
        return root;
    }

    private static abstract class AbstractProvider
    implements IDefElementProvider {
        private IStatus status = Status.OK_STATUS;

        AbstractProvider() {
        }

        protected void setStatus(IStatus status) {
            if (status == null) {
                throw new IllegalArgumentException("Null status");
            }
            this.status = status;
        }

        public IStatus getStatus() {
            return this.status;
        }
    }

    public static class ContextTypeAdapter
    extends AbstractProvider
    implements IDefElementProvider.TypeProvider {
        private IDefElementProvider.ContextProvider ctxProvider;

        public ContextTypeAdapter(IDefElementProvider.ContextProvider contextProvider) {
            if (contextProvider == null) {
                throw new IllegalArgumentException("null contextProvider");
            }
            this.ctxProvider = contextProvider;
        }

        public EClassifier getType(EObject resolutionContext) {
            return this.ctxProvider.getContextClassifier(resolutionContext);
        }

        public boolean isAssignable(EObject context, IModelExpression expression) {
            return expression.isAssignableTo(this.getType(context));
        }
    }

    private static class ExpressionBasedProvider
    extends AbstractProvider
    implements IDefElementProvider {
        private IModelExpression expression;
        private EClassifier requiredType;

        protected ExpressionBasedProvider(IModelExpression expression, EClassifier requiredType) {
            this.expression = expression;
            this.requiredType = requiredType;
            if (!expression.getStatus().isOK()) {
                this.setStatus(expression.getStatus());
            } else {
                EClassifier queryResultType = expression.getResultType();
                assert (queryResultType != null) : "Expression must have type";
                assert (requiredType != null) : "Required type must be defined";
                if (!DefUtils.checkTypeAssignmentCompatibility(requiredType, queryResultType)) {
                    this.setStatus(DefUtils.getIncompatibleTypesStatus(requiredType, queryResultType));
                }
            }
        }

        protected IModelExpression getExpression() {
            return this.expression;
        }

        protected EClassifier getRequiredType() {
            return this.requiredType;
        }

        public Object evaluate(EObject resolutionContext) {
            return this.expression.evaluate(resolutionContext);
        }

        public String toString() {
            return this.expression.toString();
        }
    }

    public static class ExpressionContextProvider
    extends ExpressionBasedProvider
    implements IDefElementProvider.ContextProvider {
        public ExpressionContextProvider(IModelExpression expression) {
            super(expression, (EClassifier)EcorePackage.eINSTANCE.getEClassifier());
        }

        public EClassifier getContextClassifier(EObject resolutionContext) {
            return this.getStatus().isOK() ? (EClassifier)super.evaluate(resolutionContext) : null;
        }
    }

    public static class ExpressionTypeProvider
    extends ExpressionBasedProvider
    implements IDefElementProvider.TypeProvider {
        public ExpressionTypeProvider(IModelExpression expression) {
            super(expression, ExpressionTypeProvider.getRequiredResultType(expression));
        }

        public EClassifier getType(EObject context) {
            if (!this.getStatus().isOK()) {
                return null;
            }
            Object val = this.evaluate(context);
            if (val instanceof ETypedElement) {
                return ((ETypedElement)val).getEType();
            }
            if (val instanceof EClassifier) {
                return (EClassifier)val;
            }
            assert (false);
            return null;
        }

        public boolean isAssignable(EObject context, IModelExpression expression) {
            if (this.hasTypedElement()) {
                return expression.isAssignableToElement(this.getTypedElement(context));
            }
            return expression.isAssignableTo(this.getType(context));
        }

        private boolean hasTypedElement() {
            if (this.getStatus().isOK()) {
                EClassifier requiredType = DefUtils.getCanonicalEClassifier(this.getRequiredType());
                return requiredType instanceof EClass && EcorePackage.eINSTANCE.getETypedElement().isSuperTypeOf((EClass)requiredType);
            }
            return false;
        }

        private ETypedElement getTypedElement(EObject context) {
            if (!this.getStatus().isOK()) {
                return null;
            }
            Object val = this.evaluate(context);
            if (val instanceof ETypedElement) {
                return (ETypedElement)val;
            }
            return null;
        }

        private static EClassifier getRequiredResultType(IModelExpression expression) {
            EClassifier type = expression.getResultType();
            if (type instanceof EClass && DefUtils.isEcorePackageClassifier(type)) {
                EClassifier canonicalClassifier = DefUtils.getCanonicalEcorePackageClassifier(type);
                assert (canonicalClassifier instanceof EClass);
                EClass canonicalClass = (EClass)canonicalClassifier;
                if (EcorePackage.eINSTANCE.getETypedElement().isSuperTypeOf(canonicalClass) || EcorePackage.eINSTANCE.getEClassifier().isSuperTypeOf(canonicalClass)) {
                    return type;
                }
            }
            return EcorePackage.eINSTANCE.getEClassifier();
        }
    }

    public static class FeatureValProvider
    extends AbstractProvider
    implements IDefElementProvider.StringValProvider {
        private EStructuralFeature feature;

        public FeatureValProvider(EStructuralFeature feature) {
            if (feature == null) {
                throw new IllegalArgumentException("null feature passed");
            }
            this.feature = feature;
            this.setStatus(FeatureValProvider.validateFeature(feature));
        }

        public String getValue(EObject contextInstance) {
            if (!this.feature.getEContainingClass().isSuperTypeOf(contextInstance.eClass())) {
                throw new IllegalArgumentException("Invalid context instance");
            }
            if (!this.getStatus().isOK()) {
                return null;
            }
            Object value = contextInstance.eGet(this.feature);
            assert (value == null || value instanceof String);
            return (String)contextInstance.eGet(this.feature);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.feature.getEContainingClass().getName()).append("::").append(this.feature.getName());
            return buf.toString();
        }

        private static IStatus validateFeature(EStructuralFeature feature) {
            if (feature.getEType() == EcorePackage.eINSTANCE.getEString()) {
                return Status.OK_STATUS;
            }
            String requiredType = LabelProvider.INSTANCE.getObjectLabel((EObject)EcorePackage.eINSTANCE.getEString());
            String foundType = LabelProvider.INSTANCE.getObjectLabel((EObject)feature.getEType());
            String message = MessageFormat.format(Messages.incompatibleTypes, requiredType, foundType);
            return GMFValidationPlugin.createStatus(4, StatusCodes.INVALID_EXPRESSION_TYPE, message, null);
        }
    }

    public static class GenClassifierContextAdapter
    extends ExpressionBasedProvider
    implements IDefElementProvider.ContextProvider {
        public static boolean isGenClassifier(EClassifier eClassifier) {
            if (eClassifier.getEPackage() == null || !"http://www.eclipse.org/emf/2002/GenModel".equals(eClassifier.getEPackage().getNsURI())) {
                return false;
            }
            return GenModelPackage.eINSTANCE.getGenClass().getName().equals(eClassifier.getName()) || GenModelPackage.eINSTANCE.getGenClassifier().getName().equals(eClassifier.getName());
        }

        public GenClassifierContextAdapter(IModelExpression expression) {
            super(expression, expression.getResultType());
            if (!GenClassifierContextAdapter.isGenClassifier(expression.getResultType())) {
                DefUtils.getIncompatibleTypesStatus((EClassifier)GenModelPackage.eINSTANCE.getGenClassifier(), expression.getResultType());
            }
        }

        public EClassifier getContextClassifier(EObject resolutionContext) {
            if (!this.getStatus().isOK()) {
                return null;
            }
            GenClassifier genClassifier = (GenClassifier)super.evaluate(resolutionContext);
            return genClassifier != null ? genClassifier.getEcoreClassifier() : null;
        }
    }

    public static class LookupByNameContextProvider
    extends ExpressionBasedProvider
    implements IDefElementProvider.ContextProvider {
        private Map<Object, EClassifier> contextCache = new HashMap<Object, EClassifier>(5);
        private EPackage.Registry registry;

        public LookupByNameContextProvider(IModelExpression expression, EPackage.Registry registry) {
            super(expression, (EClassifier)EcorePackage.eINSTANCE.getEString());
            this.registry = registry != null ? registry : EPackage.Registry.INSTANCE;
        }

        public EClassifier getContextClassifier(EObject resolutionContext) {
            Object typeNameObj;
            if (this.getStatus().isOK() && (typeNameObj = this.evaluate(resolutionContext)) instanceof String) {
                if (this.contextCache.containsKey(typeNameObj)) {
                    return this.contextCache.get(typeNameObj);
                }
                String[] typeName = ((String)typeNameObj).split("::");
                ArrayList<String> nameSeq = new ArrayList<String>(Arrays.asList(typeName));
                if (typeName.length > 1) {
                    EClassifier contextClassifier = (EClassifier)new EcoreEnvironmentFactory(this.registry).createEnvironment().lookupClassifier(nameSeq);
                    this.contextCache.put(typeNameObj, contextClassifier);
                    return contextClassifier;
                }
            }
            return null;
        }
    }

    public static class ReferencedContextProvider
    extends AbstractProvider
    implements IDefElementProvider.ContextProvider {
        private EReference contextRef;
        private Map<EClass, IDefElementProvider.ContextProvider> referencedContexts = Collections.emptyMap();

        public ReferencedContextProvider(EClass context, String referenceName, IModelExpressionProvider oclExprProvider, EPackage.Registry registry) {
            if (context == null) {
                throw new IllegalArgumentException("null context EClass");
            }
            if (referenceName != null) {
                EStructuralFeature eFeature = context.getEStructuralFeature(referenceName);
                if (eFeature instanceof EReference) {
                    this.contextRef = (EReference)eFeature;
                } else {
                    String message = NLS.bind((String)Messages.def_NoEReferenceFoundByName, (Object)referenceName, (Object)LabelProvider.INSTANCE.getObjectLabel((EObject)context));
                    this.setStatus(GMFValidationPlugin.createStatus(4, -1, message, null));
                }
            } else {
                String message = Messages.def_NoEReferenceInCtxBinding;
                this.setStatus(GMFValidationPlugin.createStatus(4, -1, message, null));
            }
            if (this.contextRef != null) {
                EClass referencedClass = this.contextRef.getEReferenceType();
                List<EClass> subTypes = DefUtils.getSubTypes(DefUtils.getRootEPackage(referencedClass.getEPackage()), referencedClass, new LinkedList<EClass>());
                this.referencedContexts = new HashMap<EClass, IDefElementProvider.ContextProvider>(5);
                Iterator<EClass> it = subTypes.iterator();
                while (it.hasNext()) {
                    EClass nextClass = it.next();
                    IDefElementProvider.ContextProvider referencedContext = DefUtils.getContextClass(nextClass, oclExprProvider, null, registry);
                    if (referencedContext == null) continue;
                    this.referencedContexts.put(nextClass, referencedContext);
                    it.remove();
                }
                ArrayList<IStatus> statuses = new ArrayList<IStatus>();
                for (EClass nextClass : subTypes) {
                    if (this.getProvider(nextClass) != null || nextClass.isInterface() || nextClass.isAbstract()) continue;
                    String message = NLS.bind((String)Messages.def_NoCtxInProviderForCtxBinding, (Object)LabelProvider.INSTANCE.getObjectLabel((EObject)nextClass), (Object)LabelProvider.INSTANCE.getFeatureLabel((EStructuralFeature)this.contextRef));
                    statuses.add(GMFValidationPlugin.createStatus(4, -1, message, null));
                }
                if (statuses.size() == 1) {
                    this.setStatus((IStatus)statuses.get(0));
                } else {
                    this.setStatus((IStatus)new MultiStatus(GMFValidationPlugin.getPluginId(), -1, statuses.toArray(new IStatus[statuses.size()]), Messages.def_MissingCtxDefInReferencedCtxProviders, null));
                }
            }
        }

        public EClassifier getContextClassifier(EObject resolutionContext) {
            if (this.getStatus().isOK()) {
                if (!this.contextRef.getEContainingClass().isSuperTypeOf(resolutionContext.eClass())) {
                    throw new IllegalArgumentException("Requires instance of :" + this.contextRef.getEContainingClass());
                }
                assert (resolutionContext.eClass().getEStructuralFeature(this.contextRef.getName()) != null);
                Object referencedEntity = resolutionContext.eGet((EStructuralFeature)this.contextRef);
                if (referencedEntity instanceof EObject) {
                    EObject eObject = (EObject)referencedEntity;
                    IDefElementProvider.ContextProvider provider = this.getProvider(eObject.eClass());
                    return provider != null && provider.getStatus().isOK() ? provider.getContextClassifier(eObject) : null;
                }
            }
            return null;
        }

        private IDefElementProvider.ContextProvider getProvider(EClass contextProviderEClass) {
            IDefElementProvider.ContextProvider provider = this.referencedContexts.get(contextProviderEClass);
            if (provider == null) {
                for (EClass nextClass : contextProviderEClass.getESuperTypes()) {
                    IDefElementProvider.ContextProvider nextProvider = this.referencedContexts.get(nextClass);
                    if (nextProvider == null) continue;
                    return nextProvider;
                }
            }
            return provider;
        }
    }

    public static class TypedElementProvider
    extends AbstractProvider
    implements IDefElementProvider.TypeProvider {
        private EStructuralFeature feature;

        public TypedElementProvider(EStructuralFeature feature) {
            this.feature = feature;
        }

        public EClassifier getType(EObject context) {
            return this.getTypedElement(context).getEType();
        }

        public boolean isAssignable(EObject context, IModelExpression expression) {
            return expression.isAssignableToElement(this.getTypedElement(context));
        }

        private ETypedElement getTypedElement(EObject context) {
            return (ETypedElement)context.eGet(this.feature);
        }
    }
}

