/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.ui.internal.resources;

import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileChangeEvent;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileChangeEventType;

public class FileChangeEventTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        TestRunner.run((Test)FileChangeEventTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.common.ui.internal.resources.FileChangeEventTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public FileChangeEventTest(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void test_deleteFileChangeEvent() {
        Path path = new Path("c:\\test.txt");
        File file = new File((IPath)path);
        FileChangeEvent event = new FileChangeEvent(FileChangeEventType.DELETED, (IFile)file);
        FileChangeEventTest.assertTrue((event.getEventType() == FileChangeEventType.DELETED ? 1 : 0) != 0);
        FileChangeEventTest.assertTrue((boolean)event.getFile().equals((Object)file));
    }

    public void test_changeFileChangeEvent() {
        Path oldPath = new Path("c:\\test.txt");
        File file = new File((IPath)oldPath);
        FileChangeEvent event = new FileChangeEvent(FileChangeEventType.CHANGED, (IFile)file);
        FileChangeEventTest.assertTrue((event.getEventType() == FileChangeEventType.CHANGED ? 1 : 0) != 0);
        FileChangeEventTest.assertTrue((boolean)event.getFile().equals((Object)file));
    }

    public void test_moveFileChangeEvent() {
        Path oldPath = new Path("c:\\folder\\test.txt");
        File oldFile = new File((IPath)oldPath);
        Path path = new Path("c:\\test.txt");
        File file = new File((IPath)path);
        FileChangeEvent event = new FileChangeEvent(FileChangeEventType.MOVED, (IFile)oldFile, (IFile)file);
        FileChangeEventTest.assertTrue((event.getEventType() == FileChangeEventType.MOVED ? 1 : 0) != 0);
        FileChangeEventTest.assertTrue((boolean)event.getFile().equals((Object)file));
        FileChangeEventTest.assertTrue((boolean)event.getOldFile().equals((Object)oldFile));
    }

    public void test_renameFileChangeEvent() {
        Path oldPath = new Path("c:\\oldtest.txt");
        File oldFile = new File((IPath)oldPath);
        Path path = new Path("c:\\test.txt");
        File file = new File((IPath)path);
        FileChangeEvent event = new FileChangeEvent(FileChangeEventType.RENAMED, (IFile)oldFile, (IFile)file);
        FileChangeEventTest.assertTrue((event.getEventType() == FileChangeEventType.RENAMED ? 1 : 0) != 0);
        FileChangeEventTest.assertTrue((boolean)event.getFile().equals((Object)file));
        FileChangeEventTest.assertTrue((boolean)event.getOldFile().equals((Object)oldFile));
    }

    protected class File
    implements IFile {
        private IPath path;

        public File(IPath path) {
            this.path = path;
        }

        public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        }

        public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public InputStream getContents() throws CoreException {
            return null;
        }

        public InputStream getContents(boolean force) throws CoreException {
            return null;
        }

        public int getEncoding() throws CoreException {
            return 0;
        }

        public IPath getFullPath() {
            return null;
        }

        public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
            return null;
        }

        public String getName() {
            return null;
        }

        public boolean isReadOnly() {
            return false;
        }

        public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
        }

        public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        }

        public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        }

        public void accept(IResourceVisitor visitor) throws CoreException {
        }

        public void clearHistory(IProgressMonitor monitor) throws CoreException {
        }

        public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public IMarker createMarker(String type) throws CoreException {
            return null;
        }

        public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        }

        public boolean exists() {
            return false;
        }

        public IMarker findMarker(long id) throws CoreException {
            return null;
        }

        public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
            return null;
        }

        public String getFileExtension() {
            return null;
        }

        public IPath getLocation() {
            return this.path;
        }

        public IMarker getMarker(long id) {
            return null;
        }

        public long getModificationStamp() {
            return 0L;
        }

        public IContainer getParent() {
            return null;
        }

        public String getPersistentProperty(QualifiedName key) throws CoreException {
            return null;
        }

        public IProject getProject() {
            return null;
        }

        public IPath getProjectRelativePath() {
            return null;
        }

        public IPath getRawLocation() {
            return null;
        }

        public Object getSessionProperty(QualifiedName key) throws CoreException {
            return null;
        }

        public int getType() {
            return 0;
        }

        public IWorkspace getWorkspace() {
            return null;
        }

        public boolean isAccessible() {
            return false;
        }

        public boolean isDerived() {
            return false;
        }

        public boolean isLinked() {
            return false;
        }

        public boolean isLocal(int depth) {
            return false;
        }

        public boolean isPhantom() {
            return false;
        }

        public boolean isSynchronized(int depth) {
            return false;
        }

        public boolean isTeamPrivateMember() {
            return false;
        }

        public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        }

        public void setDerived(boolean isDerived) throws CoreException {
        }

        public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
        }

        public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        }

        public void setReadOnly(boolean readOnly) {
        }

        public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        }

        public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
        }

        public void touch(IProgressMonitor monitor) throws CoreException {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public long getLocalTimeStamp() {
            return 0L;
        }

        public long setLocalTimeStamp(long value) throws CoreException {
            return 0L;
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return false;
        }

        public String getCharset() throws CoreException {
            return null;
        }

        public void setCharset(String newCharset) throws CoreException {
        }

        public String getCharset(boolean checkImplicit) throws CoreException {
            return null;
        }

        public IContentDescription getContentDescription() throws CoreException {
            return null;
        }

        public String getCharsetFor(Reader reader) throws CoreException {
            return null;
        }

        public ResourceAttributes getResourceAttributes() {
            return null;
        }

        public void revertModificationStamp(long value) throws CoreException {
        }

        public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
        }

        public URI getLocationURI() {
            return null;
        }

        public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public URI getRawLocationURI() {
            return null;
        }

        public boolean isLinked(int options) {
            return false;
        }

        public IResourceProxy createProxy() {
            return null;
        }
    }
}

