/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.services;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.Decoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.PresentationTestFixture;

public class DecoratorServiceTests
extends AbstractTestBase {
    public DecoratorServiceTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DecoratorServiceTests.suite());
    }

    public static Test suite() {
        return new TestSuite(DecoratorServiceTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestDecoratorProvider.setActive(true);
        NoteDecorator.ignoreParentVisibility = false;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        TestDecoratorProvider.setActive(false);
        TestDecoratorProvider.deactivate();
    }

    protected void setTestFixture() {
        this.testFixture = new PresentationTestFixture();
    }

    protected PresentationTestFixture getFixture() {
        return (PresentationTestFixture)this.testFixture;
    }

    public void testNoteDecorator() throws Exception {
        this.getFixture().createNote();
        NoteDecorator myDecorator = TestDecoratorProvider.getMyNoteDecorator();
        Decoration decoration = myDecorator.getDecoration();
        DecoratorServiceTests.assertNotNull((Object)decoration);
        NoteEditPart noteEP = (NoteEditPart)this.getDiagramEditPart().getPrimaryEditParts().get(0);
        DecoratorServiceTests.assertEquals((Object)noteEP.getFigure(), (Object)decoration.getOwnerFigure());
        DecoratorServiceTests.assertTrue((boolean)decoration.isVisible());
        DecoratorServiceTests.assertTrue((boolean)noteEP.getFigure().getBounds().contains(decoration.getBounds()));
        DecoratorServiceTests.assertEquals((int)20, (int)decoration.getSize().height);
        DecoratorServiceTests.assertTrue((boolean)this.getFixture().getDiagramEditPart().getViewer().getVisualPartMap().containsKey(decoration));
        noteEP.getFigure().setVisible(false);
        DecoratorServiceTests.assertFalse((boolean)decoration.isVisible());
        noteEP.getFigure().setVisible(true);
        DecoratorServiceTests.assertTrue((boolean)decoration.isVisible());
        noteEP.getCommand((Request)new GroupRequest((Object)"delete")).execute();
        DecoratorServiceTests.assertNull((Object)myDecorator.getDecoration());
        DecoratorServiceTests.assertFalse((boolean)this.getFixture().getDiagramEditPart().getViewer().getVisualPartMap().containsKey(decoration));
    }

    public void testIgnoreParentVisibility() throws Exception {
        NoteDecorator.ignoreParentVisibility = true;
        this.getFixture().createNote();
        NoteDecorator myDecorator = TestDecoratorProvider.getMyNoteDecorator();
        Decoration decoration = myDecorator.getDecoration();
        DecoratorServiceTests.assertNotNull((Object)decoration);
        NoteEditPart noteEP = (NoteEditPart)this.getDiagramEditPart().getPrimaryEditParts().get(0);
        DecoratorServiceTests.assertEquals((Object)noteEP.getFigure(), (Object)decoration.getOwnerFigure());
        DecoratorServiceTests.assertTrue((boolean)decoration.isVisible());
        DecoratorServiceTests.assertTrue((boolean)noteEP.getFigure().getBounds().contains(decoration.getBounds()));
        DecoratorServiceTests.assertEquals((int)20, (int)decoration.getSize().height);
        noteEP.getFigure().setVisible(false);
        DecoratorServiceTests.assertTrue((boolean)decoration.isVisible());
    }

    public static class NoteDecorator
    extends AbstractDecorator {
        static final int DIAMETER = 20;
        static boolean ignoreParentVisibility = false;

        public NoteDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
        }

        public void activate() {
            this.refresh();
        }

        public void refresh() {
            this.removeDecoration();
            NoteEditPart noteEP = (NoteEditPart)this.getDecoratorTarget().getAdapter(NoteEditPart.class);
            if (noteEP != null) {
                Ellipse circle = new Ellipse();
                circle.setSize(20, 20);
                IDecoration decoration = this.getDecoratorTarget().addShapeDecoration((IFigure)circle, IDecoratorTarget.Direction.NORTH_EAST, MapModeUtil.getMapMode((IFigure)noteEP.getFigure()).DPtoLP(-4), false);
                decoration.setIgnoreParentVisibility(ignoreParentVisibility);
                this.setDecoration(decoration);
            }
        }
    }

    public static class TestDecoratorProvider
    extends AbstractProvider
    implements IDecoratorProvider {
        public static final String TEST_DECORATOR = "TestDecorator";
        private static boolean isActive = false;
        private static NoteDecorator myNoteDecorator;

        public static boolean isActive() {
            return isActive;
        }

        public static void setActive(boolean isProviderActive) {
            isActive = isProviderActive;
        }

        public static NoteDecorator getMyNoteDecorator() {
            return myNoteDecorator;
        }

        public static void deactivate() {
            myNoteDecorator = null;
        }

        public TestDecoratorProvider() {
            myNoteDecorator = null;
        }

        public void createDecorators(IDecoratorTarget decoratorTarget) {
            NoteEditPart noteEP = (NoteEditPart)decoratorTarget.getAdapter(NoteEditPart.class);
            if (noteEP != null) {
                if (myNoteDecorator == null) {
                    myNoteDecorator = new NoteDecorator(decoratorTarget);
                }
                decoratorTarget.installDecorator((Object)TEST_DECORATOR, (IDecorator)myNoteDecorator);
            }
        }

        public boolean provides(IOperation operation) {
            if (!TestDecoratorProvider.isActive()) {
                return false;
            }
            IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
            return decoratorTarget.getAdapter(NoteEditPart.class) != null;
        }
    }
}

