/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;

public class ShapeCompartmentDropEditPolicy
extends DragDropEditPolicy {
    protected Command getDropCommand(ChangeBoundsRequest request) {
        Object obj;
        List editparts = request.getEditParts();
        if (editparts.size() == 1 && (obj = editparts.get(0)) instanceof EditPart) {
            IGraphicalEditPart gep;
            EditPart requestEP = (EditPart)obj;
            if (this.getHost() instanceof IGraphicalEditPart && (gep = (IGraphicalEditPart)this.getHost()).getTopGraphicEditPart().equals(requestEP)) {
                return null;
            }
        }
        return super.getDropCommand(request);
    }

    protected Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        Iterator iter = dropRequest.getObjects().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof EObject)) continue;
            viewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)obj), ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint()));
        }
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = this.getHost().getCommand((Request)createViewRequest);
        if (createCommand != null) {
            List result = (List)createViewRequest.getNewObject();
            dropRequest.setResult(result);
            RefreshConnectionsRequest refreshRequest = new RefreshConnectionsRequest(result);
            Command refreshCommand = this.getHost().getCommand((Request)refreshRequest);
            ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
            arrangeRequest.setViewAdaptersToArrange(result);
            Command arrangeCommand = this.getHost().getCommand((Request)arrangeRequest);
            CompoundCommand cc = new CompoundCommand(createCommand.getLabel());
            cc.add(createCommand.chain(refreshCommand));
            cc.add(arrangeCommand);
            return cc;
        }
        return null;
    }
}

