/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.util;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.GIFEmitter;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.codegen.dispatch.CachingEmitterFactory;
import org.eclipse.gmf.internal.codegen.dispatch.EmitterFactory;
import org.eclipse.gmf.internal.codegen.dispatch.EmitterFactoryImpl;
import org.eclipse.gmf.internal.codegen.dispatch.NoSuchTemplateException;
import org.eclipse.gmf.internal.codegen.dispatch.StaticTemplateRegistry;
import org.eclipse.gmf.internal.codegen.dispatch.TemplateRegistry;
import org.eclipse.gmf.internal.common.codegen.BinaryEmitter;
import org.eclipse.gmf.internal.common.codegen.DefaultTextMerger;
import org.eclipse.gmf.internal.common.codegen.JETEmitterAdapter;
import org.eclipse.gmf.internal.common.codegen.JETGIFEmitterAdapter;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.TextMerger;
import org.eclipse.gmf.internal.common.codegen.XpandTextEmitter;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.util.BundleResourceManager;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodegenEmitters {
    private static final String PATH_SEPARATOR = "::";
    private static final String TEMPLATES_PLUGIN_ID = "org.eclipse.gmf.codegen";
    private final EmitterFactory myFactory;
    private final String[] myTemplatePath;
    private ResourceManager myResourceManager;

    public CodegenEmitters(boolean usePrecompiled, String templateDirectory) {
        this(usePrecompiled, templateDirectory, CodegenEmitters.getDefaultVariables(), new StaticTemplateRegistry(CodegenEmitters.class.getClassLoader()));
    }

    public CodegenEmitters(boolean usePrecompiled, String templateDirectory, String[] variables, StaticTemplateRegistry registry) {
        URL baseURL = CodegenEmitters.getTemplatesBundle().getEntry("/templates/");
        URL dynamicURL = usePrecompiled ? null : CodegenEmitters.getDynamicTemplatesURL(templateDirectory);
        this.myTemplatePath = new String[]{dynamicURL != null ? dynamicURL.toString() : null, baseURL.toString()};
        this.myFactory = new CachingEmitterFactory((EmitterFactory)new EmitterFactoryImpl(this.getTemplatePath(), (TemplateRegistry)registry, usePrecompiled, variables));
        this.myResourceManager = dynamicURL == null ? new BundleResourceManager(new URL[]{baseURL}) : new BundleResourceManager(new URL[]{dynamicURL, baseURL});
    }

    public TextMerger createMergeService() {
        URL controlFile = this.getJMergeControlFile();
        if (controlFile != null) {
            JControlModel controlModel = new JControlModel();
            controlModel.initialize(CodeGenUtil.instantiateFacadeHelper((String)JMerger.DEFAULT_FACADE_HELPER_CLASS), controlFile.toString());
            if (!controlModel.canMerge()) {
                throw new IllegalStateException("Can not initialize JControlModel");
            }
            return new DefaultTextMerger(controlModel);
        }
        return null;
    }

    public TextEmitter retrieve(Class<?> key) throws UnexpectedBehaviourException {
        try {
            return new JETEmitterAdapter(this.myFactory.acquireEmitter(key));
        }
        catch (NoSuchTemplateException ex) {
            throw new UnexpectedBehaviourException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String[] getTemplatePath() {
        return this.myTemplatePath;
    }

    private static Bundle getTemplatesBundle() {
        return Platform.getBundle((String)TEMPLATES_PLUGIN_ID);
    }

    private static URL getDynamicTemplatesURL(String templateDirectory) {
        if (templateDirectory != null) {
            URI templatesURI = templateDirectory.indexOf(":") == -1 ? URI.createPlatformResourceURI((String)templateDirectory, (boolean)true) : URI.createURI((String)templateDirectory);
            try {
                return new URL(CommonPlugin.resolve((URI)templatesURI).toString());
            }
            catch (MalformedURLException e) {
                String pluginID = TEMPLATES_PLUGIN_ID;
                Platform.getLog((Bundle)Platform.getBundle((String)pluginID)).log((IStatus)new Status(4, pluginID, 0, "Incorrecct dynamic templates location", (Throwable)e));
            }
        }
        return null;
    }

    public URL getJMergeControlFile() {
        return CodegenEmitters.getTemplatesBundle().getEntry("/templates/emf-merge.xml");
    }

    public TextEmitter getCreateNodeCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::CreateNodeCommand");
    }

    public TextEmitter getCreateLinkCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::CreateLinkCommand");
    }

    public TextEmitter getCreateRefLinkCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::CreateRefLinkCommand");
    }

    public TextEmitter getReorientLinkCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::ReorientLinkCommand");
    }

    public TextEmitter getReorientRefLinkCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::ReorientRefLinkCommand");
    }

    public TextEmitter getReorientLinkViewCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::ReorientLinkViewCommand");
    }

    public TextEmitter getCreateShortcutDecorationsCommandEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::commands::CreateShortcutDecorationsCommand");
    }

    public TextEmitter getBaseEditHelperEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::edithelpers::BaseEditHelper");
    }

    public TextEmitter getEditHelperEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::edithelpers::EditHelper");
    }

    public TextEmitter getEditHelperAdviceEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::edithelpers::EditHelperAdvice");
    }

    public TextEmitter getDiagramEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::DiagramEditPart");
    }

    public TextEmitter getNodeEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::NodeEditPart");
    }

    public TextEmitter getNodeLabelEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::NodeLabelEditPart");
    }

    public TextEmitter getExternalNodeLabelEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::ExternalNodeLabelEditPart");
    }

    public TextEmitter getChildNodeLabelEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::ChildNodeLabelEditPart");
    }

    public TextEmitter getCompartmentEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::CompartmentEditPart");
    }

    public TextEmitter getLinkEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::LinkEditPart");
    }

    public TextEmitter getLinkLabelEditPartEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::LinkLabelEditPart");
    }

    public TextEmitter getEditPartFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editparts::EditPartFactory");
    }

    public TextEmitter getBaseItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::BaseItemSemanticEditPolicy");
    }

    public TextEmitter getOpenDiagramEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::OpenDiagram");
    }

    public TextEmitter getDiagramCanonicalEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::DiagramCanonicalEditPolicy");
    }

    public TextEmitter getChildContainerCanonicalEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::ChildContainerCanonicalEditPolicy");
    }

    public TextEmitter getDiagramItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::DiagramItemSemanticEditPolicy");
    }

    public TextEmitter getCompartmentItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::CompartmentItemSemanticEditPolicy");
    }

    public TextEmitter getGraphicalNodeEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::GraphicalNodeEditPolicy");
    }

    public TextEmitter getNodeItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::NodeItemSemanticEditPolicy");
    }

    public TextEmitter getLinkItemSemanticEditPolicyEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::editpolicies::LinkItemSemanticEditPolicy");
    }

    public TextEmitter getTextSelectionEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::diagram::editpolicies::TextFeedback::TextSelectionEditPolicy");
    }

    public TextEmitter getTextNonResizableEditPolicyEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::diagram::editpolicies::TextFeedback::TextNonResizableEditPolicy");
    }

    public TextEmitter getDiagramViewFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::views::DiagramViewFactory");
    }

    public TextEmitter getNodeViewFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::views::NodeViewFactory");
    }

    public TextEmitter getLabelNodeViewFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::views::LabelNodeViewFactory");
    }

    public TextEmitter getCompartmentViewFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::views::CompartmentViewFactory");
    }

    public TextEmitter getLinkViewFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::views::LinkViewFactory");
    }

    public TextEmitter getFloatingLabelViewFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::views::FloatingLabelViewFactory");
    }

    public TextEmitter getLabelViewFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::views::LabelViewFactory");
    }

    public TextEmitter getDiagramUpdaterEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::updater::DiagramUpdater");
    }

    public TextEmitter getUpdateCommandEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::updater::UpdateCommand");
    }

    public TextEmitter getNodeDescriptorEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::updater::NodeDescriptor");
    }

    public TextEmitter getLinkDescriptorEmitter() {
        return this.getPrimaryEmitter("xpt::diagram::updater::LinkDescriptor");
    }

    public TextEmitter getAbstractParserEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::parsers::AbstractParser");
    }

    public String getAbstractParserName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::parsers::AbstractParser", input);
    }

    public TextEmitter getCompositeParserEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::parsers::CompositeParser");
    }

    public String getCompositeParserName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::parsers::CompositeParser", input);
    }

    public TextEmitter getMessageFormatParserEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::parsers::MessageFormatParser");
    }

    public String getMessageFormatParserName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::parsers::MessageFormatParser", input);
    }

    public TextEmitter getNativeParserEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::parsers::NativeParser");
    }

    public String getNativeParserName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::parsers::NativeParser", input);
    }

    public TextEmitter getPrintfParserEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::parsers::PrintfParser");
    }

    public String getPrintfParserName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::parsers::PrintfParser", input);
    }

    public TextEmitter getRegexpParserEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::parsers::RegexpParser");
    }

    public String getRegexpParserName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::parsers::RegexpParser", input);
    }

    public TextEmitter getParserProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ParserProvider");
    }

    public TextEmitter getElementInitializersEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ElementInitializers");
    }

    public TextEmitter getElementTypesEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ElementTypes");
    }

    public TextEmitter getViewProviderEmitter() {
        return this.getPrimaryEmitter("xpt::providers::ViewProvider");
    }

    public TextEmitter getEditPartProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::EditPartProvider");
    }

    public TextEmitter getContributionItemProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ContributionItemProvider");
    }

    public TextEmitter getModelingAssistantProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ModelingAssistantProvider");
    }

    public TextEmitter getIconProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::IconProvider");
    }

    public TextEmitter getMarkerNavigationProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::MarkerNavigationProvider");
    }

    public TextEmitter getValidationProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ValidationProvider");
    }

    public TextEmitter getValidationDecoratorProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::ValidationDecoratorProvider");
    }

    public TextEmitter getShortcutsDecoratorProviderEmitter() {
        return this.getPrimaryEmitter("xpt::providers::ShortcutsDecoratorProvider");
    }

    public TextEmitter getMetricProviderEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::providers::MetricProvider");
    }

    public TextEmitter getAbstractExpressionEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::expressions::AbstractExpression");
    }

    public TextEmitter getOCLExpressionFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::expressions::OCLExpressionFactory");
    }

    public TextEmitter getRegexpExpressionFactoryEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::expressions::RegexpExpressionFactory");
    }

    public TextEmitter getPropertySheetLabelProviderEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::propsheet::LabelProvider::Class");
    }

    public TextEmitter getPropertySectionEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::propsheet::PropertySection::Class");
    }

    public TextEmitter getValidateActionEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ValidateAction");
    }

    public String getValidateActionName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::ValidateAction", input);
    }

    public TextEmitter getValidationMarkerEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ValidationMarker");
    }

    public String getValidationMarkerName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::ValidationMarker", input);
    }

    public TextEmitter getDiagramContentInitializerEmitter() {
        return this.getPrimaryEmitter("xpt::editor::DiagramContentInitializer");
    }

    public TextEmitter getShortcutPropertyTesterEmitter() {
        return this.getPrimaryEmitter("xpt::editor::ShortcutPropertyTester");
    }

    public String getShortcutCreationWizardName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::ShortcutCreationWizard", input);
    }

    public TextEmitter getShortcutCreationWizardEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ShortcutCreationWizard");
    }

    public String getModelElementSelectionPageName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::ModelElementSelectionPage", input);
    }

    public TextEmitter getModelElementSelectionPageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ModelElementSelectionPage");
    }

    public String getInitDiagramFileActionName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::InitDiagramFileAction", input);
    }

    public TextEmitter getInitDiagramFileActionEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::InitDiagramFileAction");
    }

    public String getNewDiagramFileWizardName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::editor::NewDiagramFileWizard", input);
    }

    public TextEmitter getNewDiagramFileWizardEmitter() {
        return this.getPrimaryEmitter("xpt::editor::NewDiagramFileWizard");
    }

    public TextEmitter getPaletteEmitter() throws UnexpectedBehaviourException {
        return this.newXpandEmitter("xpt::editor::palette::PaletteFactory::Factory");
    }

    public TextEmitter getDiagramEditorUtilEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::DiagramEditorUtil");
    }

    public TextEmitter getVisualIDRegistryEmitter() {
        return this.getPrimaryEmitter("xpt::editor::VisualIDRegistry");
    }

    public TextEmitter getCreationWizardEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::CreationWizard");
    }

    public TextEmitter getCreationWizardPageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::CreationWizardPage");
    }

    public TextEmitter getEditorEmitter() {
        return this.getPrimaryEmitter("xpt::editor::Editor");
    }

    public TextEmitter getCreateShortcutActionEmitter() {
        return this.getPrimaryEmitter("xpt::editor::CreateShortcutAction");
    }

    public TextEmitter getLoadResourceActionEmitter() {
        return this.getPrimaryEmitter("xpt::editor::LoadResourceAction");
    }

    public TextEmitter getElementChooserEmitter() {
        return this.getPrimaryEmitter("xpt::editor::ElementChooser");
    }

    public TextEmitter getDocumentProviderEmitter() {
        return this.getPrimaryEmitter("xpt::editor::DocumentProvider");
    }

    public TextEmitter getActionBarContributorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::editor::ActionBarContributor");
    }

    public TextEmitter getMatchingStrategyEmitter() {
        return this.getPrimaryEmitter("xpt::editor::MatchingStrategy");
    }

    public TextEmitter getDomainModelElementTesterEmitter() {
        return this.getPrimaryEmitter("xpt::editor::DomainModelElementTester");
    }

    public TextEmitter getURIEditorInputTesterEmitter() {
        return this.getPrimaryEmitter("xpt::editor::UriEditorInputTester");
    }

    public BinaryEmitter getShortcutImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/editor/shortcut.gif");
    }

    public BinaryEmitter getDiagramIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/diagram.gif");
    }

    public BinaryEmitter getWizardBannerImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/wizban.gif");
    }

    public TextEmitter getNavigatorContentProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorContentProvider");
    }

    public TextEmitter getDomainNavigatorContentProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::DomainNavigatorContentProvider");
    }

    public TextEmitter getDomainNavigatorLabelProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::DomainNavigatorLabelProvider");
    }

    public TextEmitter getDomainNavigatorItemEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::DomainNavigatorItem");
    }

    public TextEmitter getNavigatorLabelProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorLabelProvider");
    }

    public TextEmitter getNavigatorLinkHelperEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorLinkHelper");
    }

    public TextEmitter getNavigatorSorterEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorSorter");
    }

    public TextEmitter getNavigatorActionProviderEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorActionProvider");
    }

    public TextEmitter getAbstractNavigatorItemEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::AbstractNavigatorItem");
    }

    public TextEmitter getNavigatorGroupEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorGroup");
    }

    public TextEmitter getNavigatorItemEmitter() {
        return this.getPrimaryEmitter("xpt::navigator::NavigatorItem");
    }

    public BinaryEmitter getGroupIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/navigator/navigatorGroup.gif");
    }

    public TextEmitter getPreferenceInitializerEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::preferences::PreferenceInitializer");
    }

    public String getPreferenceInitializerName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::diagram::preferences::PreferenceInitializer", input);
    }

    public TextEmitter getAppearancePreferencePageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::preferences::AppearancePreferencePage");
    }

    public String getAppearancePreferencePageName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::diagram::preferences::AppearancePreferencePage", input);
    }

    public TextEmitter getConnectionsPreferencePageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::preferences::ConnectionsPreferencePage");
    }

    public String getConnectionsPreferencePageName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::diagram::preferences::ConnectionsPreferencePage", input);
    }

    public TextEmitter getGeneralPreferencePageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::preferences::GeneralPreferencePage");
    }

    public String getGeneralPreferencePageName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::diagram::preferences::GeneralPreferencePage", input);
    }

    public TextEmitter getPrintingPreferencePageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::preferences::PrintingPreferencePage");
    }

    public String getPrintingPreferencePageName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::diagram::preferences::PrintingPreferencePage", input);
    }

    public TextEmitter getRulersAndGridPreferencePageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::diagram::preferences::RulersAndGridPreferencePage");
    }

    public String getRulersAndGridPreferencePageName(Object ... input) throws UnexpectedBehaviourException {
        return this.getQualifiedClassName("xpt::diagram::preferences::RulersAndGridPreferencePage", input);
    }

    public TextEmitter getActivatorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::Activator");
    }

    public TextEmitter getBundleManifestEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::manifest");
    }

    public TextEmitter getPluginXmlEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::plugin");
    }

    public TextEmitter getPluginPropertiesEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::properties");
    }

    public TextEmitter getBuildPropertiesEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::build");
    }

    public TextEmitter getOptionsFileEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::plugin::options");
    }

    public TextEmitter getExternalizeEmitter() {
        return this.newXpandEmitter("xpt::Externalizer::Access");
    }

    public TextEmitter getMessagesEmitter() {
        return this.newXpandEmitter("xpt::Externalizer::Values");
    }

    public TextEmitter getApplicationEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::Application");
    }

    public TextEmitter getActionBarAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::ActionBarAdvisor");
    }

    public TextEmitter getPerspectiveEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::Perspective");
    }

    public TextEmitter getWorkbenchAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::WorkbenchAdvisor");
    }

    public TextEmitter getWorkbenchWindowAdvisorEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::WorkbenchWindowAdvisor");
    }

    public TextEmitter getWizardNewFileCreationPageEmitter() throws UnexpectedBehaviourException {
        return this.getPrimaryEmitter("xpt::application::WizardNewFileCreationPage");
    }

    private TextEmitter getPrimaryEmitter(String templateName) {
        String[] parts = templateName.split(PATH_SEPARATOR);
        String definition = String.valueOf(templateName) + PATH_SEPARATOR + parts[parts.length - 1];
        return this.newXpandEmitter(definition);
    }

    private TextEmitter getQualifiedClassNameEmitter(String templateName) throws UnexpectedBehaviourException {
        String definition = String.valueOf(templateName) + PATH_SEPARATOR + "qualifiedClassName";
        return this.newXpandEmitter(definition);
    }

    private String getText(TextEmitter emitter, Object ... input) throws UnexpectedBehaviourException {
        try {
            return emitter.generate((IProgressMonitor)new NullProgressMonitor(), input).trim();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException ite) {
            throw new UnexpectedBehaviourException(ite.getCause());
        }
    }

    private String getQualifiedClassName(String templateName, Object ... input) throws UnexpectedBehaviourException {
        TextEmitter emitter = this.getQualifiedClassNameEmitter(templateName);
        return this.getText(emitter, input);
    }

    private BinaryEmitter newGIFEmitter(String relativePath) throws UnexpectedBehaviourException {
        return new org.eclipse.gmf.internal.common.codegen.GIFEmitter(this.checkTemplateLocation(relativePath));
    }

    private BinaryEmitter newGIFEmitterAdapter(String relativePath) throws UnexpectedBehaviourException {
        return new JETGIFEmitterAdapter(new GIFEmitter(this.checkTemplateLocation(relativePath)));
    }

    private String checkTemplateLocation(String relativePath) throws UnexpectedBehaviourException {
        String templateLocation = JETCompiler.find((String[])this.getTemplatePath(), (String)relativePath);
        if (templateLocation == null) {
            throw new UnexpectedBehaviourException("Template " + relativePath + " not found");
        }
        return templateLocation;
    }

    protected TextEmitter newXpandEmitter(String definition) {
        return new XpandTextEmitter(this.myResourceManager, definition, this.getClass().getClassLoader());
    }

    protected static String[] getDefaultVariables() {
        return new String[]{"org.eclipse.emf.codegen", "org.eclipse.emf.codegen.ecore", "org.eclipse.emf.common", "org.eclipse.emf.ecore", "org.eclipse.gmf.common", TEMPLATES_PLUGIN_ID};
    }
}

