/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.parser;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.internal.CommonUIServicesPlugin;
import org.eclipse.gmf.runtime.common.ui.services.parser.GetParserOperation;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserProvider;

public class ParserService
extends Service
implements IParserProvider {
    private static final ParserService service = new ParserService();

    static {
        service.configureProviders(CommonUIServicesPlugin.getPluginId(), "parserProviders");
    }

    public static ParserService getInstance() {
        return service;
    }

    @Override
    public IParser getParser(IAdaptable hint) {
        return (IParser)this.executeUnique(ExecutionStrategy.FIRST, new GetParserOperation(hint));
    }

    public String getEditString(IAdaptable hint, int options) {
        String editString = null;
        IParser parser = service.getParser(hint);
        if (parser != null) {
            editString = parser.getEditString(hint, options);
        }
        if (editString == null) {
            editString = "";
        }
        return editString;
    }

    public String getPrintString(IAdaptable hint, int options) {
        IParser parser = service.getParser(hint);
        if (parser == null) {
            return "";
        }
        return parser.getPrintString(hint, options);
    }

    public String getPrintString(IAdaptable hint) {
        return this.getPrintString(hint, 0);
    }

    public boolean canEdit(IAdaptable hint) {
        String editString;
        IParser parser = service.getParser(hint);
        return parser != null && (editString = parser.getEditString(hint, 0)) != null;
    }
}

