/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public abstract class DiagramDropTargetListener
extends AbstractTransferDropTargetListener {
    public DiagramDropTargetListener(EditPartViewer viewer) {
        super(viewer);
        this.setEnablementDeterminedByCommand(true);
    }

    public DiagramDropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
        this.setEnablementDeterminedByCommand(true);
    }

    protected Request createTargetRequest() {
        return new DropObjectsRequest();
    }

    protected final DropObjectsRequest getDropObjectsRequest() {
        return (DropObjectsRequest)this.getTargetRequest();
    }

    protected abstract List getObjectsBeingDropped();

    public void dragEnter(DropTargetEvent event) {
        super.dragEnter(event);
        this.handleDragEnter();
    }

    protected void handleDragEnter() {
        this.handleDragOver();
    }

    protected void handleDragOperationChanged() {
        super.handleDragOperationChanged();
        if (this.getDropObjectsRequest().getRequiredDetail() != 0) {
            this.getCurrentEvent().detail = this.getDropObjectsRequest().getRequiredDetail();
        }
    }

    protected void handleDragOver() {
        super.handleDragOver();
        if (this.getDropObjectsRequest().getRequiredDetail() != 0) {
            this.getCurrentEvent().detail = this.getDropObjectsRequest().getRequiredDetail();
        }
        this.getCurrentEvent().feedback = 24;
    }

    protected void handleDrop() {
        this.getViewer().setCursor(Cursors.WAIT);
        super.handleDrop();
        this.getViewer().setCursor(null);
        this.selectAddedViews();
    }

    private void selectAddedViews() {
        Object result = this.getDropObjectsRequest().getResult();
        if (result == null || !(result instanceof Collection)) {
            return;
        }
        EditPartViewer viewer = this.getViewer();
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        for (Object view : (Collection)result) {
            EditPart editPart;
            if (!(view instanceof IAdaptable) || (editPart = (EditPart)viewer.getEditPartRegistry().get(((IAdaptable)view).getAdapter(View.class))) == null) continue;
            editParts.add(editPart);
        }
        if (!editParts.isEmpty()) {
            viewer.getControl().forceFocus();
            this.getViewer().flush();
            viewer.setSelection((ISelection)new StructuredSelection(editParts));
        }
    }

    protected void updateTargetRequest() {
        DropObjectsRequest request = this.getDropObjectsRequest();
        request.setLocation(this.getDropLocation());
        request.setObjects(this.getObjectsBeingDropped());
        request.setAllowedDetail(this.getCurrentEvent().operations);
    }

    public boolean isEnabled(DropTargetEvent event) {
        this.setCurrentEvent(event);
        this.updateTargetRequest();
        this.updateTargetEditPart();
        if (this.getTargetEditPart() == null) {
            return false;
        }
        if (this.isEnablementDeterminedByCommand() && this.isDataTransfered()) {
            Command command = this.getCommand();
            return command != null && command.canExecute();
        }
        return true;
    }

    protected boolean isDataTransfered() {
        return LocalSelectionTransfer.getTransfer().getSelection() != null || this.getCurrentEvent().data != null;
    }
}

