/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup.figures;

import java.util.Arrays;
import junit.framework.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BorderLayout;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.CustomAttribute;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.CustomLayout;
import org.eclipse.gmf.gmfgraph.CustomLayoutData;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureRef;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GridLayout;
import org.eclipse.gmf.gmfgraph.GridLayoutData;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.Layoutable;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.gmfgraph.XYLayoutData;
import org.eclipse.gmf.tests.setup.figures.AbstractFigureGeneratorSetup;
import org.eclipse.gmf.tests.setup.figures.FigureGeneratorUtil;

public class FigureLayoutSetup
extends AbstractFigureGeneratorSetup {
    private RealFigure myParent;
    private RealFigure myParent1;
    private RealFigure myParent2;
    private RealFigure myParent3;
    private RealFigure myGroup;
    private RealFigure myGroup1;
    private RealFigure myGroup2;
    private RealFigure myGroup3;
    private RealFigure myGroup4;
    private CustomFigure myGroup5;
    private RealFigure myParent4;
    private RealFigure myParent5;
    private RealFigure myParent6;
    private RealFigure myParent7;
    private RealFigure myParent8;
    private RealFigure myParent9;
    private RealFigure myFigureWithCustomLayoutData;

    protected void addFigures(FigureGallery gallery) {
        gallery.getFigures().add((Object)this.getParent());
        gallery.getFigures().add((Object)this.getParent1());
        gallery.getFigures().add((Object)this.getParent2());
        gallery.getFigures().add((Object)this.getParent3());
        gallery.getFigures().add((Object)this.getParent4());
        gallery.getFigures().add((Object)this.getParent5());
        gallery.getFigures().add((Object)this.getParent6());
        gallery.getFigures().add((Object)this.getParent7());
        gallery.getFigures().add((Object)this.getParent8());
        gallery.getFigures().add((Object)this.getGroup());
        gallery.getFigures().add((Object)this.getGroup1());
        gallery.getFigures().add((Object)this.getGroup2());
        gallery.getFigures().add((Object)this.getGroup3());
        gallery.getFigures().add((Object)this.getGroup4());
        gallery.getFigures().add((Object)this.getGroup5());
        gallery.getFigures().add((Object)this.getFigureWithCustomLayoutData());
    }

    public RealFigure getGroup5() {
        if (this.myGroup5 == null) {
            this.myGroup5 = GMFGraphFactory.eINSTANCE.createCustomFigure();
            this.myGroup5.setQualifiedClassName("org.eclipse.draw2d.Layer");
            this.myGroup5.setName("CustomLayer");
            Rectangle left = GMFGraphFactory.eINSTANCE.createRectangle();
            left.setName("Left");
            this.myGroup5.getChildren().add((Object)left);
            RoundedRectangle right = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
            right.setName("Right");
            this.myGroup5.getChildren().add((Object)right);
            this.setupXYLayout((RealFigure)this.myGroup5, (Layoutable)left, (Layoutable)right);
        }
        return this.myGroup5;
    }

    public RealFigure getGroup4() {
        if (this.myGroup4 == null) {
            this.myGroup4 = this.createRGBGroup("XY");
            Figure left = (Figure)this.myGroup4.getChildren().get(0);
            Figure right = (Figure)this.myGroup4.getChildren().get(1);
            this.setupXYLayout(this.myGroup4, (Layoutable)left, (Layoutable)right);
        }
        return this.myGroup4;
    }

    public RealFigure getGroup3() {
        if (this.myGroup3 == null) {
            this.myGroup3 = this.createRGBGroup("Toolbar");
            FlowLayout flowLayout = GMFGraphFactory.eINSTANCE.createFlowLayout();
            flowLayout.setForceSingleLine(true);
            flowLayout.setMajorSpacing(11);
            flowLayout.setMinorAlignment(Alignment.END_LITERAL);
            this.myGroup3.setLayout((Layout)flowLayout);
        }
        return this.myGroup3;
    }

    public RealFigure getGroup2() {
        if (this.myGroup2 == null) {
            this.myGroup2 = this.createRGBGroup("ToolbarBadConfig");
            FlowLayout flowLayout = GMFGraphFactory.eINSTANCE.createFlowLayout();
            flowLayout.setForceSingleLine(true);
            flowLayout.setMinorSpacing(23456);
            flowLayout.setMajorAlignment(Alignment.FILL_LITERAL);
            this.myGroup2.setLayout((Layout)flowLayout);
        }
        return this.myGroup2;
    }

    public RealFigure getGroup1() {
        if (this.myGroup1 == null) {
            this.myGroup1 = this.createRGBGroup("Flow");
            FlowLayout flowLayout = GMFGraphFactory.eINSTANCE.createFlowLayout();
            flowLayout.setVertical(false);
            flowLayout.setForceSingleLine(false);
            flowLayout.setMinorAlignment(Alignment.END_LITERAL);
            flowLayout.setMajorAlignment(Alignment.FILL_LITERAL);
            flowLayout.setMinorSpacing(23);
            flowLayout.setMinorSpacing(32);
            this.myGroup1.setLayout((Layout)flowLayout);
        }
        return this.myGroup1;
    }

    public RealFigure getGroup() {
        if (this.myGroup == null) {
            this.myGroup = this.createRGBGroup("Stack");
            this.myGroup.setLayout((Layout)GMFGraphFactory.eINSTANCE.createStackLayout());
        }
        return this.myGroup;
    }

    public RealFigure getParent9() {
        if (this.myParent9 == null) {
            CustomLayout layout = GMFGraphFactory.eINSTANCE.createCustomLayout();
            layout.setQualifiedClassName("com.borland.layouts.TheBestLayoutManagerForever");
            CustomAttribute normalAttr = GMFGraphFactory.eINSTANCE.createCustomAttribute();
            normalAttr.setDirectAccess(false);
            normalAttr.setMultiStatementValue(false);
            normalAttr.setName("UnlimateAnswer");
            normalAttr.setValue("42");
            layout.getAttributes().add((Object)normalAttr);
            CustomAttribute directAttr = GMFGraphFactory.eINSTANCE.createCustomAttribute();
            directAttr.setDirectAccess(true);
            directAttr.setMultiStatementValue(false);
            directAttr.setName("DirectUltimateAnswer");
            directAttr.setValue("this.getUltimateAnswer() - 6 * 7");
            layout.getAttributes().add((Object)directAttr);
            CustomAttribute multiAttr = GMFGraphFactory.eINSTANCE.createCustomAttribute();
            multiAttr.setDirectAccess(false);
            multiAttr.setMultiStatementValue(true);
            multiAttr.setName("MultiStatementParameter");
            multiAttr.setValue("int {0}; if (Boolean.TRUE.booleanValue()) '{' {0} = 42; } else '{' {0} = -42; } ");
            layout.getAttributes().add((Object)multiAttr);
            this.myParent9 = GMFGraphFactory.eINSTANCE.createRectangle();
            this.myParent9.setName("CarefullyLayouted");
            this.myParent9.setLayout((Layout)layout);
        }
        return this.myParent9;
    }

    public RealFigure getFigureWithCustomLayoutData() {
        if (this.myFigureWithCustomLayoutData == null) {
            this.myFigureWithCustomLayoutData = GMFGraphFactory.eINSTANCE.createRectangle();
            this.myFigureWithCustomLayoutData.setName("MyFigureWithCustomLayoutData");
            Rectangle fig = GMFGraphFactory.eINSTANCE.createRectangle();
            fig.setName("ActualDataOwner");
            CustomLayoutData ld = GMFGraphFactory.eINSTANCE.createCustomLayoutData();
            ld.setQualifiedClassName("org.eclipse.draw2d.geometry.Point");
            CustomAttribute normalAttr = GMFGraphFactory.eINSTANCE.createCustomAttribute();
            normalAttr.setDirectAccess(false);
            normalAttr.setMultiStatementValue(false);
            normalAttr.setName("location");
            normalAttr.setValue("11,12");
            ld.getAttributes().add((Object)normalAttr);
            CustomAttribute directAttr = GMFGraphFactory.eINSTANCE.createCustomAttribute();
            directAttr.setDirectAccess(true);
            directAttr.setMultiStatementValue(false);
            directAttr.setName("x");
            directAttr.setValue("5");
            ld.getAttributes().add((Object)directAttr);
            this.myFigureWithCustomLayoutData.setLayout((Layout)GMFGraphFactory.eINSTANCE.createXYLayout());
            fig.setLayoutData((LayoutData)ld);
            this.myFigureWithCustomLayoutData.getChildren().add((Object)fig);
        }
        return this.myFigureWithCustomLayoutData;
    }

    public RealFigure getParent8() {
        if (this.myParent8 == null) {
            RealFigure actualContainer = FigureLayoutSetup.createFigure2();
            RealFigure referencedFigure = (RealFigure)actualContainer.getChildren().get(0);
            this.myParent8 = GMFGraphFactory.eINSTANCE.createRectangle();
            this.myParent8.setName("ReferencedFigureParent");
            this.myParent8.setLayout((Layout)this.createGridLayoutAllProperties());
            FigureRef refChildA = GMFGraphFactory.eINSTANCE.createFigureRef();
            refChildA.setFigure(referencedFigure);
            refChildA.setLayoutData((LayoutData)this.createGridLayoutDataAllProperties(false));
            FigureRef refChildB = GMFGraphFactory.eINSTANCE.createFigureRef();
            refChildB.setFigure((RealFigure)actualContainer.getChildren().get(1));
            refChildB.setLayoutData((LayoutData)this.createGridLayoutDataAllProperties(true));
            this.myParent8.getChildren().add((Object)refChildA);
            this.myParent8.getChildren().add((Object)refChildB);
        }
        return this.myParent8;
    }

    public RealFigure getParent7() {
        if (this.myParent7 == null) {
            this.myParent7 = GMFGraphFactory.eINSTANCE.createEllipse();
            this.myParent7.setName("GenEllipse");
            this.myParent7.setLayout((Layout)GMFGraphFactory.eINSTANCE.createGridLayout());
            Label top = GMFGraphFactory.eINSTANCE.createLabel();
            top.setName("Top");
            top.setLayoutData((LayoutData)GMFGraphFactory.eINSTANCE.createGridLayoutData());
            this.myParent7.getChildren().add((Object)top);
            RoundedRectangle bottom = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
            bottom.setName("Bottom");
            bottom.setLayoutData((LayoutData)GMFGraphFactory.eINSTANCE.createGridLayoutData());
            this.myParent7.getChildren().add((Object)bottom);
        }
        return this.myParent7;
    }

    public RealFigure getParent6() {
        if (this.myParent6 == null) {
            this.myParent6 = FigureLayoutSetup.createFigure1();
            this.myParent6.setName("Parent");
            GridLayout layout = this.createGridLayoutAllProperties();
            layout.setNumColumns(1);
            layout.setEqualWidth(false);
            this.myParent6.setLayout((Layout)layout);
            for (Figure next : this.myParent6.getChildren()) {
                GridLayoutData data = this.createGridLayoutDataAllProperties(false);
                data.setHorizontalAlignment(Alignment.FILL_LITERAL);
                data.setOwner((Layoutable)next);
                Assert.assertEquals((String)"data-owner relation should be bidirectional", (Object)data, (Object)next.getLayoutData());
            }
        }
        return this.myParent6;
    }

    public RealFigure getParent5() {
        if (this.myParent5 == null) {
            this.myParent5 = FigureLayoutSetup.createFigure2();
            this.myParent5.setName("Parent5");
            EList children = this.myParent5.getChildren();
            Assert.assertFalse((String)"Precondition -- children required to test layout", (boolean)children.isEmpty());
            this.myParent5.setLayout((Layout)this.createGridLayoutAllProperties());
            boolean oddChild = false;
            for (Figure next : children) {
                oddChild = !oddChild;
                GridLayoutData data = this.createGridLayoutDataAllProperties(oddChild);
                next.setLayoutData((LayoutData)data);
                Assert.assertEquals((String)"data-owner relation should be bidirectional", (Object)next, (Object)data.getOwner());
            }
        }
        return this.myParent5;
    }

    public RealFigure getParent4() {
        if (this.myParent4 == null) {
            this.myParent4 = FigureLayoutSetup.createFigure2();
            this.myParent4.setName("Parent4");
            this.myParent4.setLayout((Layout)this.createGridLayoutAllProperties());
        }
        return this.myParent4;
    }

    public RealFigure getParent3() {
        if (this.myParent3 == null) {
            this.myParent3 = GMFGraphFactory.eINSTANCE.createRectangle();
            this.myParent3.setName("Matreshka");
            LayoutData[] allAreCenters = new LayoutData[]{this.createLayoutData(Alignment.CENTER_LITERAL, true), this.createLayoutData(Alignment.CENTER_LITERAL, false), this.createLayoutData(Alignment.FILL_LITERAL, true), this.createLayoutData(Alignment.FILL_LITERAL, false)};
            RealFigure nextParent = this.myParent3;
            int i = 0;
            while (i < allAreCenters.length) {
                BorderLayout layout = GMFGraphFactory.eINSTANCE.createBorderLayout();
                layout.setSpacing(FigureGeneratorUtil.createDimension(4, 2));
                nextParent.setLayout((Layout)layout);
                Rectangle child = GMFGraphFactory.eINSTANCE.createRectangle();
                child.setName("Doll" + (i + 1));
                child.setLayoutData(allAreCenters[i]);
                nextParent.getChildren().add((Object)child);
                nextParent = child;
                ++i;
            }
        }
        return this.myParent3;
    }

    public RealFigure getParent2() {
        if (this.myParent2 == null) {
            this.myParent2 = GMFGraphFactory.eINSTANCE.createRectangle();
            this.myParent2.setName("BorderedContents");
            BorderLayout layout = GMFGraphFactory.eINSTANCE.createBorderLayout();
            layout.setSpacing(FigureGeneratorUtil.createDimension(2, 4));
            this.myParent2.setLayout((Layout)layout);
            RoundedRectangle centerA = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
            centerA.setName("Center_1");
            centerA.setLayoutData((LayoutData)this.createLayoutData(Alignment.CENTER_LITERAL, false));
            RoundedRectangle left = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
            left.setName("Left");
            left.setLayoutData((LayoutData)this.createLayoutData(Alignment.BEGINNING_LITERAL, false));
            RoundedRectangle right = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
            right.setName("Right");
            right.setLayoutData((LayoutData)this.createLayoutData(Alignment.END_LITERAL, false));
            RoundedRectangle top = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
            top.setName("Top");
            top.setLayoutData((LayoutData)this.createLayoutData(Alignment.BEGINNING_LITERAL, true));
            RoundedRectangle bottom = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
            bottom.setName("Bottom");
            bottom.setLayoutData((LayoutData)this.createLayoutData(Alignment.END_LITERAL, true));
            this.myParent2.getChildren().addAll(Arrays.asList(top, bottom, left, right, centerA));
        }
        return this.myParent2;
    }

    public RealFigure getParent1() {
        if (this.myParent1 == null) {
            this.myParent1 = GMFGraphFactory.eINSTANCE.createRectangle();
            this.myParent1.setName("ParentWithoutLayout");
            Assert.assertNull((Object)this.myParent1.getLayout());
            Rectangle child = GMFGraphFactory.eINSTANCE.createRectangle();
            child.setName("childWithLayoutData");
            child.setLayoutData((LayoutData)this.createGridLayoutDataAllProperties(false));
            this.myParent1.getChildren().add((Object)child);
        }
        return this.myParent1;
    }

    public RealFigure getParent() {
        if (this.myParent == null) {
            this.myParent = GMFGraphFactory.eINSTANCE.createRectangle();
            this.myParent.setName("Root");
            RealFigure next = this.myParent;
            int i = 0;
            while (i < 4) {
                next = this.addPairOfChildRectanglesAndReturnLeft(next);
                ++i;
            }
        }
        return this.myParent;
    }

    private RealFigure addPairOfChildRectanglesAndReturnLeft(RealFigure parent) {
        parent.setLayout((Layout)this.createBorderLayoutAllProperties());
        Rectangle left = GMFGraphFactory.eINSTANCE.createRectangle();
        left.setName(String.valueOf(parent.getName()) + "_1");
        left.setLayoutData((LayoutData)this.createBorderLayoutDataAllProperties(Alignment.BEGINNING_LITERAL, false));
        parent.getChildren().add((Object)left);
        Rectangle right = GMFGraphFactory.eINSTANCE.createRectangle();
        right.setName(String.valueOf(parent.getName()) + "_2");
        right.setLayoutData((LayoutData)this.createBorderLayoutDataAllProperties(Alignment.END_LITERAL, false));
        parent.getChildren().add((Object)right);
        return left;
    }

    private GridLayout createGridLayoutAllProperties() {
        GridLayout layout = GMFGraphFactory.eINSTANCE.createGridLayout();
        layout.setEqualWidth(true);
        layout.setNumColumns(2);
        layout.setMargins(FigureGeneratorUtil.createDimension(5, 10));
        layout.setSpacing(FigureGeneratorUtil.createDimension(7, 8));
        return layout;
    }

    private BorderLayout createBorderLayoutAllProperties() {
        BorderLayout result = GMFGraphFactory.eINSTANCE.createBorderLayout();
        result.setSpacing(FigureGeneratorUtil.createDimension(11, 12));
        return result;
    }

    private BorderLayoutData createBorderLayoutDataAllProperties(Alignment alignment, boolean isVertical) {
        BorderLayoutData result = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
        result.setAlignment(alignment);
        result.setVertical(isVertical);
        return result;
    }

    private GridLayoutData createGridLayoutDataAllProperties(boolean horizontalBeginningNotEnd) {
        GridLayoutData data = GMFGraphFactory.eINSTANCE.createGridLayoutData();
        data.setGrabExcessHorizontalSpace(true);
        data.setGrabExcessVerticalSpace(false);
        data.setHorizontalAlignment(horizontalBeginningNotEnd ? Alignment.BEGINNING_LITERAL : Alignment.END_LITERAL);
        data.setVerticalAlignment(Alignment.CENTER_LITERAL);
        data.setHorizontalIndent(5);
        data.setHorizontalSpan(1);
        data.setVerticalSpan(1);
        return data;
    }

    private BorderLayoutData createLayoutData(Alignment alignment, boolean isVertical) {
        BorderLayoutData result = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
        result.setAlignment(alignment);
        result.setVertical(isVertical);
        return result;
    }

    private RealFigure createRGBGroup(String rootName) {
        Rectangle parent = GMFGraphFactory.eINSTANCE.createRectangle();
        parent.setForegroundColor((Color)FigureGeneratorUtil.createRGBColor(0, 0, 255));
        parent.setName(rootName);
        Ellipse greenEllipse = GMFGraphFactory.eINSTANCE.createEllipse();
        greenEllipse.setName("GreenEllipse");
        greenEllipse.setForegroundColor((Color)FigureGeneratorUtil.createRGBColor(0, 255, 0));
        RoundedRectangle redRRectangle = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        redRRectangle.setName("RedRoundedRectangle");
        redRRectangle.setForegroundColor((Color)FigureGeneratorUtil.createRGBColor(255, 0, 0));
        parent.getChildren().add((Object)greenEllipse);
        parent.getChildren().add((Object)redRRectangle);
        return parent;
    }

    private void setupXYLayout(RealFigure group, Layoutable left, Layoutable right) {
        Assert.assertTrue((boolean)group.getChildren().contains((Object)left));
        Assert.assertTrue((boolean)group.getChildren().contains((Object)right));
        Assert.assertNotSame((Object)left, (Object)right);
        group.setLayout((Layout)GMFGraphFactory.eINSTANCE.createXYLayout());
        XYLayoutData leftDataCorrect = GMFGraphFactory.eINSTANCE.createXYLayoutData();
        leftDataCorrect.setTopLeft(FigureGeneratorUtil.createPoint(12, 13));
        leftDataCorrect.setSize(FigureGeneratorUtil.createDimension(20, 30));
        leftDataCorrect.setOwner(left);
        XYLayoutData rightDataIncomplete = GMFGraphFactory.eINSTANCE.createXYLayoutData();
        rightDataIncomplete.setSize(FigureGeneratorUtil.createDimension(30, 20));
        right.setLayoutData((LayoutData)rightDataIncomplete);
    }
}

