/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.type.ui.internal.providers;

import java.net.URL;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.ui.internal.providers.ElementTypeIconProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ElementTypeIconProviderTest
extends TestCase {
    private ElementTypeIconProvider fixture;
    static /* synthetic */ Class class$0;

    public ElementTypeIconProviderTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ElementTypeIconProviderTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.emf.type.ui.internal.providers.ElementTypeIconProviderTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected ElementTypeIconProvider getFixture() {
        return this.fixture;
    }

    protected void setFixture(ElementTypeIconProvider fixture) {
        this.fixture = fixture;
    }

    public void test_getIcon() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.gmf.tests.runtime.emf.type.ui");
        URL iconURL = bundle.getEntry("icons/icon.gif");
        ImageDescriptor iconImageDescriptor = ImageDescriptor.createFromURL((URL)iconURL);
        Image icon = iconImageDescriptor.createImage();
        byte[] iconData = icon.getImageData().data;
        this.setFixture(new ElementTypeIconProvider());
        IElementType iconType = ElementTypeRegistry.getInstance().getType("org.eclipse.gmf.tests.runtime.emf.type.ui.iconType");
        byte[] providerIconData = this.getFixture().getIcon((IAdaptable)iconType, (int)0).getImageData().data;
        ElementTypeIconProviderTest.assertTrue((boolean)Arrays.equals(iconData, providerIconData));
        icon.dispose();
    }

    public void test_getIconFromPlatformURI_144906() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.gmf.runtime.diagram.ui.geoshapes");
        URL iconURL = bundle.getEntry("icons/IconCircle.gif");
        ImageDescriptor iconImageDescriptor = ImageDescriptor.createFromURL((URL)iconURL);
        Image expectedIcon = iconImageDescriptor.createImage();
        byte[] iconData = expectedIcon.getImageData().data;
        this.setFixture(new ElementTypeIconProvider());
        IElementType iconType = ElementTypeRegistry.getInstance().getType("org.eclipse.gmf.tests.runtime.emf.type.ui.platformIconType");
        Image actualIcon = this.getFixture().getIcon((IAdaptable)iconType, 0);
        ElementTypeIconProviderTest.assertNotNull((Object)actualIcon);
        byte[] providerIconData = actualIcon.getImageData().data;
        ElementTypeIconProviderTest.assertTrue((boolean)Arrays.equals(iconData, providerIconData));
        expectedIcon.dispose();
    }
}

