/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.services.editpolicy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;
import org.eclipse.jface.util.Assert;

public class EditPolicyProviderConfiguration
extends AbstractProviderConfiguration {
    private static final String CONTEXT = "context";
    private static final String EDITPARTS = "editparts";
    private List contextDescriptors = new ArrayList();

    public static EditPolicyProviderConfiguration parse(IConfigurationElement configElement) {
        Assert.isNotNull((Object)configElement, (String)"null provider configuration element");
        return new EditPolicyProviderConfiguration(configElement);
    }

    private EditPolicyProviderConfiguration(IConfigurationElement configElement) {
        HashMap<String, AbstractProviderConfiguration.ObjectDescriptor> objects = new HashMap<String, AbstractProviderConfiguration.ObjectDescriptor>();
        IConfigurationElement[] configChildren = configElement.getChildren("object");
        int i = 0;
        while (i < configChildren.length) {
            String id = configChildren[i].getAttribute("id");
            if (id != null) {
                objects.put(id, new AbstractProviderConfiguration.ObjectDescriptor(configChildren[i]));
            }
            ++i;
        }
        configChildren = configElement.getChildren(CONTEXT);
        i = 0;
        while (i < configChildren.length) {
            List editParts = EditPolicyProviderConfiguration.getObjectList((String)configChildren[i].getAttribute(EDITPARTS), objects, (IConfigurationElement)configElement);
            if (editParts != null) {
                this.contextDescriptors.add(new ContextDescriptor(editParts));
            }
            ++i;
        }
    }

    public boolean supports(EditPart editPart) {
        if (this.contextDescriptors.isEmpty()) {
            return true;
        }
        Iterator iter = this.contextDescriptors.iterator();
        while (iter.hasNext()) {
            ContextDescriptor descriptor = (ContextDescriptor)iter.next();
            if (!descriptor.matches(editPart)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$0(Object object, List list) {
        return AbstractProviderConfiguration.objectMatches((Object)object, (List)list);
    }

    private static class ContextDescriptor {
        private final List editParts;

        public ContextDescriptor(List editParts) {
            this.editParts = editParts;
        }

        public boolean matches(EditPart editPart) {
            return this.editParts == null || EditPolicyProviderConfiguration.access$0(editPart, this.editParts);
        }
    }
}

