/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.gmf.internal.xpand.AbstractOutput;
import org.eclipse.gmf.internal.xpand.StreamsHolder;
import org.eclipse.gmf.internal.xpand.model.XpandStreamsHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferOutput
extends AbstractOutput {
    private final Stack<StringBuilder> outletStack;
    private final Stack<String> outletNamesStack;
    private final Map<String, StringBuilder> namedSlots;
    private final XpandStreamsHolder streamsHolder;
    private final boolean enforceReadOnlyAfterAccess;

    public BufferOutput(StringBuilder buffer) {
        this(buffer, null);
    }

    public BufferOutput(StringBuilder buffer, Map<String, StringBuilder> namedSlots) {
        this(buffer, namedSlots, false);
    }

    public BufferOutput(StringBuilder buffer, boolean enforceReadOnlyAfterRead) {
        this(buffer, null, enforceReadOnlyAfterRead);
    }

    public BufferOutput(StringBuilder buffer, Map<String, StringBuilder> namedSlots, boolean enforceReadOnlyAfterRead) {
        assert (buffer != null);
        this.outletStack = new Stack();
        this.outletStack.push(buffer);
        this.outletNamesStack = new Stack();
        this.streamsHolder = new XpandStreamsHolder();
        if (namedSlots == null) {
            this.namedSlots = new HashMap<String, StringBuilder>();
        } else {
            this.namedSlots = namedSlots;
            for (Map.Entry<String, StringBuilder> next : namedSlots.entrySet()) {
                this.streamsHolder.addNamedStream(next.getKey(), next.getValue());
            }
        }
        this.enforceReadOnlyAfterAccess = enforceReadOnlyAfterRead;
    }

    @Override
    public void closeFile() {
        if (this.outletStack.size() == 1) {
            String msg = "CLOSE FILE without previous openFile";
            System.err.println("<<<" + msg);
            throw new UnsupportedOperationException(msg);
        }
        this.checkAccessPermitted();
        this.outletStack.pop();
        this.outletNamesStack.pop();
    }

    private void checkAccessPermitted() {
        if (this.enforceReadOnlyAfterAccess && this.streamsHolder.isAccessed(this.outletNamesStack.peek())) {
            throw new UnsupportedOperationException("Cannot write to a stream after its contents have been accessed");
        }
    }

    @Override
    public void openFile(String path, String outletName) {
        if (!this.namedSlots.containsKey(outletName)) {
            StringBuilder newSlot = new StringBuilder();
            this.namedSlots.put(outletName, newSlot);
            this.streamsHolder.addNamedStream(outletName, newSlot);
        }
        this.outletStack.push(this.namedSlots.get(outletName));
        this.outletNamesStack.push(outletName);
        this.checkAccessPermitted();
        assert (this.outletStack.peek() != null);
    }

    @Override
    protected void doAppend(String text) {
        this.outletStack.peek().append(text);
    }

    @Override
    public StreamsHolder getNamedStreams() {
        return this.streamsHolder;
    }
}

