/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.BringForwardCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.commands.CommandTestFixture;

public class BringForwardCommandTest
extends CommandTestFixture {
    protected ICommand createCommand() {
        return new BringForwardCommand(this.getEditingDomain(), this.noteView);
    }

    public void testDoExecute() {
        BringForwardCommandTest.assertEquals((int)this.getDiagram().getChildren().size(), (int)1);
        View firstNote = (View)this.getDiagram().getChildren().get(0);
        BringForwardCommand zorderCommand = new BringForwardCommand(this.getEditingDomain(), firstNote);
        try {
            zorderCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            BringForwardCommandTest.fail((String)("command execution failure: " + e.getLocalizedMessage()));
        }
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(0), (Object)firstNote);
    }

    public void testFirstEntry() {
        this.createView();
        BringForwardCommandTest.assertEquals((int)this.getDiagram().getChildren().size(), (int)2);
        View firstNote = (View)this.getDiagram().getChildren().get(0);
        View secondNote = (View)this.getDiagram().getChildren().get(1);
        BringForwardCommand zorderCommand = new BringForwardCommand(this.getEditingDomain(), firstNote);
        try {
            zorderCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            BringForwardCommandTest.fail((String)("command execution failure: " + e.getLocalizedMessage()));
        }
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(0), (Object)secondNote);
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(1), (Object)firstNote);
    }

    public void testMiddleEntry() {
        this.createView();
        this.createView();
        BringForwardCommandTest.assertEquals((int)this.getDiagram().getChildren().size(), (int)3);
        View firstNote = (View)this.getDiagram().getChildren().get(0);
        View secondNote = (View)this.getDiagram().getChildren().get(1);
        View thirdNote = (View)this.getDiagram().getChildren().get(2);
        BringForwardCommand zorderCommand = new BringForwardCommand(this.getEditingDomain(), secondNote);
        try {
            zorderCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            BringForwardCommandTest.fail((String)("command execution failure: " + e.getLocalizedMessage()));
        }
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(0), (Object)firstNote);
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(1), (Object)thirdNote);
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(2), (Object)secondNote);
    }

    public void testBringToFront() {
        this.createView();
        this.createView();
        BringForwardCommandTest.assertEquals((int)this.getDiagram().getChildren().size(), (int)3);
        View firstNote = (View)this.getDiagram().getChildren().get(0);
        View secondNote = (View)this.getDiagram().getChildren().get(1);
        View thirdNote = (View)this.getDiagram().getChildren().get(2);
        BringForwardCommand zorderCommand = new BringForwardCommand(this.getEditingDomain(), firstNote);
        try {
            zorderCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            BringForwardCommandTest.fail((String)("command execution failure: " + e.getLocalizedMessage()));
        }
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(0), (Object)secondNote);
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(1), (Object)firstNote);
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(2), (Object)thirdNote);
        zorderCommand = new BringForwardCommand(this.getEditingDomain(), firstNote);
        try {
            zorderCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            BringForwardCommandTest.fail((String)("command execution failure: " + e.getLocalizedMessage()));
        }
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(0), (Object)secondNote);
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(1), (Object)thirdNote);
        BringForwardCommandTest.assertEquals((Object)this.getDiagram().getChildren().get(2), (Object)firstNote);
    }
}

