/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramUpdater;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphLinkDescriptor;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphNodeDescriptor;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphVisualIDRegistry;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class CanvasCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    Set myFeaturesToSynchronize;

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        Iterator it = GMFGraphDiagramUpdater.getCanvas_1000SemanticChildren(viewObject).iterator();
        while (it.hasNext()) {
            result.add(((GMFGraphNodeDescriptor)it.next()).getModelElement());
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return true;
    }

    protected boolean isOrphaned(Collection semanticChildren, View view) {
        if (view.getEAnnotation("Shortcut") != null) {
            return GMFGraphDiagramUpdater.isShortcutOrphaned(view);
        }
        int visualID = GMFGraphVisualIDRegistry.getVisualID(view);
        switch (visualID) {
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: {
                if (semanticChildren.contains(view.getElement())) break;
                return true;
            }
        }
        return false;
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet();
            this.myFeaturesToSynchronize.add(GMFGraphPackage.eINSTANCE.getCanvas_Compartments());
            this.myFeaturesToSynchronize.add(GMFGraphPackage.eINSTANCE.getCanvas_Nodes());
            this.myFeaturesToSynchronize.add(GMFGraphPackage.eINSTANCE.getCanvas_Connections());
            this.myFeaturesToSynchronize.add(GMFGraphPackage.eINSTANCE.getCanvas_Figures());
            this.myFeaturesToSynchronize.add(GMFGraphPackage.eINSTANCE.getCanvas_Labels());
        }
        return this.myFeaturesToSynchronize;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        LinkedList createdConnectionViews = new LinkedList();
        createdConnectionViews.addAll(this.refreshSemanticConnections());
        createdConnectionViews.addAll(this.refreshConnections());
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private Collection refreshConnections() {
        HashMap domain2NotationMap = new HashMap();
        Collection linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = GMFGraphVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator LinkDescriptorsIterator = linkDescriptors.iterator();
            while (LinkDescriptorsIterator.hasNext()) {
                GMFGraphLinkDescriptor nextLinkDescriptor = (GMFGraphLinkDescriptor)LinkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                LinkDescriptorsIterator.remove();
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection collectAllLinks(View view, Map domain2NotationMap) {
        if (!"GMFGraph".equals(GMFGraphVisualIDRegistry.getModelID(view))) {
            return Collections.EMPTY_LIST;
        }
        LinkedList result = new LinkedList();
        switch (GMFGraphVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getCanvas_1000ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getCompartment_2005ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2006: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getNode_2006ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2007: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getConnection_2007ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2008: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getFigureGallery_2008ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getDiagramLabel_2009ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3009: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getFigureDescriptor_3009ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3010: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getRectangle_3010ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3011: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getRectangle_3011ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3012: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getEllipse_3012ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3013: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getRoundedRectangle_3013ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3014: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getPolyline_3014ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3022: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getPoint_3022ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3023: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getPolygon_3023ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3026: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getLabel_3026ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3015: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getEllipse_3015ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3016: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getRoundedRectangle_3016ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3017: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getPolyline_3017ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3024: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getPolygon_3024ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3027: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getLabel_3027ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3018: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getRectangle_3018ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3019: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getEllipse_3019ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3020: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getRoundedRectangle_3020ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3021: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getPolyline_3021ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3025: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getPolygon_3025ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 3028: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getLabel_3028ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(GMFGraphDiagramUpdater.getChildAccess_4002ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection createConnections(Collection linkDescriptors, Map domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (GMFGraphLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPart(nextLinkDescriptor.getSource(), domain2NotationMap);
            EditPart targetEditPart = this.getEditPart(nextLinkDescriptor.getDestination(), domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Map domain2NotationMap) {
        View view = (View)domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }
}

