/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.util.Generator;
import org.eclipse.gmf.internal.bridge.transform.ValidationHelper;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.gmf.internal.codegen.popup.actions.DiagnosticsDialog;
import org.eclipse.gmf.internal.common.migrate.ModelLoadHelper;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExecuteTemplatesOperation
implements IRunnableWithProgress {
    private static final String ASK_OK = "ask_ok";
    private String name;
    private Shell shell;
    private URI genModelURI;
    protected IStatus myRunStatus;
    private GenEditorGenerator myGenModel;

    public String getName() {
        if (this.name == null) {
            return "Execute Templates";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Shell getShell() {
        if (this.shell == null) {
            return Display.getDefault().getActiveShell();
        }
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public URI getGenModelURI() {
        return this.genModelURI;
    }

    public void setGenModelURI(URI uri) {
        this.genModelURI = uri;
    }

    public void run() {
        if (this.getGenModelURI() == null) {
            return;
        }
        try {
            Diagnostic loadStatus = this.loadGenModel();
            if (!this.canProcessGMFGenModel(loadStatus)) {
                return;
            }
            assert (this.getGenModel() != null);
            Diagnostic isGenModelValid = this.validateGenModel();
            if (!ValidationHelper.isOK((Diagnostic)isGenModelValid)) {
                String msg = CodeGenUIPlugin.getBundleString("generatecode.badsrc");
                if (DiagnosticsDialog.openProceedCancel(this.getShell(), this.getName(), msg, isGenModelValid) == 1) {
                    return;
                }
            }
            if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
                return;
            }
            try {
                this.doRunWithStatus();
                if (this.getRunStatus().isOK()) {
                    if (!"always".equals(ExecuteTemplatesOperation.getPreferences().getString(ASK_OK))) {
                        String okMsg = CodeGenUIPlugin.getBundleString("generatecode.ok");
                        String neverMsg = CodeGenUIPlugin.getBundleString("generatecode.neveragain");
                        MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)this.getName(), (String)okMsg, (String)neverMsg, (boolean)false, (IPreferenceStore)ExecuteTemplatesOperation.getPreferences(), (String)ASK_OK);
                    }
                } else if (this.myRunStatus.matches(4)) {
                    CodeGenUIPlugin.getDefault().getLog().log(this.getRunStatus());
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getName(), (String)CodeGenUIPlugin.getBundleString("generatecode.err"), (IStatus)this.getRunStatus());
                } else if (this.myRunStatus.matches(2)) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getName(), (String)CodeGenUIPlugin.getBundleString("generatecode.warn"), (IStatus)this.getRunStatus());
                } else if (this.myRunStatus.matches(1)) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getName(), (String)CodeGenUIPlugin.getBundleString("generatecode.info"), (IStatus)this.getRunStatus());
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        finally {
            this.unloadGenModel();
        }
    }

    private boolean canProcessGMFGenModel(Diagnostic loadStatus) {
        if (!ValidationHelper.isOK((Diagnostic)loadStatus)) {
            boolean disableProceed;
            boolean bl = disableProceed = this.myGenModel == null;
            if (1 == DiagnosticsDialog.openProceedCancel(this.getShell(), this.getName(), null, loadStatus, disableProceed)) {
                return false;
            }
        }
        return true;
    }

    private void doRunWithStatus() throws InterruptedException {
        this.myRunStatus = Status.CANCEL_STATUS;
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)this);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            this.myRunStatus = targetException instanceof CoreException ? ((CoreException)targetException).getStatus() : new Status(4, CodeGenUIPlugin.getPluginID(), 0, "Exception occurred while generating code", targetException);
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Generator g = this.createGenerator();
        g.run(monitor);
        this.myRunStatus = g.getRunStatus();
    }

    private IStatus getRunStatus() {
        return this.myRunStatus;
    }

    protected Generator createGenerator() {
        return new Generator(this.getGenModel(), CodeGenUIPlugin.getDefault().getEmitters(this.getGenModel()));
    }

    protected final GenEditorGenerator getGenModel() {
        return this.myGenModel;
    }

    private Diagnostic loadGenModel() {
        ResourceSetImpl srcResSet = new ResourceSetImpl();
        srcResSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)srcResSet, this.getGenModelURI());
        EObject root = loadHelper.getContentsRoot();
        if (root instanceof GenDiagram) {
            this.myGenModel = ((GenDiagram)root).getEditorGen();
        } else if (root instanceof GenEditorGenerator) {
            this.myGenModel = (GenEditorGenerator)root;
        }
        if (this.myGenModel != null && this.myGenModel.getDomainGenModel() != null) {
            this.myGenModel.getDomainGenModel().reconcile();
        }
        return ValidationHelper.createResourceProblemMarkers((Diagnostic)loadHelper.getDiagnostics());
    }

    private void unloadGenModel() {
        if (this.myGenModel != null && this.myGenModel.eResource() != null) {
            this.myGenModel.eResource().unload();
        }
        this.myGenModel = null;
    }

    private Diagnostic validateGenModel() {
        return ValidationHelper.validate((EObject)this.getGenModel(), (boolean)true);
    }

    private static IPreferenceStore getPreferences() {
        return CodeGenUIPlugin.getDefault().getPreferenceStore();
    }
}

