/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.utils;

import org.eclipse.emf.compare.tests.nodes.NodesPackage;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.junit.Assert;
import org.junit.Test;

public class EqualityHelperTest {
    @Test
    public void matchingValues() {
        EqualityHelper helper = new EqualityHelper(null);
        Object o1 = new Object();
        Object o2 = new Object();
        Assert.assertFalse((boolean)helper.matchingValues(o1, o2));
        Assert.assertTrue((boolean)helper.matchingValues(o1, o1));
        Assert.assertTrue((boolean)helper.matchingValues((Object)"", null));
        Assert.assertTrue((boolean)helper.matchingValues(null, (Object)""));
        Assert.assertTrue((boolean)helper.matchingValues((Object)"a", (Object)"a"));
        Assert.assertTrue((boolean)helper.matchingValues((Object)new Integer(42), (Object)new Integer(42)));
        Assert.assertTrue((boolean)helper.matchingValues((Object)new Boolean(true), (Object)new Boolean(true)));
        String[] array1 = new String[]{"a", "b", "c"};
        String[] array2 = new String[]{"d", "e", "f"};
        String[] array3 = new String[]{"a", "b", "c", "d"};
        String[] array4 = new String[]{"d", "c", "b", "a"};
        Assert.assertTrue((boolean)helper.matchingValues((Object)array1, (Object)array1));
        Assert.assertFalse((boolean)helper.matchingValues((Object)array1, (Object)array2));
        Assert.assertFalse((boolean)helper.matchingValues((Object)array1, (Object)array3));
        Assert.assertFalse((boolean)helper.matchingValues((Object)array3, (Object)array4));
        FeatureMap.Entry entry1 = new FeatureMap.Entry(){

            public Object getValue() {
                return new Integer(42);
            }

            public EStructuralFeature getEStructuralFeature() {
                return NodesPackage.eINSTANCE.getNode_Name();
            }
        };
        FeatureMap.Entry entry2 = new FeatureMap.Entry(){

            public Object getValue() {
                return new Integer(24);
            }

            public EStructuralFeature getEStructuralFeature() {
                return NodesPackage.eINSTANCE.getNode_Name();
            }
        };
        FeatureMap.Entry entry3 = new FeatureMap.Entry(){

            public Object getValue() {
                return new Integer(42);
            }

            public EStructuralFeature getEStructuralFeature() {
                return NodesPackage.eINSTANCE.getNode_ContainmentRef1();
            }
        };
        FeatureMap.Entry entry4 = new FeatureMap.Entry(){

            public Object getValue() {
                return new Integer(24);
            }

            public EStructuralFeature getEStructuralFeature() {
                return NodesPackage.eINSTANCE.getNode_ContainmentRef1();
            }
        };
        Assert.assertTrue((boolean)helper.matchingValues((Object)entry1, (Object)entry1));
        Assert.assertFalse((boolean)helper.matchingValues((Object)entry1, (Object)entry2));
        Assert.assertFalse((boolean)helper.matchingValues((Object)entry1, (Object)entry3));
        Assert.assertFalse((boolean)helper.matchingValues((Object)entry2, (Object)entry4));
    }
}

