/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.List;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Navigatable
implements INavigatable {
    public static final int NEXT_UNRESOLVED_CHANGE = 80;
    private final WrappableTreeViewer viewer;
    private final EMFCompareStructureMergeViewerContentProvider contentProvider;
    protected EMFCompareStructureMergeViewerContentProvider.CallbackType uiSyncCallbackType = EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC;

    public Navigatable(WrappableTreeViewer viewer, EMFCompareStructureMergeViewerContentProvider contentProvider) {
        this.viewer = viewer;
        this.contentProvider = contentProvider;
    }

    public boolean selectChange(final int flag) {
        this.contentProvider.runWhenReady(this.uiSyncCallbackType, new Runnable(){

            @Override
            public void run() {
                TreeItem[] selection = Navigatable.this.viewer.getTree().getSelection();
                TreeItem firstSelectedItem = Navigatable.firstOrNull(selection);
                Object newSelection = Navigatable.this.calculateNextSelection(firstSelectedItem, flag);
                if (newSelection != null) {
                    Navigatable.this.fireOpen(newSelection);
                }
            }
        });
        return false;
    }

    private static TreeItem firstOrNull(TreeItem[] items) {
        if (items.length > 0) {
            return items[0];
        }
        return null;
    }

    private Object calculateNextSelection(TreeItem currentSelection, int flag) {
        switch (flag) {
            case 1: {
                return this.getNextDiff(this.thisOrFirstItem(currentSelection));
            }
            case 2: {
                return this.getPreviousDiff(this.thisOrFirstItem(currentSelection));
            }
            case 3: {
                return this.getNextDiff(this.getFirstItemInTree());
            }
            case 4: {
                return this.getPreviousDiff(this.getFirstItemInTree());
            }
            case 80: {
                return this.getNextUnresolvedDiff(this.thisOrFirstItem(currentSelection));
            }
        }
        throw new IllegalStateException();
    }

    private TreeItem thisOrFirstItem(TreeItem item) {
        if (item != null) {
            return item;
        }
        return this.getFirstItemInTree();
    }

    public void fireOpen(Object element) {
        StructuredSelection newSelection = new StructuredSelection(element);
        this.viewer.setSelection((ISelection)newSelection);
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, (ISelection)newSelection));
    }

    public WrappableTreeViewer getViewer() {
        return this.viewer;
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    public boolean openSelectedChange() {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, selection));
        return true;
    }

    public boolean hasChange(int changeFlag) {
        TreeItem[] selection = this.viewer.getTree().getItems();
        TreeItem firstSelectedItem = selection.length > 0 ? selection[0] : null;
        switch (changeFlag) {
            case 1: {
                return this.getNextDiff(this.thisOrFirstItem(firstSelectedItem)) != null;
            }
            case 2: {
                return this.getPreviousDiff(this.thisOrFirstItem(firstSelectedItem)) != null;
            }
            case 80: {
                return this.getNextUnresolvedDiff(this.thisOrFirstItem(firstSelectedItem)) != null;
            }
            case 3: {
                TreeItem firstItemInTree = this.getFirstItemInTree();
                return firstItemInTree != null && this.getNextDiff(firstItemInTree) != null;
            }
        }
        throw new IllegalStateException();
    }

    private Object getNextDiff(TreeItem start) {
        return this.getNextData(start, (Predicate<? super Diff>)Predicates.alwaysTrue());
    }

    private Object getPreviousDiff(TreeItem item) {
        return this.getPreviousData(item, (Predicate<? super Diff>)Predicates.alwaysTrue());
    }

    private Object getNextUnresolvedDiff(TreeItem start) {
        return this.getNextData(start, (Predicate<? super Diff>)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
    }

    private Object getNextData(TreeItem start, Predicate<? super Diff> predicate) {
        TreeItem current = this.getNextItem(start);
        while (current != null) {
            EObject data = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(current.getData());
            if (data instanceof Diff && predicate.apply((Object)((Diff)data))) {
                return current.getData();
            }
            current = this.getNextItem(current);
        }
        return null;
    }

    private Object getPreviousData(TreeItem start, Predicate<? super Diff> predicate) {
        TreeItem current = this.getPreviousItem(start);
        while (current != null) {
            EObject data = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(current.getData());
            if (data instanceof Diff && predicate.apply((Object)((Diff)data))) {
                return current.getData();
            }
            current = this.getPreviousItem(current);
        }
        return null;
    }

    private TreeItem getFirstItemInTree() {
        TreeItem[] roots = this.viewer.getTree().getItems();
        TreeItem startingItem = roots != null && roots.length > 0 ? roots[0] : null;
        return startingItem;
    }

    protected TreeItem getNextItem(TreeItem start) {
        this.viewer.createChildren((Widget)start);
        if (this.hasChildren(start)) {
            return start.getItem(0);
        }
        if (this.hasNextSibling(start)) {
            return this.getNextSibling(start);
        }
        return this.getNextAncestor(start);
    }

    private boolean hasChildren(TreeItem item) {
        return item.getItems().length != 0;
    }

    private boolean hasNextSibling(TreeItem item) {
        return this.getNextSibling(item) != null;
    }

    private TreeItem getNextAncestor(TreeItem item) {
        TreeItem nextAncestor = null;
        TreeItem ancestor = item.getParentItem();
        while (ancestor != null && nextAncestor == null) {
            nextAncestor = this.getNextSibling(ancestor);
            ancestor = ancestor.getParentItem();
        }
        return nextAncestor;
    }

    protected TreeItem getPreviousItem(TreeItem start) {
        if (this.hasPreviousSibling(start)) {
            return this.getLastDescendant(this.getPreviousSibling(start));
        }
        return start.getParentItem();
    }

    private boolean hasPreviousSibling(TreeItem item) {
        return this.getPreviousSibling(item) != null;
    }

    private TreeItem getLastDescendant(TreeItem input) {
        TreeItem[] children = input.getItems();
        TreeItem deepestChild = input;
        while (children.length > 0) {
            deepestChild = children[children.length - 1];
            children = deepestChild.getItems();
        }
        return deepestChild;
    }

    private TreeItem getPreviousSibling(TreeItem item) {
        List<TreeItem> siblings = Arrays.asList(this.getSiblings(item));
        int indexOfCurrent = siblings.indexOf(item);
        if (indexOfCurrent > 0) {
            return siblings.get(indexOfCurrent - 1);
        }
        return null;
    }

    private TreeItem getNextSibling(TreeItem item) {
        List<TreeItem> siblings = Arrays.asList(this.getSiblings(item));
        int indexOfItem = siblings.indexOf(item);
        if (indexOfItem >= 0 && indexOfItem < siblings.size() - 1) {
            return siblings.get(indexOfItem + 1);
        }
        return null;
    }

    private TreeItem[] getSiblings(TreeItem item) {
        if (item.getParentItem() == null) {
            return this.viewer.getTree().getItems();
        }
        return item.getParentItem().getItems();
    }
}

