/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.provider.FeatureMapChangeItemProvider;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ISemanticObjectLabelProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.spec.ReferenceChangeItemProviderSpec;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;

public class FeatureMapChangeItemProviderSpec
extends FeatureMapChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider,
ISemanticObjectLabelProvider {
    private static final int ELIDE_LENGTH = 50;
    private final OverlayImageProvider overlayProvider;
    private final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public FeatureMapChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.overlayProvider = new OverlayImageProvider(this.getResourceLocator());
    }

    public Object getImage(Object object) {
        FeatureMapChange featureMapChange = (FeatureMapChange)object;
        FeatureMap.Entry value = (FeatureMap.Entry)featureMapChange.getValue();
        Object featureMapChangeValueImage = this.itemDelegator.getImage(value.getValue());
        if (featureMapChangeValueImage == null) {
            featureMapChangeValueImage = super.getImage(object);
        }
        Object diffImage = this.overlayProvider.getComposedImage((Diff)featureMapChange, featureMapChangeValueImage);
        Object ret = this.overlayImage(object, diffImage);
        return ret;
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    protected String getFeatureMapText(FeatureMapChange featureMapChange) {
        return featureMapChange.getAttribute().getName();
    }

    protected String getValueText(FeatureMapChange featureMapChange) {
        FeatureMap.Entry featureMapValue = (FeatureMap.Entry)featureMapChange.getValue();
        EStructuralFeature entryFeature = featureMapValue.getEStructuralFeature();
        Object entryValue = featureMapValue.getValue();
        String value = "<" + entryFeature.getName() + "> ";
        value = com.google.common.base.Strings.isNullOrEmpty((String)(value = String.valueOf(value) + this.itemDelegator.getText(entryValue))) ? "<null>" : Strings.elide(value, 50, "...");
        return value;
    }

    public Object getForeground(Object object) {
        FeatureMapChange featureMapChange = (FeatureMapChange)object;
        switch (featureMapChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        FeatureMapChange featureMapChange = (FeatureMapChange)object;
        String valueText = this.getValueText(featureMapChange);
        String featureMapText = this.getFeatureMapText(featureMapChange);
        ComposedStyledString ret = new ComposedStyledString();
        ret.append(valueText);
        ret.append(" [" + featureMapText, IStyledString.Style.DECORATIONS_STYLER);
        switch (featureMapChange.getKind()) {
            case ADD: {
                ret.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(" entry key change", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(" move", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + featureMapChange.getKind());
            }
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    public String getSemanticObjectLabel(Object object) {
        FeatureMapChange featureMapChange = (FeatureMapChange)object;
        return this.getValueText(featureMapChange);
    }

    public String getDescription(Object object) {
        FeatureMapChange featureMapChange = (FeatureMapChange)object;
        String valueText = this.getValueText(featureMapChange);
        String featureMapText = this.getFeatureMapText(featureMapChange);
        String hasBeenAndSide = EMFCompareEditMessages.getString("change.local");
        if (featureMapChange.getSource() == DifferenceSource.RIGHT) {
            hasBeenAndSide = EMFCompareEditMessages.getString("change.remote");
        }
        String ret = "";
        switch (featureMapChange.getKind()) {
            case ADD: {
                ret = EMFCompareEditMessages.getString("FeatureMapChangeItemProviderSpec.valueAdded", valueText, hasBeenAndSide, featureMapText);
                break;
            }
            case DELETE: {
                ret = EMFCompareEditMessages.getString("FeatureMapChangeItemProviderSpec.valueRemoved", valueText, hasBeenAndSide, featureMapText);
                break;
            }
            case CHANGE: {
                String changeText = ReferenceChangeItemProviderSpec.changeText((Diff)featureMapChange, (EStructuralFeature)featureMapChange.getAttribute());
                ret = EMFCompareEditMessages.getString("FeatureMapChangeItemProviderSpec.valueChanged", featureMapText, valueText, hasBeenAndSide, changeText);
                break;
            }
            case MOVE: {
                ret = EMFCompareEditMessages.getString("FeatureMapChangeItemProviderSpec.valueMoved", valueText, hasBeenAndSide, featureMapText);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + featureMapChange.getKind());
            }
        }
        return ret;
    }
}

