/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceAttachmentChangeConflictSearch {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Add
    extends AbstractConflictSearch<ResourceAttachmentChange> {
        public Add(ResourceAttachmentChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Match match = ((ResourceAttachmentChange)this.diff).getMatch();
            EObject value = this.getValue((ResourceAttachmentChange)this.diff);
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            for (ReferenceChange candidate : Iterables.filter(refChanges, EMFComparePredicates.possiblyConflictingWith(this.diff))) {
                if (candidate.getReference().isContainment()) {
                    this.conflict(candidate, ConflictKind.REAL);
                    continue;
                }
                if (value.eContainer() != null || candidate.getKind() == DifferenceKind.DELETE) continue;
                this.conflict(candidate, ConflictKind.REAL);
            }
            EList<Diff> diffsInSameMatch = ((ResourceAttachmentChange)this.diff).getMatch().getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and(EMFComparePredicates.possiblyConflictingWith(this.diff), (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class)))) {
                ConflictKind kind = ConflictKind.REAL;
                if (candidate.getKind() == DifferenceKind.ADD) {
                    Resource candidateRes;
                    Resource diffRes;
                    if (((ResourceAttachmentChange)this.diff).getSource() == DifferenceSource.LEFT) {
                        diffRes = match.getLeft().eResource();
                        candidateRes = match.getRight().eResource();
                    } else {
                        diffRes = match.getRight().eResource();
                        candidateRes = match.getLeft().eResource();
                    }
                    if (this.getMatchResource(diffRes) == this.getMatchResource(candidateRes)) {
                        kind = ConflictKind.PSEUDO;
                    }
                }
                this.conflict(candidate, kind);
            }
        }

        protected void checkResourceAttachmentConflict(ReferenceChange candidate) {
            EObject o;
            if (candidate.getReference().isContainment()) {
                this.conflict(candidate, ConflictKind.REAL);
            } else if (((ResourceAttachmentChange)this.diff).getKind() == DifferenceKind.DELETE && (o = this.getRelatedModelElement((ResourceAttachmentChange)this.diff)) == null && candidate.getKind() != DifferenceKind.DELETE) {
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Change
    extends AbstractConflictSearch<ResourceAttachmentChange> {
        public Change(ResourceAttachmentChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            throw new IllegalStateException("ResourceAttachmentChanges of type CHANGE should not exist.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Delete
    extends AbstractConflictSearch<ResourceAttachmentChange> {
        public Delete(ResourceAttachmentChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Match match = ((ResourceAttachmentChange)this.diff).getMatch();
            EObject value = this.getRelatedModelElement((ResourceAttachmentChange)this.diff);
            if (value != null) {
                Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
                for (Diff candidate : Iterables.filter(refChanges, EMFComparePredicates.possiblyConflictingWith(this.diff))) {
                    if (candidate.getReference().isContainment()) {
                        this.conflict(candidate, ConflictKind.REAL);
                        continue;
                    }
                    if (value.eContainer() != null || candidate.getKind() == DifferenceKind.DELETE) continue;
                    this.conflict(candidate, ConflictKind.REAL);
                }
            }
            EList<Diff> diffsInSameMatch = ((ResourceAttachmentChange)this.diff).getMatch().getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and(EMFComparePredicates.possiblyConflictingWith(this.diff), (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class)))) {
                ConflictKind kind = ConflictKind.REAL;
                if (candidate.getKind() == DifferenceKind.DELETE) {
                    Resource diffRes = match.getOrigin().eResource();
                    Resource candidateRes = match.getOrigin().eResource();
                    if (this.getMatchResource(diffRes) == this.getMatchResource(candidateRes)) {
                        kind = ConflictKind.PSEUDO;
                    }
                }
                this.conflict(candidate, kind);
            }
            EObject o = this.getRelatedModelElement((ResourceAttachmentChange)this.diff);
            if (o == null || o.eContainer() == null) {
                for (Diff extendedCandidate : Iterables.filter(match.getAllDifferences(), EMFComparePredicates.possiblyConflictingWith(this.diff))) {
                    if (ComparisonUtil.isDeleteOrUnsetDiff(extendedCandidate)) {
                        this.conflict(extendedCandidate, ConflictKind.PSEUDO);
                        continue;
                    }
                    this.conflict(extendedCandidate, ConflictKind.REAL);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Move
    extends AbstractConflictSearch<ResourceAttachmentChange> {
        public Move(ResourceAttachmentChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = this.getRelatedModelElement((ResourceAttachmentChange)this.diff);
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            for (ReferenceChange candidate : Iterables.filter(refChanges, EMFComparePredicates.possiblyConflictingWith(this.diff))) {
                if (!candidate.getReference().isContainment()) continue;
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }
}

