/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.factories.extensions;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.diagram.internal.extensions.ExtensionsFactory;
import org.eclipse.emf.compare.diagram.internal.factories.AbstractDiagramChangeFactory;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramChangeFactory
extends AbstractDiagramChangeFactory {
    public Class<? extends Diff> getExtensionKind() {
        return DiagramChange.class;
    }

    public DiagramDiff createExtension() {
        return ExtensionsFactory.eINSTANCE.createDiagramChange();
    }

    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        if (refiningDiff.getSource() == extension.getSource()) {
            extension.getRefinedBy().add((Object)refiningDiff);
            extension.getRefinedBy().addAll(Collections2.filter((Collection)this.getAllContainedDifferences(refiningDiff), (Predicate)EMFComparePredicates.fromSide((DifferenceSource)extension.getSource())));
        }
    }

    public void fillRequiredDifferences(Comparison comparison, Diff extension) {
    }

    public static Predicate<Diff> isMainDiffForAddOrDeleteDiagram() {
        return new Predicate<Diff>(){

            public boolean apply(Diff difference) {
                return difference instanceof ResourceAttachmentChange && (DiagramChangeFactory.isRelatedToAnAddDiagram((ResourceAttachmentChange)difference) || DiagramChangeFactory.isRelatedToADeleteDiagram((ResourceAttachmentChange)difference));
            }
        };
    }

    protected boolean isRelatedToAnExtensionAdd(ResourceAttachmentChange input) {
        return DiagramChangeFactory.isRelatedToAnAddDiagram(input);
    }

    protected static boolean isRelatedToAnAddDiagram(ResourceAttachmentChange input) {
        return DiagramChangeFactory.isContainmentOnSemanticDiagram(input) && input.getKind() == DifferenceKind.ADD;
    }

    protected boolean isRelatedToAnExtensionDelete(ResourceAttachmentChange input) {
        return DiagramChangeFactory.isRelatedToADeleteDiagram(input);
    }

    protected static boolean isRelatedToADeleteDiagram(ResourceAttachmentChange input) {
        return DiagramChangeFactory.isContainmentOnSemanticDiagram(input) && input.getKind() == DifferenceKind.DELETE;
    }

    private static boolean isContainmentOnSemanticDiagram(ResourceAttachmentChange input) {
        EObject value = MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (Diff)input);
        return value instanceof Diagram && ReferenceUtil.safeEGet((EObject)value, (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT) != null;
    }
}

