/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IViewerCreator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.ForwardingCompareInput;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class TextFallbackCompareViewerCreator
implements IViewerCreator {
    public Viewer createViewer(Composite parent, CompareConfiguration config) {
        return new TextFallbackMergeViewer(parent, new EMFCompareConfiguration(config));
    }

    private static ICompareInput getAdaptedCompareInput(CompareInputAdapter input) {
        ICompareInput adaptedCompareInput;
        Notifier target = input.getTarget();
        if (target instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)target;
            EObject data = treeNode.getData();
            Comparison comparison = ComparisonUtil.getComparison((EObject)data);
            if (comparison != null) {
                ICompareInput compareInput = (ICompareInput)EcoreUtil.getAdapter((List)comparison.eAdapters(), ICompareInput.class);
                adaptedCompareInput = compareInput instanceof ForwardingCompareInput ? ((ForwardingCompareInput)compareInput).delegate() : compareInput;
            } else {
                adaptedCompareInput = null;
                EMFCompareIDEUIPlugin.getDefault().log(4, "Cannot find a comparison from input " + (Object)((Object)input));
            }
        } else {
            adaptedCompareInput = null;
        }
        return adaptedCompareInput;
    }

    private static final class TextFallbackMergeViewer
    extends TextMergeViewer {
        private Object originalInput;

        private TextFallbackMergeViewer(Composite parent, CompareConfiguration configuration) {
            super(parent, configuration);
            this.setContentProvider((IContentProvider)new TextFallbackMergeViewerContentProvider(configuration));
        }

        public void setInput(Object input) {
            this.originalInput = input;
            if (input instanceof CompareInputAdapter) {
                super.setInput((Object)TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)input)));
            } else if (input instanceof ForwardingCompareInput) {
                super.setInput((Object)((ForwardingCompareInput)((Object)input)).delegate());
            } else {
                super.setInput(input);
            }
        }

        public Object getInput() {
            return this.originalInput;
        }

        protected void handleDispose(DisposeEvent event) {
            super.handleDispose(event);
            this.originalInput = null;
        }

        public String getTitle() {
            return EMFCompareIDEUIMessages.getString("TextFallbackCompareViewer.title");
        }
    }

    private static final class TextFallbackMergeViewerContentProvider
    extends MergeViewerContentProvider {
        private TextFallbackMergeViewerContentProvider(CompareConfiguration cc) {
            super(cc);
        }

        public boolean isLeftEditable(Object element) {
            ICompareInput adaptedCompareInput;
            boolean leftEditable = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.isLeftEditable((Object)adaptedCompareInput) : super.isLeftEditable(element)) : super.isLeftEditable(element);
            return leftEditable;
        }

        public boolean isRightEditable(Object element) {
            ICompareInput adaptedCompareInput;
            boolean rightEditable = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.isRightEditable((Object)adaptedCompareInput) : super.isRightEditable(element)) : super.isRightEditable(element);
            return rightEditable;
        }

        public void saveLeftContent(Object element, byte[] bytes) {
            if (element instanceof CompareInputAdapter) {
                ICompareInput adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element));
                if (adaptedCompareInput != null) {
                    super.saveLeftContent((Object)adaptedCompareInput, bytes);
                } else {
                    super.saveLeftContent(element, bytes);
                }
            } else {
                super.saveLeftContent(element, bytes);
            }
        }

        public void saveRightContent(Object element, byte[] bytes) {
            if (element instanceof CompareInputAdapter) {
                ICompareInput adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element));
                if (adaptedCompareInput != null) {
                    super.saveRightContent((Object)adaptedCompareInput, bytes);
                } else {
                    super.saveRightContent(element, bytes);
                }
            } else {
                super.saveRightContent(element, bytes);
            }
        }

        public String getAncestorLabel(Object element) {
            ICompareInput adaptedCompareInput;
            String ancestorLabel = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.getAncestorLabel((Object)adaptedCompareInput) : super.getAncestorLabel(element)) : super.getAncestorLabel(element);
            return ancestorLabel;
        }

        public Image getAncestorImage(Object element) {
            ICompareInput adaptedCompareInput;
            Image ancestorImage = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.getAncestorImage((Object)adaptedCompareInput) : super.getAncestorImage(element)) : super.getAncestorImage(element);
            return ancestorImage;
        }

        public Object getAncestorContent(Object element) {
            ICompareInput adaptedCompareInput;
            Object ancestorContent = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.getAncestorContent((Object)adaptedCompareInput) : super.getAncestorContent(element)) : super.getAncestorContent(element);
            return ancestorContent;
        }

        public String getLeftLabel(Object element) {
            ICompareInput adaptedCompareInput;
            String leftLabel = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.getLeftLabel((Object)adaptedCompareInput) : super.getLeftLabel(element)) : super.getLeftLabel(element);
            return leftLabel;
        }

        public Image getLeftImage(Object element) {
            ICompareInput adaptedCompareInput;
            Image leftImage = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.getLeftImage((Object)adaptedCompareInput) : super.getLeftImage(element)) : super.getLeftImage(element);
            return leftImage;
        }

        public Object getLeftContent(Object element) {
            ICompareInput adaptedCompareInput;
            Object leftContent = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.getLeftContent((Object)adaptedCompareInput) : super.getLeftContent(element)) : super.getLeftContent(element);
            return leftContent;
        }

        public String getRightLabel(Object element) {
            ICompareInput adaptedCompareInput;
            String rightLabel = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.getRightLabel((Object)adaptedCompareInput) : super.getRightLabel(element)) : super.getRightLabel(element);
            return rightLabel;
        }

        public Image getRightImage(Object element) {
            ICompareInput adaptedCompareInput;
            Image rightImage = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.getRightImage((Object)adaptedCompareInput) : super.getRightImage(element)) : super.getRightImage(element);
            return rightImage;
        }

        public Object getRightContent(Object element) {
            ICompareInput adaptedCompareInput;
            Object rightContent = element instanceof CompareInputAdapter ? ((adaptedCompareInput = TextFallbackCompareViewerCreator.getAdaptedCompareInput((CompareInputAdapter)((Object)element))) != null ? super.getRightContent((Object)adaptedCompareInput) : super.getRightContent(element)) : super.getRightContent(element);
            return rightContent;
        }
    }
}

