/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMerger
implements IMerger2 {
    private int ranking;
    private IMerger.Registry registry;

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int r) {
        this.ranking = r;
    }

    @Override
    public IMerger.Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(IMerger.Registry registry) {
        if (this.registry != null && registry != null) {
            throw new IllegalStateException("The registry has to be set only once.");
        }
        this.registry = registry;
    }

    @Override
    public Set<Diff> getResultingMerges(Diff diff, boolean mergeLeftToRight, Set<Diff> knownImplications) {
        LinkedHashSet<Diff> relations = new LinkedHashSet<Diff>();
        relations.add(diff);
        if (mergeLeftToRight) {
            if (DifferenceSource.LEFT == diff.getSource()) {
                relations.addAll(this.getImpliedDiffsOf((Iterable<Diff>)diff.getRequires(), mergeLeftToRight, (Set<Diff>)Sets.union(relations, knownImplications)));
                relations.addAll(this.getRecursiveImplies(diff));
            } else {
                relations.addAll(this.getImpliedDiffsOf((Iterable<Diff>)diff.getRequiredBy(), mergeLeftToRight, (Set<Diff>)Sets.union(relations, knownImplications)));
                relations.addAll(this.getRecursiveImpliedBy(diff));
            }
        } else if (DifferenceSource.LEFT == diff.getSource()) {
            relations.addAll(this.getImpliedDiffsOf((Iterable<Diff>)diff.getRequiredBy(), mergeLeftToRight, (Set<Diff>)Sets.union(relations, knownImplications)));
            relations.addAll(this.getRecursiveImpliedBy(diff));
        } else {
            relations.addAll(this.getImpliedDiffsOf((Iterable<Diff>)diff.getRequires(), mergeLeftToRight, (Set<Diff>)Sets.union(relations, knownImplications)));
            relations.addAll(this.getRecursiveImplies(diff));
        }
        relations.addAll(this.getImpliedDiffsOf((Iterable<Diff>)diff.getRefinedBy(), mergeLeftToRight, (Set<Diff>)Sets.union(relations, knownImplications)));
        if (diff.getEquivalence() != null) {
            relations.addAll((Collection<Diff>)diff.getEquivalence().getDifferences());
        }
        if (diff.getConflict() != null && diff.getConflict().getKind() == ConflictKind.PSEUDO) {
            relations.addAll((Collection<Diff>)diff.getConflict().getDifferences());
        }
        return relations;
    }

    private Set<Diff> getImpliedDiffsOf(Iterable<Diff> subDiffs, boolean mergeLeftToRight, Set<Diff> knownImplications) {
        LinkedHashSet<Diff> relations = new LinkedHashSet<Diff>();
        for (Diff dependency : Iterables.filter(subDiffs, (Predicate)Predicates.not((Predicate)Predicates.in(knownImplications)))) {
            IMerger dependencyMerger = this.getRegistry().getHighestRankingMerger(dependency);
            if (dependencyMerger instanceof IMerger2) {
                relations.addAll(((IMerger2)dependencyMerger).getResultingMerges(dependency, mergeLeftToRight, (Set<Diff>)Sets.union(relations, knownImplications)));
                continue;
            }
            relations.add(dependency);
        }
        return relations;
    }

    @Override
    public Set<Diff> getResultingRejections(Diff diff, boolean mergeLeftToRight, Set<Diff> knownRejections) {
        LinkedHashSet<Diff> impliedRejections = new LinkedHashSet<Diff>();
        Set<Diff> impliedDiffs = this.getResultingMerges(diff, mergeLeftToRight, Collections.<Diff>emptySet());
        for (Diff implied : impliedDiffs) {
            Conflict conflict = implied.getConflict();
            if (conflict == null || conflict.getKind() != ConflictKind.REAL) continue;
            Iterable<Object> directlyImpliedRejections = mergeLeftToRight && implied.getSource() == DifferenceSource.LEFT ? Iterables.filter(conflict.getDifferences(), EMFComparePredicates.fromSide(DifferenceSource.RIGHT)) : (!mergeLeftToRight && implied.getSource() == DifferenceSource.RIGHT ? Iterables.filter(conflict.getDifferences(), EMFComparePredicates.fromSide(DifferenceSource.LEFT)) : new HashSet<Diff>());
            Iterables.addAll(impliedRejections, this.getImpliedDiffsOf(directlyImpliedRejections, mergeLeftToRight, knownRejections));
        }
        return impliedRejections;
    }

    private Set<Diff> getRecursiveImplies(Diff diff) {
        LinkedHashSet<Diff> implies = new LinkedHashSet<Diff>();
        implies.addAll((Collection<Diff>)diff.getImplies());
        for (Diff implied : diff.getImplies()) {
            implies.addAll(this.getRecursiveImplies(implied));
        }
        return implies;
    }

    private Set<Diff> getRecursiveImpliedBy(Diff diff) {
        LinkedHashSet<Diff> implying = new LinkedHashSet<Diff>();
        implying.addAll((Collection<Diff>)diff.getImpliedBy());
        for (Diff impliedBy : diff.getImpliedBy()) {
            implying.addAll(this.getRecursiveImpliedBy(impliedBy));
        }
        return implying;
    }

    @Override
    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        target.setState(DifferenceState.MERGED);
        if (target.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(target, false, monitor);
            this.handleImplies(target, false, monitor);
        } else {
            this.mergeRequiredBy(target, false, monitor);
            this.handleImpliedBy(target, false, monitor);
        }
        for (Diff refining : target.getRefinedBy()) {
            this.mergeDiff(refining, false, monitor);
        }
        boolean hasToBeMerged = true;
        if (target.getEquivalence() != null) {
            hasToBeMerged = this.handleEquivalences(target, false, monitor);
        }
        if (hasToBeMerged) {
            if (target.getSource() == DifferenceSource.LEFT) {
                this.accept(target, false);
            } else {
                this.reject(target, false);
            }
        }
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        target.setState(DifferenceState.MERGED);
        if (target.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(target, true, monitor);
            this.handleImpliedBy(target, true, monitor);
        } else {
            this.mergeRequires(target, true, monitor);
            this.handleImplies(target, true, monitor);
        }
        for (Diff refining : target.getRefinedBy()) {
            this.mergeDiff(refining, true, monitor);
        }
        boolean hasToBeMerged = true;
        if (target.getEquivalence() != null) {
            hasToBeMerged = this.handleEquivalences(target, true, monitor);
        }
        if (hasToBeMerged) {
            if (target.getSource() == DifferenceSource.LEFT) {
                this.reject(target, true);
            } else {
                this.accept(target, true);
            }
        }
    }

    protected void accept(Diff diff, boolean rightToLeft) {
    }

    protected void reject(Diff diff, boolean rightToLeft) {
    }

    protected void mergeRequiredBy(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff dependency : diff.getRequiredBy()) {
            this.mergeDiff(dependency, rightToLeft, monitor);
        }
    }

    protected void handleImplies(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff implied : this.getRecursiveImplies(diff)) {
            implied.setState(DifferenceState.MERGED);
        }
    }

    protected void handleImpliedBy(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff impliedBy : this.getRecursiveImpliedBy(diff)) {
            impliedBy.setState(DifferenceState.MERGED);
        }
    }

    protected void mergeRequires(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff dependency : diff.getRequires()) {
            this.mergeDiff(dependency, rightToLeft, monitor);
        }
    }

    protected void mergeDiff(Diff diff, boolean rightToLeft, Monitor monitor) {
        if (rightToLeft) {
            IMerger delegate = this.getRegistry().getHighestRankingMerger(diff);
            delegate.copyRightToLeft(diff, monitor);
        } else {
            IMerger delegate = this.getRegistry().getHighestRankingMerger(diff);
            delegate.copyLeftToRight(diff, monitor);
        }
    }

    protected boolean handleEquivalences(Diff diff, boolean rightToLeft, Monitor monitor) {
        boolean continueMerge = true;
        for (Diff equivalent : diff.getEquivalence().getDifferences()) {
            if (diff instanceof ReferenceChange && equivalent instanceof ReferenceChange) {
                EReference reference = ((ReferenceChange)diff).getReference();
                EReference equivalentReference = ((ReferenceChange)equivalent).getReference();
                if (reference.getEOpposite() == equivalentReference && equivalent.getState() == DifferenceState.UNRESOLVED) {
                    boolean mergeEquivalence;
                    boolean bl = mergeEquivalence = !reference.isMany() && ((ReferenceChange)equivalent).getReference().isMany() && this.isAdd((ReferenceChange)equivalent, rightToLeft);
                    if (mergeEquivalence) {
                        this.mergeDiff(equivalent, rightToLeft, monitor);
                        continueMerge = false;
                    }
                }
            }
            continueMerge = rightToLeft ? (diff.getSource() == DifferenceSource.LEFT ? continueMerge && !Iterables.any(equivalent.getImplies(), (Predicate)Predicates.in(diff.getRequiredBy())) : continueMerge && !Iterables.any(equivalent.getImpliedBy(), (Predicate)Predicates.in(diff.getRequires()))) : (diff.getSource() == DifferenceSource.LEFT ? continueMerge && !Iterables.any(equivalent.getImpliedBy(), (Predicate)Predicates.in(diff.getRequires())) : continueMerge && !Iterables.any(equivalent.getImplies(), (Predicate)Predicates.in(diff.getRequiredBy())));
            equivalent.setState(DifferenceState.MERGED);
        }
        return continueMerge;
    }

    protected boolean isAdd(ReferenceChange diff, boolean rightToLeft) {
        if (rightToLeft) {
            return this.isLeftDeleteOrRightAdd(diff);
        }
        return this.isLeftAddOrRightDelete(diff);
    }

    private boolean isLeftAddOrRightDelete(ReferenceChange diff) {
        if (diff.getSource() == DifferenceSource.LEFT) {
            return diff.getKind() == DifferenceKind.ADD;
        }
        return diff.getKind() == DifferenceKind.DELETE;
    }

    private boolean isLeftDeleteOrRightAdd(ReferenceChange diff) {
        if (diff.getSource() == DifferenceSource.LEFT) {
            return diff.getKind() == DifferenceKind.DELETE;
        }
        return diff.getKind() == DifferenceKind.ADD;
    }

    protected EObject createCopy(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected <E> void addAt(List<E> list, E value, int insertionIndex) {
        if (list instanceof InternalEList) {
            if (insertionIndex < 0 || insertionIndex > list.size()) {
                ((InternalEList)list).addUnique(value);
            } else {
                ((InternalEList)list).addUnique(insertionIndex, value);
            }
        } else if (insertionIndex < 0 || insertionIndex > list.size()) {
            list.add(value);
        } else {
            list.add(insertionIndex, value);
        }
    }
}

