/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.diff;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.extension.IPostProcessor;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.diff.internal.extension.DiffExtensionFactoryRegistry;
import org.eclipse.emf.compare.uml2.diff.internal.extension.IDiffExtensionFactory;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.SubsetSupersetEObjectEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLDiffExtensionPostProcessor
implements IPostProcessor {
    private Set<IDiffExtensionFactory> uml2ExtensionFactories;
    private static final Field SUBSET_FEATURES_FIELD = UMLDiffExtensionPostProcessor.getSubsetField();

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    private void removeDuplicateDiffs(Comparison comparison) {
        LinkedHashSet removeMe = Sets.newLinkedHashSet();
        for (Diff input : comparison.getDifferences()) {
            EObject matchSide;
            Object value;
            if (!(input instanceof ReferenceChange) || !((ReferenceChange)input).getReference().isMany() || !((value = ReferenceUtil.safeEGet((EObject)(matchSide = UMLDiffExtensionPostProcessor.getSourceSide(input)), (EStructuralFeature)((ReferenceChange)input).getReference())) instanceof SubsetSupersetEObjectEList)) continue;
            int[] subsetsFeatures = UMLDiffExtensionPostProcessor.getSubsetFeatures((SubsetSupersetEObjectEList)value);
            if (subsetsFeatures.length > 0 && input.getKind() == DifferenceKind.MOVE) {
                removeMe.add(input);
                continue;
            }
            Diff duplicate = this.findDuplicatedDiffOnLowestSubset(input, matchSide, subsetsFeatures);
            if (duplicate == null) continue;
            removeMe.add(input);
            this.copyRequirements(input, duplicate);
        }
        for (Diff sentenced : removeMe) {
            EcoreUtil.delete((EObject)sentenced);
        }
    }

    private void copyRequirements(Diff source, Diff target) {
        for (Diff requiredBy : source.getRequiredBy()) {
            if (requiredBy == target) continue;
            target.getRequiredBy().add((Object)requiredBy);
        }
        for (Diff requires : source.getRequires()) {
            if (requires == target) continue;
            target.getRequires().add((Object)requires);
        }
        if (source.getEquivalence() != null) {
            source.getEquivalence().getDifferences().add((Object)target);
        }
    }

    private Diff findDuplicatedDiffOnLowestSubset(Diff input, EObject matchSide, int[] subsetsFeatures) {
        EClass clazz = matchSide.eClass();
        EObject diffValue = ((ReferenceChange)input).getValue();
        int[] actualIDs = this.convertFeatureIDs(clazz, subsetsFeatures);
        ReferenceChange lowestDuplicate = null;
        Iterator siblings = Iterables.filter((Iterable)input.getMatch().getDifferences(), ReferenceChange.class).iterator();
        while (siblings.hasNext() && lowestDuplicate == null) {
            ReferenceChange sibling = (ReferenceChange)siblings.next();
            int refID = sibling.getReference().getFeatureID();
            EObject siblingValue = sibling.getValue();
            if (sibling.getKind() != input.getKind() || !Ints.contains((int[])actualIDs, (int)refID) || siblingValue != diffValue) continue;
            Object subset = matchSide.eGet(clazz.getEStructuralFeature(refID), false);
            if (subset instanceof SubsetSupersetEObjectEList) {
                int[] lowerSubsets = UMLDiffExtensionPostProcessor.getSubsetFeatures((SubsetSupersetEObjectEList)subset);
                Diff lowerDuplicate = this.findDuplicatedDiffOnLowestSubset((Diff)sibling, matchSide, lowerSubsets);
                if (lowerDuplicate != null) {
                    lowestDuplicate = lowerDuplicate;
                    continue;
                }
                lowestDuplicate = sibling;
                continue;
            }
            lowestDuplicate = sibling;
        }
        return lowestDuplicate;
    }

    private int[] convertFeatureIDs(EClass clazz, int[] ids) {
        int[] result = new int[ids.length];
        int i = 0;
        while (i < ids.length) {
            result[i] = clazz.getEStructuralFeature(ids[i]).getFeatureID();
            ++i;
        }
        return result;
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
        this.removeDuplicateDiffs(comparison);
        Map<Class<? extends Diff>, IDiffExtensionFactory> mapUml2ExtensionFactories = DiffExtensionFactoryRegistry.createExtensionFactories();
        this.uml2ExtensionFactories = new HashSet<IDiffExtensionFactory>(mapUml2ExtensionFactories.values());
        for (Diff diff : comparison.getDifferences()) {
            this.applyManagedTypes(diff);
        }
        for (Diff umlDiff : comparison.getDifferences()) {
            Class classDiffElement;
            IDiffExtensionFactory diffFactory;
            if (!(umlDiff instanceof UMLDiff) || (diffFactory = mapUml2ExtensionFactories.get(classDiffElement = umlDiff.eClass().getInstanceClass())) == null) continue;
            diffFactory.fillRequiredDifferences(comparison, (UMLDiff)umlDiff);
        }
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    private void applyManagedTypes(Diff element) {
        for (IDiffExtensionFactory factory : this.uml2ExtensionFactories) {
            if (!factory.handles(element)) continue;
            Diff extension = factory.create(element);
            Match match = factory.getParentMatch(element);
            match.getDifferences().add((Object)extension);
        }
    }

    private static int[] getSubsetFeatures(SubsetSupersetEObjectEList<?> list) {
        Object value = null;
        try {
            value = SUBSET_FEATURES_FIELD.get(list);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        if (value instanceof int[]) {
            return (int[])value;
        }
        return new int[0];
    }

    private static Field getSubsetField() {
        try {
            final Field subsetIDs = SubsetSupersetEObjectEList.class.getDeclaredField("subsetFeatureIDs");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    subsetIDs.setAccessible(true);
                    return null;
                }
            });
            return subsetIDs;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return null;
    }

    private static EObject getSourceSide(Diff input) {
        Match match = input.getMatch();
        EObject matchSide = input.getKind() == DifferenceKind.DELETE ? (match.getOrigin() != null ? match.getOrigin() : (input.getSource() == DifferenceSource.LEFT ? match.getRight() : match.getLeft())) : (input.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight());
        return matchSide;
    }
}

