/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.domain.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.impl.CompareCommandStack;
import org.eclipse.emf.compare.command.impl.CopyAllNonConflictingCommand;
import org.eclipse.emf.compare.command.impl.CopyCommand;
import org.eclipse.emf.compare.command.impl.DualCompareCommandStack;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareEditingDomain
implements ICompareEditingDomain {
    private final ChangeRecorder fChangeRecorder;
    private final ImmutableCollection<Notifier> fNotifiers;
    private final ICompareCommandStack fCommandStack;

    public EMFCompareEditingDomain(Notifier left, Notifier right, Notifier ancestor, ICompareCommandStack commandStack) {
        this.fNotifiers = ancestor == null ? ImmutableList.of((Object)left, (Object)right) : ImmutableList.of((Object)left, (Object)right, (Object)ancestor);
        ResourceSet leftRS = this.getResourceSet(left);
        ResourceSet rightRS = this.getResourceSet(right);
        if (leftRS != null && rightRS != null) {
            TransactionalEditingDomain leftTED = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(leftRS);
            TransactionalEditingDomain rightTED = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(rightRS);
            if (leftTED == null) {
                leftTED = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(leftRS);
            }
            if (rightTED == null) {
                rightTED = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(rightRS);
            }
            this.fCommandStack = new DualCompareCommandStack((BasicCommandStack)leftTED.getCommandStack(), (BasicCommandStack)rightTED.getCommandStack());
        } else {
            this.fCommandStack = commandStack;
        }
        this.fChangeRecorder = new ChangeRecorder();
        this.fChangeRecorder.setResolveProxies(false);
    }

    public ResourceSet getResourceSet(Notifier notifier) {
        ResourceSet resourceSet = null;
        if (notifier instanceof ResourceSet) {
            resourceSet = (ResourceSet)notifier;
        } else if (notifier instanceof Resource) {
            resourceSet = ((Resource)notifier).getResourceSet();
        } else if (notifier instanceof EObject) {
            resourceSet = ((EObject)notifier).eResource().getResourceSet();
        }
        return resourceSet;
    }

    public static ICompareEditingDomain create(Notifier left, Notifier right, Notifier ancestor) {
        return EMFCompareEditingDomain.create(left, right, ancestor, (CommandStack)new BasicCommandStack());
    }

    public static ICompareEditingDomain create(Notifier left, Notifier right, Notifier ancestor, CommandStack commandStack) {
        return EMFCompareEditingDomain.create(left, right, ancestor, commandStack, null);
    }

    public static ICompareEditingDomain create(Notifier left, Notifier right, Notifier ancestor, CommandStack leftCommandStack, CommandStack rightCommandStack) {
        ICompareCommandStack commandStack = leftCommandStack == null && rightCommandStack != null ? new CompareCommandStack(rightCommandStack) : (leftCommandStack != null && rightCommandStack == null ? new CompareCommandStack(leftCommandStack) : (leftCommandStack instanceof BasicCommandStack && rightCommandStack instanceof BasicCommandStack ? new DualCompareCommandStack((BasicCommandStack)leftCommandStack, (BasicCommandStack)rightCommandStack) : new CompareCommandStack((CommandStack)new BasicCommandStack())));
        return new EMFCompareEditingDomain(left, right, ancestor, commandStack);
    }

    @Override
    public void dispose() {
        this.fChangeRecorder.dispose();
    }

    @Override
    public ICompareCommandStack getCommandStack() {
        return this.fCommandStack;
    }

    @Override
    public Command createCopyCommand(Diff diff, boolean leftToRight) {
        ImmutableSet notifiers = ImmutableSet.builder().add((Object)diff.getMatch().getComparison()).addAll(this.fNotifiers).build();
        return new CopyCommand(this.fChangeRecorder, (Collection<Notifier>)notifiers, Collections.singletonList(diff), leftToRight);
    }

    @Override
    public Command createCopyAllNonConflictingCommand(List<? extends Diff> differences, boolean leftToRight) {
        ImmutableSet.Builder notifiersBuilder = ImmutableSet.builder();
        for (Diff diff : differences) {
            notifiersBuilder.add((Object)diff.getMatch().getComparison());
        }
        ImmutableSet immutableSet = notifiersBuilder.addAll(this.fNotifiers).build();
        return new CopyAllNonConflictingCommand(this.fChangeRecorder, (Collection<Notifier>)immutableSet, differences, leftToRight);
    }
}

