/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.provider.spec;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.uml2.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.UMLDiff;
import org.eclipse.emf.compare.uml2.provider.StereotypeApplicationChangeItemProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeApplicationChangeItemProviderSpec
extends StereotypeApplicationChangeItemProvider {
    public StereotypeApplicationChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Collection<?> getChildren(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Object ret = umlDiff.getKind() == DifferenceKind.CHANGE ? umlDiff.getRefinedBy() : super.getChildren(object);
        return ret;
    }

    public boolean hasChildren(Object object) {
        return !this.getChildren(object).isEmpty();
    }

    @Override
    public String getText(Object object) {
        String action;
        Stereotype stereotype;
        UMLDiff umlDiff = (UMLDiff)object;
        String remotely = "";
        if (umlDiff.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        if ((stereotype = ((StereotypeApplicationChange)umlDiff).getStereotype()) == null) {
            stereotype = UMLUtil.getStereotype((EObject)umlDiff.getDiscriminant());
        }
        String stereotypeText = stereotype != null ? String.valueOf(AdapterFactoryUtil.getText((AdapterFactory)this.getRootAdapterFactory(), (Object)stereotype)) + ' ' : (umlDiff.getDiscriminant() instanceof NamedElement ? "Stereotype " + ((NamedElement)umlDiff.getDiscriminant()).getName() + ' ' : "Stereotype ");
        Match targetMatch = umlDiff.getMatch();
        EObject target = this.findNonNullSide(targetMatch);
        String targetLabel = null;
        switch (umlDiff.getKind()) {
            case ADD: {
                action = "applied";
                targetLabel = " to ";
                break;
            }
            case DELETE: {
                action = "unapplied";
                targetLabel = " from ";
                break;
            }
            case CHANGE: {
                action = "changed";
                targetLabel = " on ";
                break;
            }
            case MOVE: {
                action = "moved";
                targetLabel = " to ";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + umlDiff.getKind());
            }
        }
        if (target != null) {
            targetLabel = String.valueOf(targetLabel) + AdapterFactoryUtil.getText((AdapterFactory)this.getRootAdapterFactory(), (Object)target);
        }
        return String.valueOf(stereotypeText) + "has been " + remotely + action + targetLabel;
    }

    private EObject findNonNullSide(Match match) {
        EObject side = match.getLeft() != null ? match.getLeft() : (match.getRight() != null ? match.getRight() : match.getOrigin());
        return side;
    }

    @Override
    public Object getImage(Object object) {
        UMLDiff umlDiff = (UMLDiff)object;
        Stereotype stereotype = ((StereotypeApplicationChange)umlDiff).getStereotype();
        if (stereotype == null) {
            stereotype = UMLUtil.getStereotype((EObject)umlDiff.getDiscriminant());
        }
        Object image = AdapterFactoryUtil.getImage((AdapterFactory)this.getRootAdapterFactory(), (Object)stereotype);
        return image;
    }

    public Object getForeground(Object object) {
        StereotypeApplicationChange referenceChange = (StereotypeApplicationChange)object;
        switch (referenceChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }
}

