/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.EMFCompareColor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.util.EMFCompareEditingDomain;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColorProvider;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.MergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.IStructuralFeatureAccessor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;

public abstract class EMFCompareContentMergeViewer
extends ContentMergeViewer
implements ISelectionChangedListener,
ICompareColorProvider {
    private static final String HANDLER_SERVICE = "fHandlerService";
    protected static final int HORIZONTAL = 1;
    protected static final int VERTICAL = 2;
    protected static final double HSPLIT = 0.5;
    protected static final double VSPLIT = 0.3;
    protected static final int CENTER_WIDTH = 34;
    private MergeViewer fAncestor;
    private MergeViewer fLeft;
    private MergeViewer fRight;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private final Comparison fComparison;
    private final AtomicBoolean fSyncingSelections = new AtomicBoolean(false);
    private EMFCompareColor fColors;
    private final EMFCompareEditingDomain fEditingDomain;
    private final DynamicObject fDynamicObject = new DynamicObject((Object)this);

    protected EMFCompareContentMergeViewer(int style, ResourceBundle bundle, CompareConfiguration cc) {
        super(style, bundle, cc);
        this.fComparison = (Comparison)cc.getProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT");
        this.fEditingDomain = (EMFCompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
    }

    public ICompareColor getCompareColor() {
        return this.fColors;
    }

    protected final EMFCompareEditingDomain getEditingDomain() {
        return this.fEditingDomain;
    }

    protected final Comparison getComparison() {
        return this.fComparison;
    }

    public boolean isThreeWay() {
        return super.isThreeWay();
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.fAncestor.setInput(ancestor);
        this.fLeft.setInput(left);
        this.fRight.setInput(right);
        IMergeViewerItem leftInitialItem = null;
        if (left instanceof IStructuralFeatureAccessor) {
            leftInitialItem = ((IStructuralFeatureAccessor)left).getInitialItem();
        }
        ISelection leftSelection = this.createSelectionOrEmpty(leftInitialItem);
        this.fLeft.setSelection(leftSelection);
        this.getCenterControl().redraw();
    }

    private ISelection createSelectionOrEmpty(Object o) {
        StructuredSelection selection = o != null ? new StructuredSelection(o) : StructuredSelection.EMPTY;
        return selection;
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected void createControls(Composite composite) {
        this.fAncestor = this.createMergeViewer(composite, MergeViewer.MergeViewerSide.ANCESTOR);
        this.fAncestor.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fLeft = this.createMergeViewer(composite, MergeViewer.MergeViewerSide.LEFT);
        this.fLeft.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fRight = this.createMergeViewer(composite, MergeViewer.MergeViewerSide.RIGHT);
        this.fRight.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fColors = new EMFCompareColor(this, null, this.getCompareConfiguration());
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc.isRightEditable()) {
            Action copyLeftToRight = new Action(){

                public void run() {
                    EMFCompareContentMergeViewer.this.copyDiff(true);
                    EMFCompareContentMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyLeftToRight, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffLeftToRight.");
            copyLeftToRight.setEnabled(false);
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)copyLeftToRight);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            this.getHandlerService().registerAction((IAction)copyLeftToRight, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            Action copyRightToLeft = new Action(){

                public void run() {
                    EMFCompareContentMergeViewer.this.copyDiff(false);
                    EMFCompareContentMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyRightToLeft, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffRightToLeft.");
            copyRightToLeft.setEnabled(false);
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)copyRightToLeft);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            this.getHandlerService().registerAction((IAction)copyRightToLeft, "org.eclipse.compare.copyRightToLeft");
        }
        Action nextDiff = new Action(){

            public void run() {
                EMFCompareContentMergeViewer.this.navigate(true);
            }
        };
        Utilities.initAction((IAction)nextDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.NextDiff.");
        ActionContributionItem contributionNextDiff = new ActionContributionItem((IAction)nextDiff);
        contributionNextDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionNextDiff);
        Action previousDiff = new Action(){

            public void run() {
                EMFCompareContentMergeViewer.this.navigate(false);
            }
        };
        Utilities.initAction((IAction)previousDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.PrevDiff.");
        ActionContributionItem contributionPreviousDiff = new ActionContributionItem((IAction)previousDiff);
        contributionPreviousDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionPreviousDiff);
        final UndoAction undoAction = new UndoAction(this.fEditingDomain);
        final RedoAction redoAction = new RedoAction(this.fEditingDomain);
        this.fEditingDomain.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                undoAction.update();
                redoAction.update();
                EMFCompareContentMergeViewer.this.refresh();
            }
        });
        this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)undoAction);
        this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)redoAction);
    }

    protected void copy(boolean leftToRight) {
        EList differences = this.getComparison().getDifferences();
        Command copyCommand = this.getEditingDomain().createCopyAllNonConflictingCommand((List<? extends Diff>)differences, leftToRight);
        this.getEditingDomain().getCommandStack().execute(copyCommand);
        if (leftToRight) {
            this.setRightDirty(true);
        } else {
            this.setLeftDirty(true);
        }
        this.refresh();
    }

    protected void navigate(boolean next) {
        ICompareNavigator navigator;
        Composite control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected abstract void copyDiff(boolean var1);

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            this.getAncestorMergeViewer().getControl().setVisible(true);
            this.getAncestorMergeViewer().getControl().setBounds(x, y, width, height);
        } else {
            this.getAncestorMergeViewer().getControl().setVisible(false);
        }
    }

    protected void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        this.fLeft.getControl().setBounds(x, y, width1, height);
        this.fRight.getControl().setBounds(x + width1 + centerWidth, y, width2, height);
    }

    protected abstract MergeViewer createMergeViewer(Composite var1, MergeViewer.MergeViewerSide var2);

    protected final int getCenterWidth() {
        return 34;
    }

    protected final CompareHandlerService getHandlerService() {
        return (CompareHandlerService)this.fDynamicObject.get(HANDLER_SERVICE);
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    protected Control createCenterControl(Composite parent) {
        final Control ret = super.createCenterControl(parent);
        final PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                EMFCompareContentMergeViewer.this.paintCenter(e.gc);
            }
        };
        ret.addPaintListener(paintListener);
        ret.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ret.removePaintListener(paintListener);
            }
        });
        return ret;
    }

    protected abstract void paintCenter(GC var1);

    protected MergeViewer getAncestorMergeViewer() {
        return this.fAncestor;
    }

    protected MergeViewer getLeftMergeViewer() {
        return this.fLeft;
    }

    protected MergeViewer getRightMergeViewer() {
        return this.fRight;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.fSyncingSelections.compareAndSet(false, true)) {
            try {
                ISelectionProvider selectionProvider = event.getSelectionProvider();
                ISelection selection = event.getSelection();
                this.synchronizeSelection(selectionProvider, selection);
                this.updateToolItems();
            }
            finally {
                this.fSyncingSelections.set(false);
            }
        }
    }

    protected void updateToolItems() {
        super.updateToolItems();
        Diff diff = this.getDiffFrom(this.getRightMergeViewer());
        if (diff == null) {
            diff = this.getDiffFrom(this.getLeftMergeViewer());
        }
        boolean enableCopy = false;
        if (diff != null) {
            enableCopy = true;
        }
        if (this.fCopyDiffLeftToRightItem != null) {
            this.fCopyDiffLeftToRightItem.getAction().setEnabled(enableCopy);
        }
        if (this.fCopyDiffRightToLeftItem != null) {
            this.fCopyDiffRightToLeftItem.getAction().setEnabled(enableCopy);
        }
    }

    protected Diff getDiffFrom(MergeViewer viewer) {
        Diff diff = null;
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator selectedElements = ((IStructuredSelection)selection).iterator();
            while (diff == null && selectedElements.hasNext()) {
                Object element = selectedElements.next();
                if (!(element instanceof IMergeViewerItem)) continue;
                diff = ((IMergeViewerItem)element).getDiff();
            }
        }
        return diff;
    }

    private void synchronizeSelection(ISelectionProvider selectionProvider, ISelection selection) {
        if (selectionProvider == this.fLeft) {
            this.fRight.setSelection(selection);
            this.fAncestor.setSelection(selection);
        } else if (selectionProvider == this.fRight) {
            this.fLeft.setSelection(selection);
            this.fAncestor.setSelection(selection);
        } else {
            this.fLeft.setSelection(selection);
            this.fRight.setSelection(selection);
        }
    }
}

