/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.operations.gmodel;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.BasicOperationHandler;
import org.eclipse.glsp.server.operations.DeleteOperation;

public class DeleteOperationHandler
extends BasicOperationHandler<DeleteOperation> {
    private static Logger log = Logger.getLogger(DeleteOperationHandler.class);
    private Set<String> allDependantsIds;

    @Override
    public void executeOperation(DeleteOperation operation, GModelState modelState) {
        List<String> elementIds = operation.getElementIds();
        if (elementIds == null || elementIds.size() == 0) {
            log.warn((Object)"Elements to delete are not specified");
            return;
        }
        GModelIndex index = modelState.getIndex();
        this.allDependantsIds = new HashSet<String>();
        boolean success = elementIds.stream().allMatch(eId -> this.delete((String)eId, index, modelState));
        if (!success) {
            log.warn((Object)"Could not delete all elements as requested (see messages above to find out why)");
        }
    }

    protected boolean delete(String elementId, GModelIndex index, GModelState modelState) {
        if (this.allDependantsIds.contains(elementId)) {
            return true;
        }
        Optional element = index.get(elementId);
        if (!element.isPresent()) {
            log.warn((Object)("Element not found: " + elementId));
            return false;
        }
        GModelElement nodeToDelete = this.findTopLevelElement((GModelElement)element.get());
        if (nodeToDelete.getParent() == null) {
            log.warn((Object)"The requested node doesn't have a parent; it can't be deleted");
            return false;
        }
        LinkedHashSet<GModelElement> dependents = new LinkedHashSet<GModelElement>();
        this.collectDependents(dependents, nodeToDelete, modelState);
        dependents.forEach(EcoreUtil::delete);
        this.allDependantsIds.addAll(dependents.stream().map(GModelElement::getId).collect(Collectors.toSet()));
        return true;
    }

    protected void collectDependents(Set<GModelElement> dependents, GModelElement nodeToDelete, GModelState modelState) {
        if (dependents.contains(nodeToDelete)) {
            return;
        }
        if (nodeToDelete.getChildren() != null) {
            for (GModelElement child : nodeToDelete.getChildren()) {
                this.collectDependents(dependents, child, modelState);
            }
        }
        if (nodeToDelete instanceof GNode) {
            GModelIndex index = modelState.getIndex();
            for (GModelElement incoming : index.getIncomingEdges(nodeToDelete)) {
                this.collectDependents(dependents, incoming, modelState);
            }
            for (GModelElement outgoing : index.getOutgoingEdges(nodeToDelete)) {
                this.collectDependents(dependents, outgoing, modelState);
            }
        }
        dependents.add(nodeToDelete);
    }

    protected GModelElement findTopLevelElement(GModelElement element) {
        if (element instanceof GNode || element instanceof GEdge) {
            return element;
        }
        GModelElement parent = element.getParent();
        if (parent == null) {
            return element;
        }
        return this.findTopLevelElement(parent);
    }
}

