/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.jsonrpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.glsp.server.protocol.ClientSessionListener;
import org.eclipse.glsp.server.protocol.ClientSessionManager;
import org.eclipse.glsp.server.protocol.GLSPClient;

public final class DefaultClientSessionManager
implements ClientSessionManager {
    private final Set<ClientSessionListener> listeners = new LinkedHashSet<ClientSessionListener>();
    private final Map<GLSPClient, Set<String>> clientSessions = new HashMap<GLSPClient, Set<String>>();
    public static final DefaultClientSessionManager INSTANCE = new DefaultClientSessionManager();

    private DefaultClientSessionManager() {
    }

    @Override
    public synchronized boolean connectClient(GLSPClient client) {
        boolean success;
        boolean bl = success = this.clientSessions.putIfAbsent(client, new HashSet()) == null;
        if (success) {
            new ArrayList<ClientSessionListener>(this.listeners).forEach(listener -> listener.clientConnected(client));
        }
        return success;
    }

    @Override
    public synchronized boolean createClientSession(GLSPClient client, String clientId) {
        this.connectClient(client);
        boolean success = this.clientSessions.get(client).add(clientId);
        if (success) {
            new ArrayList<ClientSessionListener>(this.listeners).forEach(listener -> listener.sessionCreated(clientId, client));
        }
        return success;
    }

    @Override
    public synchronized boolean disposeClientSession(GLSPClient client, String clientId) {
        boolean success = this.clientSessions.getOrDefault(client, Collections.emptySet()).remove(clientId);
        if (success) {
            new ArrayList<ClientSessionListener>(this.listeners).forEach(listener -> listener.sessionClosed(clientId, client));
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean disconnectClient(GLSPClient client) {
        if (this.clientSessions.containsKey(client)) {
            ArrayList sessionsToDisconnect = new ArrayList(this.clientSessions.getOrDefault(client, Collections.emptySet()));
            sessionsToDisconnect.forEach(clientId -> {
                boolean bl = this.disposeClientSession(client, (String)clientId);
            });
            this.clientSessions.remove(client);
            new ArrayList<ClientSessionListener>(this.listeners).forEach(listener -> listener.clientDisconnected(client));
            return true;
        }
        return false;
    }

    @Override
    public boolean addListener(ClientSessionListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ClientSessionListener listener) {
        return this.listeners.remove(listener);
    }
}

