/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.util;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public final class ReflectionUtil {
    private static Logger LOG = Logger.getLogger(ReflectionUtil.class);

    private ReflectionUtil() {
    }

    public static <T> Optional<T> construct(Class<? extends T> clazz) {
        try {
            return Optional.of(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException | SecurityException e) {
            LOG.error((Object)("Could not construct instance of class: " + clazz), (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> List<? extends T> construct(Collection<Class<? extends T>> classes) {
        return classes.stream().filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).map(ReflectionUtil::construct).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

