/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.di;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.binder.ScopedBindingBuilder;
import java.util.Optional;
import org.eclipse.glsp.graph.GraphExtension;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.ActionHandlerRegistry;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.diagram.DiagramConfigurationRegistry;
import org.eclipse.glsp.server.features.commandpalette.CommandPaletteActionProvider;
import org.eclipse.glsp.server.features.contextactions.ContextActionsProviderRegistry;
import org.eclipse.glsp.server.features.contextmenu.ContextMenuItemProvider;
import org.eclipse.glsp.server.features.core.model.ModelFactory;
import org.eclipse.glsp.server.features.directediting.ContextEditValidatorRegistry;
import org.eclipse.glsp.server.features.directediting.LabelEditValidator;
import org.eclipse.glsp.server.features.modelsourcewatcher.ModelSourceWatcher;
import org.eclipse.glsp.server.features.navigation.NavigationTargetProviderRegistry;
import org.eclipse.glsp.server.features.navigation.NavigationTargetResolver;
import org.eclipse.glsp.server.features.popup.PopupModelFactory;
import org.eclipse.glsp.server.features.toolpalette.ToolPaletteItemProvider;
import org.eclipse.glsp.server.features.validation.ModelValidator;
import org.eclipse.glsp.server.jsonrpc.GraphGsonConfiguratorFactory;
import org.eclipse.glsp.server.layout.ILayoutEngine;
import org.eclipse.glsp.server.layout.ServerLayoutConfiguration;
import org.eclipse.glsp.server.model.ModelStateProvider;
import org.eclipse.glsp.server.operations.OperationHandlerRegistry;
import org.eclipse.glsp.server.protocol.ClientSessionManager;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServer;

public abstract class GLSPModule
extends AbstractModule {
    protected void configure() {
        this.bind(GLSPServer.class).to(this.bindGLSPServer()).in(Singleton.class);
        this.bind(PopupModelFactory.class).to(this.bindPopupModelFactory());
        this.bind(ModelFactory.class).to(this.bindModelFactory());
        this.bind(ILayoutEngine.class).to(this.bindLayoutEngine());
        this.bind(ModelValidator.class).to(this.bindModelValidator());
        this.bind(ActionDispatcher.class).to(this.bindActionDispatcher()).in(Singleton.class);
        this.bind(LabelEditValidator.class).to(this.bindLabelEditValidator());
        this.bind(ModelStateProvider.class).to(this.bindModelStateProvider());
        this.bind(GraphGsonConfiguratorFactory.class).to(this.bindGraphGsonConfiguratorFactory());
        this.bind(ServerLayoutConfiguration.class).to(this.bindServerLayoutConfiguration()).in(Singleton.class);
        this.bind(ToolPaletteItemProvider.class).to(this.bindToolPaletteItemProvider());
        this.bind(CommandPaletteActionProvider.class).to(this.bindCommandPaletteActionProvider());
        this.bind(ContextMenuItemProvider.class).to(this.bindContextMenuItemProvider());
        this.bind(NavigationTargetResolver.class).to(this.bindNavigationTargetResolver());
        this.bind(ModelSourceWatcher.class).to(this.bindModelSourceWatcher()).in(Singleton.class);
        this.bind(ClientSessionManager.class).toInstance((Object)this.getClientSessionManager());
        this.bind(ActionRegistry.class).to(this.bindActionRegistry()).in(Singleton.class);
        this.bind(ActionHandlerRegistry.class).to(this.bindActionHandlerRegistry()).in(Singleton.class);
        this.bind(OperationHandlerRegistry.class).to(this.bindOperationHandlerRegistry()).in(Singleton.class);
        this.bind(DiagramConfigurationRegistry.class).to(this.bindDiagramConfigurationRegistry()).in(Singleton.class);
        this.bind(ContextActionsProviderRegistry.class).to(this.bindContextActionsProviderRegistry()).in(Singleton.class);
        this.bind(NavigationTargetProviderRegistry.class).to(this.bindNavigationTargetProviderRegistry()).in(Singleton.class);
        this.bind(ContextEditValidatorRegistry.class).to(this.bindContextEditValidatorRegistry()).in(Singleton.class);
        Optional.ofNullable(this.bindGraphExtension()).ifPresent(ext -> {
            ScopedBindingBuilder scopedBindingBuilder = this.bind(GraphExtension.class).to(ext);
        });
    }

    protected abstract ClientSessionManager getClientSessionManager();

    protected abstract Class<? extends ModelStateProvider> bindModelStateProvider();

    protected abstract Class<? extends GLSPServer> bindGLSPServer();

    protected abstract Class<? extends GraphGsonConfiguratorFactory> bindGraphGsonConfiguratorFactory();

    protected abstract Class<? extends ModelFactory> bindModelFactory();

    protected Class<? extends PopupModelFactory> bindPopupModelFactory() {
        return PopupModelFactory.NullImpl.class;
    }

    protected Class<? extends ILayoutEngine> bindLayoutEngine() {
        return ILayoutEngine.NullImpl.class;
    }

    protected Class<? extends ModelValidator> bindModelValidator() {
        return ModelValidator.NullImpl.class;
    }

    protected Class<? extends ActionDispatcher> bindActionDispatcher() {
        return ActionDispatcher.NullImpl.class;
    }

    protected Class<? extends LabelEditValidator> bindLabelEditValidator() {
        return LabelEditValidator.NullImpl.class;
    }

    protected Class<? extends ServerLayoutConfiguration> bindServerLayoutConfiguration() {
        return ServerLayoutConfiguration.NullImpl.class;
    }

    protected Class<? extends CommandPaletteActionProvider> bindCommandPaletteActionProvider() {
        return CommandPaletteActionProvider.NullImpl.class;
    }

    protected Class<? extends ContextMenuItemProvider> bindContextMenuItemProvider() {
        return ContextMenuItemProvider.NullImpl.class;
    }

    protected Class<? extends ToolPaletteItemProvider> bindToolPaletteItemProvider() {
        return ToolPaletteItemProvider.NullImpl.class;
    }

    protected Class<? extends NavigationTargetResolver> bindNavigationTargetResolver() {
        return NavigationTargetResolver.NullImpl.class;
    }

    protected Class<? extends ModelSourceWatcher> bindModelSourceWatcher() {
        return ModelSourceWatcher.NullImpl.class;
    }

    protected abstract Class<? extends ActionRegistry> bindActionRegistry();

    protected abstract Class<? extends ActionHandlerRegistry> bindActionHandlerRegistry();

    protected abstract Class<? extends OperationHandlerRegistry> bindOperationHandlerRegistry();

    protected abstract Class<? extends DiagramConfigurationRegistry> bindDiagramConfigurationRegistry();

    protected abstract Class<? extends ContextActionsProviderRegistry> bindContextActionsProviderRegistry();

    protected abstract Class<? extends NavigationTargetProviderRegistry> bindNavigationTargetProviderRegistry();

    protected abstract Class<? extends ContextEditValidatorRegistry> bindContextEditValidatorRegistry();

    protected Class<? extends GraphExtension> bindGraphExtension() {
        return null;
    }

    @Provides
    private GLSPClient getGLSPClient(GLSPServer glspServer) {
        return glspServer.getClient();
    }
}

