/*
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

//
// This Javascript file should be included in any page that uses the associated
// component, where JSF Extensions is used as the underlying transfer protocol.
//

dojo.provide("webui.suntheme.widget.jsfx.table2RowGroup");

dojo.require("webui.suntheme.widget.table2RowGroup");

/**
 * This function is used to obtain data asynchronously.
 */
webui.suntheme.widget.jsfx.table2RowGroup = {
    /**
     * This function is used to process scroll events.
     *
     * @param evt Event generated by scroll bar.
     */
    processScrollEvent: function(evt) {
        if (evt == null) {
            return false;
        }

        var domNode;
        if (evt.currentTarget) {
            domNode = evt.currentTarget;
        } else {
            return false;
        }

        // Ensure we have a valid element node.
        var src = document.getElementById(domNode.id);

        // Generate AJAX request using the JSF Extensions library.
        new DynaFaces.fireAjaxTransaction((src) ? src : document.forms[0], {
            execute: "none",
            render: domNode.id,
            replaceElement: webui.suntheme.widget.jsfx.table2RowGroup.update,
            xjson: {
                first: domNode._first
            }
        });
        return true;
    },

    /**
     * This function is used to update widgets.
     *
     * @param elementId The HTML element Id.
     * @param content The content returned by the AJAX response.
     * @param closure The closure argument provided to DynaFaces.fireAjaxTransaction.
     * @param xjson The zjson argument provided to DynaFaces.fireAjaxTransaction.
     */
    update: function(elementId, content, closure, xjson) {
        if (elementId == null || content == null) {
            return false;
        }

        // Parse JSON text.
        var json = JSON.parse(content);

        // Add rows.
        var domNode = document.getElementById(elementId);
        domNode._addRows({
            first: xjson.first,
            rows: json
        });

        // Publish an event for custom AJAX implementations to listen for.
        webui.suntheme.widget.table2RowGroup.scroll.publishEndEvent(json);
        return true;
    }
}

// Listen for Dojo Widget events.
dojo.event.topic.subscribe(webui.suntheme.widget.table2RowGroup.scroll.beginEventTopic,
    webui.suntheme.widget.jsfx.table2RowGroup, "processScrollEvent");

//-->
