/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="enable-http-lb-application")
@PerLookup
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.POST, path="enable-http-lb-application", description="enable-http-lb-application", params={@RestParam(name="name", value="$parent")})})
public final class EnableHTTPLBApplicationCommand
implements AdminCommand {
    @Param(primary=true)
    String target;
    @Param(optional=false)
    String name;
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableHTTPLBApplicationCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ApplicationRef appRef = this.domain.getApplicationRefInTarget(this.name, this.target);
        if (appRef == null) {
            String msg = localStrings.getLocalString("AppRefNotDefined", "Application ref [{0}] does not exist in server [{1}]", new Object[]{this.name, this.target});
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        boolean appEnabled = Boolean.valueOf(appRef.getEnabled());
        if (appEnabled) {
            if (appRef.getLbEnabled().equals("true")) {
                String msg = localStrings.getLocalString("AppEnabled", "Application [{0}] is already enabled for [{1}].", new Object[]{this.name, this.target});
                logger.warning(msg);
                report.setMessage(msg);
            } else {
                try {
                    this.updateLbEnabledForApp(this.name, this.target);
                }
                catch (TransactionFailure e) {
                    String msg = localStrings.getLocalString("FailedToUpdateAttr", "Failed to update lb-enabled attribute for {0}", new Object[]{this.name});
                    logger.warning(msg);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(msg);
                    report.setFailureCause((Throwable)e);
                }
            }
        }
    }

    public void updateLbEnabledForApp(final String appName, final String target) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                if (t != null) {
                    Cluster cluster;
                    Server servr = ((Domain)param).getServerNamed(target);
                    if (servr != null) {
                        for (ApplicationRef appRef : servr.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                            ((ApplicationRef)appRef_w).setLbEnabled("true");
                            break;
                        }
                    }
                    if ((cluster = ((Domain)param).getClusterNamed(target)) != null) {
                        for (ApplicationRef appRef : cluster.getApplicationRef()) {
                            if (!appRef.getRef().equals(appName)) continue;
                            ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                            ((ApplicationRef)appRef_w).setLbEnabled("true");
                            break;
                        }
                        block2: for (Server svr : cluster.getInstances()) {
                            for (ApplicationRef appRef : svr.getApplicationRef()) {
                                if (!appRef.getRef().equals(appName)) continue;
                                ConfigBeanProxy appRef_w = t.enroll((ConfigBeanProxy)appRef);
                                ((ApplicationRef)appRef_w).setLbEnabled("true");
                                continue block2;
                            }
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)this.domain);
    }
}

