/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

class RouterHelper {
    private static RouterHelper sprm = new RouterHelper(true);
    private boolean useGEFRouter = true;
    private Map<IFigure, ShortestPathConnectionRouter> routers = new WeakHashMap<IFigure, ShortestPathConnectionRouter>();
    private Map<Connection, ShortestPathConnectionRouter> lastUsedRouter = new WeakHashMap<Connection, ShortestPathConnectionRouter>();
    private static final int ROUTER_OBSTRUCTION_BUFFER = 12;

    public static RouterHelper getInstance() {
        return sprm;
    }

    private RouterHelper(boolean useGEFRouter) {
        this.useGEFRouter = useGEFRouter;
    }

    protected boolean getUseGEFRouter() {
        return this.useGEFRouter;
    }

    public void setConstraint(Connection conn, Object constraint) {
        ShortestPathConnectionRouter spcr;
        if (this.useGEFRouter && this.isAvoidingObstructions(conn) && (spcr = this.getConnRouter(conn, false)) != null) {
            this.setConstraint(spcr, conn, constraint);
        }
    }

    public void setConstraint(ShortestPathConnectionRouter spcr, Connection conn, Object constraint) {
        spcr.setConstraint(conn, null);
    }

    public void remove(Connection conn) {
        ShortestPathConnectionRouter spcr;
        if (this.useGEFRouter && this.isAvoidingObstructions(conn) && (spcr = this.getConnRouter(conn, false)) != null) {
            this.cleanUpAvoidObstaclesRouter(spcr, conn);
        }
    }

    private void cleanUpAvoidObstaclesRouter(ShortestPathConnectionRouter router, Connection conn) {
        if (router != null) {
            router.remove(conn);
            if (!router.hasMoreConnections()) {
                this.routers.remove(router.getContainer());
            }
            this.lastUsedRouter.remove(conn);
        }
    }

    public void invalidate(Connection conn) {
        ShortestPathConnectionRouter spcr;
        if (this.useGEFRouter && this.isAvoidingObstructions(conn) && (spcr = this.getConnRouter(conn, false)) != null) {
            spcr.invalidate(conn);
        }
    }

    private ShortestPathConnectionRouter getRouter(IFigure figContainer, boolean createNew) {
        ShortestPathConnectionRouter shortestPathRouter = this.routers.get(figContainer);
        if (shortestPathRouter == null && createNew) {
            shortestPathRouter = new ShortestPathConnectionRouter(figContainer);
            shortestPathRouter.setSpacing(MapModeUtil.getMapMode(figContainer).DPtoLP(10));
            this.routers.put(figContainer, shortestPathRouter);
        }
        return shortestPathRouter;
    }

    protected ShortestPathConnectionRouter getConnRouter(Connection conn, boolean forRouting) {
        ShortestPathConnectionRouter lur = this.lastUsedRouter.get(conn);
        IFigure container = null;
        IFigure sourcefigContainer = this.getSourceContainer(conn);
        IFigure targetfigContainer = this.getTargetContainer(conn);
        if (sourcefigContainer == null || targetfigContainer == null) {
            if (lur != null) {
                return lur;
            }
            container = null;
        } else {
            container = sourcefigContainer != targetfigContainer ? null : sourcefigContainer;
        }
        if (container == null) {
            if (lur != null) {
                this.cleanUpAvoidObstaclesRouter(lur, conn);
            }
            return null;
        }
        ShortestPathConnectionRouter spcr = this.getRouter(container, forRouting);
        if (spcr != null && forRouting && lur != spcr) {
            if (lur != null) {
                this.cleanUpAvoidObstaclesRouter(lur, conn);
            }
            this.lastUsedRouter.put(conn, spcr);
        }
        return spcr;
    }

    public boolean isFeedback(Connection conn) {
        Dimension dim = new Dimension(100, 100);
        Dimension dimCheck = dim.getCopy();
        conn.translateToRelative((Translatable)dimCheck);
        return dim.equals((Object)dimCheck);
    }

    public PointList routeFromConstraint(Connection conn) {
        List bendpoints;
        if (this.useGEFRouter && this.lastUsedRouter.get(conn) != null) {
            this.cleanUpAvoidObstaclesRouter(this.lastUsedRouter.get(conn), conn);
        }
        if ((bendpoints = (List)conn.getConnectionRouter().getConstraint(conn)) == null) {
            bendpoints = Collections.EMPTY_LIST;
        }
        PointList points = new PointList(bendpoints.size());
        int i = 0;
        while (i < bendpoints.size()) {
            Bendpoint bp = (Bendpoint)bendpoints.get(i);
            points.addPoint(bp.getLocation());
            ++i;
        }
        if (bendpoints.size() == 0) {
            Point r1 = conn.getSourceAnchor().getReferencePoint().getCopy();
            conn.translateToRelative((Translatable)r1);
            points.addPoint(r1);
            Point r2 = conn.getTargetAnchor().getReferencePoint().getCopy();
            conn.translateToRelative((Translatable)r2);
            points.addPoint(r2);
        }
        return points;
    }

    public PointList routeClosestDistance(Connection conn) {
        if (this.useGEFRouter && this.lastUsedRouter.get(conn) != null) {
            this.cleanUpAvoidObstaclesRouter(this.lastUsedRouter.get(conn), conn);
        }
        PointList newLine = this.routeFromConstraint(conn);
        Point ptOrig = new Point(newLine.getFirstPoint());
        Point ptTerm = new Point(newLine.getLastPoint());
        newLine.removeAllPoints();
        newLine.addPoint(ptOrig);
        newLine.addPoint(ptTerm);
        return newLine;
    }

    public PointList routeAroundObstructions(Connection conn) {
        PointList newLine = null;
        newLine = this.routeClosestDistance(conn);
        Point infimumPoint = PointListUtilities.getPointsInfimum(newLine);
        Point supremumPoint = PointListUtilities.getPointsSupremum(newLine);
        Ray diameter = new Ray(infimumPoint, supremumPoint);
        Rectangle rPoly = new Rectangle(infimumPoint.x, infimumPoint.y, diameter.x, diameter.y);
        LinkedList<Rectangle> collectObstructs = new LinkedList<Rectangle>();
        IFigure parent = this.getRouterContainerFigure(conn);
        if (parent == null) {
            return this.routeFromConstraint(conn);
        }
        Point ptRef = conn.getSourceAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptRef);
        newLine.setPoint(ptRef, 0);
        ptRef = conn.getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptRef);
        newLine.setPoint(ptRef, newLine.size() - 1);
        Rectangle rBoundingRect = new Rectangle(parent.getBounds());
        parent.translateToAbsolute((Translatable)rBoundingRect);
        conn.translateToRelative((Translatable)rBoundingRect);
        if (rPoly.width > rPoly.height) {
            rPoly.y = rBoundingRect.y;
            rPoly.setSize(rPoly.width, rBoundingRect.height);
        } else {
            rPoly.x = rBoundingRect.x;
            rPoly.setSize(rBoundingRect.width, rPoly.height);
        }
        this.collectObstructions(conn, rPoly, collectObstructs);
        if (collectObstructs.size() > 0) {
            Dimension buffer = new Dimension(13, 0);
            if (!this.isFeedback(conn)) {
                buffer = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)buffer);
            }
            int inflate = buffer.width;
            LinkedList<Rectangle> collapsedRects = this.collapseRects(collectObstructs, inflate);
            collectObstructs.clear();
            boolean bRouted = true;
            while (bRouted && !collapsedRects.isEmpty()) {
                ListIterator listIter = collapsedRects.listIterator();
                bRouted = false;
                while (listIter.hasNext()) {
                    Rectangle rObstruct = (Rectangle)listIter.next();
                    PointList routedPoly = PointListUtilities.routeAroundRect(newLine, rObstruct, 0, false, inflate);
                    if (routedPoly != null) {
                        bRouted = true;
                        newLine.removeAllPoints();
                        newLine.addAll(routedPoly);
                        continue;
                    }
                    collectObstructs.add(rObstruct);
                }
                LinkedList<Rectangle> tempList = collapsedRects;
                collapsedRects = collectObstructs;
                tempList.clear();
                collectObstructs = tempList;
                if (!bRouted || collapsedRects.isEmpty()) continue;
                this.resetEndPointsToEdge(conn, newLine);
            }
        }
        return newLine;
    }

    protected void collectObstructions(Connection connection, Rectangle connectionRect, List obstructionsToReturn) {
        HashSet<IFigure> containerFiguresToSearch = new HashSet<IFigure>();
        HashSet<IFigure> figuresToExclude = new HashSet<IFigure>();
        IFigure figure = connection.getSourceAnchor().getOwner();
        figuresToExclude.add(figure);
        figure = figure.getParent();
        while (figure != null) {
            if (figure.getLayoutManager() instanceof XYLayout) {
                containerFiguresToSearch.add(figure);
            }
            figuresToExclude.add(figure);
            figure = figure.getParent();
        }
        figure = connection.getTargetAnchor().getOwner();
        figuresToExclude.add(figure);
        figure = figure.getParent();
        while (figure != null) {
            if (figure.getLayoutManager() instanceof XYLayout) {
                containerFiguresToSearch.add(figure);
            }
            figuresToExclude.add(figure);
            figure = figure.getParent();
        }
        for (IFigure containerFigure : containerFiguresToSearch) {
            for (IFigure childFigure : containerFigure.getChildren()) {
                if (figuresToExclude.contains(childFigure)) continue;
                Rectangle rObstruct = new Rectangle(childFigure.getBounds());
                childFigure.translateToAbsolute((Translatable)rObstruct);
                connection.translateToRelative((Translatable)rObstruct);
                rObstruct.expand(1, 1);
                if (!connectionRect.intersects(rObstruct)) continue;
                obstructionsToReturn.add(rObstruct);
            }
        }
    }

    public void resetEndPointsToEdge(Connection conn, PointList newLine) {
        PrecisionPoint targetAnchorPoint;
        PrecisionPoint sourceAnchorPoint;
        if (newLine.size() < 2) {
            newLine.addPoint(0, 0);
            newLine.insertPoint(new Point(), 0);
        }
        if (newLine.size() > 2) {
            PrecisionPoint sourceReference = new PrecisionPoint(newLine.getPoint(1));
            PrecisionPoint targetReference = new PrecisionPoint(newLine.getPoint(newLine.size() - 2));
            conn.translateToAbsolute((Translatable)sourceReference);
            conn.translateToAbsolute((Translatable)targetReference);
            sourceAnchorPoint = this.getAnchorLocation(conn.getSourceAnchor(), (Point)sourceReference);
            targetAnchorPoint = this.getAnchorLocation(conn.getTargetAnchor(), (Point)targetReference);
        } else {
            PrecisionPoint sourceReference = this.getAnchorReference(conn.getTargetAnchor());
            sourceAnchorPoint = this.getAnchorLocation(conn.getSourceAnchor(), (Point)sourceReference);
            targetAnchorPoint = this.getAnchorLocation(conn.getTargetAnchor(), (Point)sourceAnchorPoint);
        }
        conn.translateToRelative((Translatable)sourceAnchorPoint);
        conn.translateToRelative((Translatable)targetAnchorPoint);
        newLine.setPoint((Point)sourceAnchorPoint, 0);
        newLine.setPoint((Point)targetAnchorPoint, newLine.size() - 1);
    }

    private List collapseRects(List collectRect, int inflate) {
        if (collectRect.size() == 0) {
            return new LinkedList();
        }
        Rectangle rCompare = new Rectangle((Rectangle)collectRect.remove(0));
        List collapsedRects = this.collapseRects(rCompare, collectRect, inflate);
        collapsedRects.add(rCompare);
        return collapsedRects;
    }

    private List collapseRects(Rectangle rCompare, List collectRect, int inflate) {
        LinkedList<Rectangle> newCollect = new LinkedList<Rectangle>();
        Rectangle rCompare1 = new Rectangle(rCompare);
        boolean intersectionOccurred = false;
        ListIterator listIter = collectRect.listIterator();
        while (listIter.hasNext()) {
            Rectangle rCompare2 = new Rectangle((Rectangle)listIter.next());
            Rectangle rExpandRect1 = new Rectangle(rCompare1);
            Rectangle rExpandRect2 = new Rectangle(rCompare2);
            rExpandRect1.expand(inflate, inflate);
            rExpandRect2.expand(inflate, inflate);
            if (rExpandRect1.intersects(rExpandRect2)) {
                rCompare1.union(rCompare2);
                intersectionOccurred = true;
                continue;
            }
            newCollect.add(rCompare2);
        }
        rCompare.setBounds(rCompare1);
        if (newCollect.size() > 0) {
            if (intersectionOccurred) {
                return this.collapseRects(rCompare, newCollect, inflate);
            }
            Rectangle rFirst = new Rectangle((Rectangle)newCollect.remove(0));
            List finalCollapse = this.collapseRects(rFirst, newCollect, inflate);
            finalCollapse.add(rFirst);
            return finalCollapse;
        }
        return newCollect;
    }

    private IFigure getRouterContainerFigure(Connection conn) {
        IFigure sourcefigContainer = this.getSourceContainer(conn);
        IFigure targetfigContainer = this.getTargetContainer(conn);
        IFigure commonFig = FigureUtilities.findCommonAncestor((IFigure)sourcefigContainer, (IFigure)targetfigContainer);
        IFigure routerContainer = null;
        if (sourcefigContainer == null || targetfigContainer == null) {
            return null;
        }
        if (sourcefigContainer == targetfigContainer) {
            routerContainer = sourcefigContainer;
        } else if (commonFig != sourcefigContainer && commonFig != targetfigContainer) {
            routerContainer = commonFig;
        } else {
            IFigure checkFig = sourcefigContainer;
            if (commonFig == sourcefigContainer) {
                checkFig = targetfigContainer;
            }
            Rectangle checkRect = checkFig.getBounds().getCopy();
            checkFig.translateToAbsolute((Translatable)checkRect);
            conn.translateToRelative((Translatable)checkRect);
            int sourceDistance = this.findDistanceToEndRect(conn.getPoints(), checkRect);
            int targetDistance = (int)PointListUtilities.getPointsLength(conn.getPoints()) - sourceDistance;
            routerContainer = sourceDistance > targetDistance ? sourcefigContainer : targetfigContainer;
        }
        return routerContainer;
    }

    protected IFigure getSourceContainer(Connection conn) {
        if (conn.getSourceAnchor() != null) {
            return this.findContainerFigure(conn.getSourceAnchor().getOwner());
        }
        return null;
    }

    protected IFigure getTargetContainer(Connection conn) {
        if (conn.getTargetAnchor() != null) {
            return this.findContainerFigure(conn.getTargetAnchor().getOwner());
        }
        return null;
    }

    private IFigure findContainerFigure(IFigure fig) {
        if (fig == null) {
            return null;
        }
        if (fig.getLayoutManager() instanceof XYLayout) {
            return fig;
        }
        return this.findContainerFigure(fig.getParent());
    }

    private int findDistanceToEndRect(PointList points, Rectangle endRect) {
        PointList intersections = new PointList();
        PointList distances = new PointList();
        boolean foundSourceDistance = PointListUtilities.findIntersections(points, PointListUtilities.createPointsFromRect(endRect), intersections, distances);
        int sourceDistance = foundSourceDistance ? distances.getFirstPoint().x : 0;
        return sourceDistance;
    }

    private PrecisionPoint getAnchorLocation(ConnectionAnchor anchor, Point reference) {
        return new PrecisionPoint(anchor.getLocation(reference));
    }

    private PrecisionPoint getAnchorReference(ConnectionAnchor anchor) {
        return new PrecisionPoint(anchor.getReferencePoint());
    }

    public boolean isAvoidingObstructions(Connection conn) {
        if (conn instanceof PolylineConnectionEx) {
            return ((PolylineConnectionEx)conn).isAvoidObstacleRouting();
        }
        return false;
    }
}

