/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.melange.metamodel.melange;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResourceType implements Enumerator
{
    MELANGE(0, "MELANGE", "MELANGE"),
    EMF(1, "EMF", "EMF"),
    XTEXT(2, "XTEXT", "XTEXT");

    public static final int MELANGE_VALUE = 0;
    public static final int EMF_VALUE = 1;
    public static final int XTEXT_VALUE = 2;
    private static final ResourceType[] VALUES_ARRAY;
    public static final List<ResourceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResourceType[]{MELANGE, EMF, XTEXT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResourceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceType get(int value) {
        switch (value) {
            case 0: {
                return MELANGE;
            }
            case 1: {
                return EMF;
            }
            case 2: {
                return XTEXT;
            }
        }
        return null;
    }

    private ResourceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

