/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.util.Base64;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class SpnegoAuthenticator
extends AuthenticatorBase {
    private static final Log log = LogFactory.getLog(SpnegoAuthenticator.class);
    private String loginConfigName = "com.sun.security.jgss.krb5.accept";
    private boolean storeDelegatedCredential = true;

    public String getLoginConfigName() {
        return this.loginConfigName;
    }

    public void setLoginConfigName(String loginConfigName) {
        this.loginConfigName = loginConfigName;
    }

    public boolean isStoreDelegatedCredential() {
        return this.storeDelegatedCredential;
    }

    public void setStoreDelegatedCredential(boolean storeDelegatedCredential) {
        this.storeDelegatedCredential = storeDelegatedCredential;
    }

    @Override
    protected String getAuthMethod() {
        return "SPNEGO";
    }

    @Override
    public String getInfo() {
        return "org.apache.catalina.authenticator.SpnegoAuthenticator/1.0";
    }

    @Override
    protected void initInternal() throws LifecycleException {
        String jaasConf;
        super.initInternal();
        String krb5Conf = System.getProperty("java.security.krb5.conf");
        if (krb5Conf == null) {
            File krb5ConfFile = new File(Bootstrap.getCatalinaBase(), "conf/krb5.ini");
            System.setProperty("java.security.krb5.conf", krb5ConfFile.getAbsolutePath());
        }
        if ((jaasConf = System.getProperty("java.security.auth.login.config")) == null) {
            File jaasConfFile = new File(Bootstrap.getCatalinaBase(), "conf/jaas.conf");
            System.setProperty("java.security.auth.login.config", jaasConfFile.getAbsolutePath());
        }
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        MessageBytes authorization;
        Principal principal = request.getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            if (ssoId != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        if (ssoId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SSO Id " + ssoId + " set; attempting " + "reauthentication"));
            }
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        if ((authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization")) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("authenticator.noAuthHeader"));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return false;
        }
        authorization.toBytes();
        ByteChunk authorizationBC = authorization.getByteChunk();
        if (!authorizationBC.startsWithIgnoreCase("negotiate ", 0)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("spnegoAuthenticator.authHeaderNotNego"));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return false;
        }
        authorizationBC.setOffset(authorizationBC.getOffset() + 10);
        ByteChunk decoded = new ByteChunk();
        Base64.decode(authorizationBC, decoded);
        if (decoded.getLength() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("spnegoAuthenticator.authHeaderNoToken"));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return false;
        }
        LoginContext lc = null;
        GSSContext gssContext = null;
        byte[] outToken = null;
        try {
            try {
                lc = new LoginContext(this.loginConfigName);
                lc.login();
            }
            catch (LoginException e) {
                log.error((Object)sm.getString("spnegoAuthenticator.serviceLoginFail"), (Throwable)e);
                response.sendError(500);
                boolean bl = false;
                if (gssContext != null) {
                    try {
                        gssContext.dispose();
                    }
                    catch (GSSException e2) {
                        // empty catch block
                    }
                }
                if (lc != null) {
                    try {
                        lc.logout();
                    }
                    catch (LoginException e3) {
                        // empty catch block
                    }
                }
                return bl;
            }
            GSSManager manager = GSSManager.getInstance();
            gssContext = manager.createContext(manager.createCredential(null, 0, new Oid("1.3.6.1.5.5.2"), 2));
            outToken = gssContext.acceptSecContext(decoded.getBytes(), decoded.getOffset(), decoded.getLength());
            if (outToken == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("spnegoAuthenticator.ticketValidateFail"));
                }
                response.setHeader("WWW-Authenticate", "Negotiate");
                response.sendError(401);
                boolean bl = false;
                return bl;
            }
            principal = this.context.getRealm().authenticate(gssContext, this.storeDelegatedCredential);
        }
        catch (GSSException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("spnegoAuthenticator.ticketValidateFail", new Object[]{e}));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            boolean bl = false;
            return bl;
        }
        finally {
            if (gssContext != null) {
                try {
                    gssContext.dispose();
                }
                catch (GSSException e) {}
            }
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException e) {}
            }
        }
        response.setHeader("WWW-Authenticate", "Negotiate " + Base64.encode(outToken));
        if (principal != null) {
            this.register(request, response, principal, "SPNEGO", principal.getName(), null);
            return true;
        }
        response.sendError(401);
        return false;
    }
}

