/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.gemini.web.core.InstallationOptions;
import org.eclipse.gemini.web.core.WebBundleManifestTransformer;
import org.eclipse.gemini.web.internal.WebContainerUtils;
import org.eclipse.gemini.web.internal.url.DirTransformer;
import org.eclipse.gemini.web.internal.url.DirTransformingURLConnection;
import org.eclipse.gemini.web.internal.url.WebBundleUrl;
import org.eclipse.virgo.util.io.JarTransformer;
import org.eclipse.virgo.util.io.JarTransformingURLConnection;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public final class WebBundleUrlStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final String FILE_PROTOCOL = "file";
    private final WebBundleManifestTransformer transformer;

    public WebBundleUrlStreamHandlerService(WebBundleManifestTransformer transformer) {
        this.transformer = transformer;
    }

    public URLConnection openConnection(URL u) throws IOException {
        WebBundleUrl url = new WebBundleUrl(u);
        URL actualUrl = new URL(url.getLocation());
        if (FILE_PROTOCOL.equals(actualUrl.getProtocol()) && new File(actualUrl.getPath()).isDirectory()) {
            DirTransformer dirTransformer = new DirTransformer(new Callback(actualUrl, url, this.transformer));
            return new DirTransformingURLConnection(actualUrl, dirTransformer, true);
        }
        JarTransformer jarTransformer = new JarTransformer((JarTransformer.JarTransformerCallback)new Callback(actualUrl, url, this.transformer));
        return new JarTransformingURLConnection(actualUrl, jarTransformer, true);
    }

    private static final class Callback
    implements JarTransformer.JarTransformerCallback,
    DirTransformer.DirTransformerCallback {
        private static final Path META_INF = Paths.get("META-INF", new String[0]);
        private static final Path MANIFEST_MF = Paths.get("MANIFEST.MF", new String[0]);
        private final WebBundleManifestTransformer transformer;
        private final URL sourceURL;
        private final WebBundleUrl webBundleUrl;

        Callback(URL sourceURL, WebBundleUrl url, WebBundleManifestTransformer transformer) {
            this.sourceURL = sourceURL;
            this.webBundleUrl = url;
            this.transformer = transformer;
        }

        public boolean transformEntry(String entryName, InputStream is, JarOutputStream jos) throws IOException {
            if ("META-INF/MANIFEST.MF".equals(entryName)) {
                jos.putNextEntry(new ZipEntry(entryName));
                this.transformManifest(is, jos);
                jos.closeEntry();
                return true;
            }
            return this.isSignatureFile(entryName);
        }

        private void transformManifest(InputStream inputStream, OutputStream outputStream) throws IOException {
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BundleManifest manifest = BundleManifestFactory.createBundleManifest((Reader)reader);
            InstallationOptions options = new InstallationOptions(this.webBundleUrl.getOptions());
            if (manifest.getHeader("org-eclipse-gemini-web-DefaultWABHeaders") != null) {
                options.setDefaultWABHeaders(true);
            }
            boolean webBundle = WebContainerUtils.isWebApplicationBundle(manifest);
            this.transformer.transform(manifest, this.sourceURL, options, webBundle);
            Callback.toManifest(manifest.toDictionary()).write(outputStream);
        }

        private boolean isSignatureFile(String entryName) {
            String entryFileName;
            String[] entryNameComponents = entryName.split("/");
            return entryNameComponents.length == 2 && "META-INF".equals(entryNameComponents[0]) && ((entryFileName = entryNameComponents[1]).endsWith(".SF") || entryFileName.endsWith(".DSA") || entryFileName.endsWith(".RSA"));
        }

        private static Manifest toManifest(Dictionary<String, String> headers) {
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            Enumeration<String> names = headers.keys();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                String value = headers.get(name);
                attributes.putValue(name, value);
            }
            return manifest;
        }

        @Override
        public boolean transformFile(InputStream inputStream, Path toFile) throws IOException {
            if (MANIFEST_MF.equals(toFile.getFileName()) && META_INF.equals(toFile.getParent().getFileName())) {
                Files.createDirectories(toFile.getParent(), new FileAttribute[0]);
                Throwable throwable = null;
                Object var4_5 = null;
                try (OutputStream outputStream = Files.newOutputStream(toFile, new OpenOption[0]);){
                    this.transformManifest(inputStream, outputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return true;
            }
            return this.isSignatureFile(toFile);
        }

        private boolean isSignatureFile(Path file) {
            String fileName;
            return META_INF.equals(file.getParent().getFileName()) && ((fileName = file.getFileName().toString()).endsWith(".SF") || fileName.endsWith(".DSA") || fileName.endsWith(".RSA"));
        }
    }
}

