/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data;

import java.util.Iterator;
import java.util.List;
import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.SelectChoice;
import org.eclipse.escet.chi.runtime.data.CoreProcess;
import org.eclipse.escet.chi.runtime.data.DefinitionKind;
import org.eclipse.escet.chi.runtime.data.PositionData;
import org.eclipse.escet.chi.runtime.data.Timer;
import org.eclipse.escet.common.java.Lists;

public abstract class BaseProcess
extends CoreProcess<BaseProcess> {
    public final String name;
    public List<SelectChoice> selectList;
    public List<SelectChoice> blockedChoices = null;
    public SelectChoice readyChoice = null;
    public Timer delayTimer;
    protected List<CoreProcess<BaseProcess>> chiChilds;
    public List<PositionData> positionStack;
    public PositionData position;
    public final DefinitionKind kind;
    protected int chiProgramCounter;
    protected ChiCoordinator chiCoordinator;

    public BaseProcess(ChiCoordinator chiCoordinator, DefinitionKind kind, String name) {
        super(CoreProcess.RunResult.STARTED);
        this.chiCoordinator = chiCoordinator;
        this.name = name;
        this.selectList = Lists.list();
        this.delayTimer = null;
        this.chiChilds = null;
        this.chiProgramCounter = -1;
        this.kind = kind;
        this.position = new PositionData(kind, name);
        this.positionStack = Lists.list((Object)this.position);
    }

    protected void setDelayTimer(double delayLength) {
        this.delayTimer = new Timer(this.chiCoordinator, delayLength += this.chiCoordinator.getCurrentTime());
    }

    protected void setSelect(List<SelectChoice> choices) {
        this.chiCoordinator.setSelect(this, choices);
    }

    protected void clearChildProcesses() {
        if (this.chiChilds == null) {
            this.chiChilds = Lists.list();
        } else {
            this.chiChilds.clear();
        }
    }

    public boolean allChildProcessesFinished() {
        Iterator<CoreProcess<BaseProcess>> iter = this.chiChilds.iterator();
        while (iter.hasNext()) {
            CoreProcess<BaseProcess> p = iter.next();
            if (!p.isFinished()) continue;
            iter.remove();
        }
        return this.chiChilds.isEmpty();
    }

    public abstract CoreProcess.RunResult run(SelectChoice var1);
}

