/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.xloader;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.progress.ProgressMonitor;
import org.apache.jena.system.progress.ProgressMonitorOutput;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.params.StoreParams;
import org.apache.jena.tdb2.solver.stats.Stats;
import org.apache.jena.tdb2.solver.stats.StatsCollectorNodeId;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb2.store.value.DoubleNode62;
import org.apache.jena.tdb2.sys.DatabaseConnection;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.apache.jena.tdb2.xloader.BulkLoaderX;
import org.apache.jena.tdb2.xloader.WriteRows;
import org.apache.jena.tdb2.xloader.XLoaderFiles;

public class ProcIngestDataX {
    public static void exec(String location, XLoaderFiles loaderFiles, List<String> datafiles, boolean collectStats) {
        FmtLog.info(BulkLoaderX.LOG_Data, "Ingest data", new Object[0]);
        IRIProvider provider = SystemIRIx.getProvider();
        DatasetGraph dsg = ProcIngestDataX.getDatasetGraph(location);
        ProgressMonitorOutput monitor = ProgressMonitorOutput.create(BulkLoaderX.LOG_Data, "Data", (long)BulkLoaderX.DataTick, BulkLoaderX.DataSuperTick);
        OutputStream outputTriples = IO.openOutputFile(loaderFiles.triplesFile);
        OutputStream outputQuads = IO.openOutputFile(loaderFiles.quadsFile);
        OutputStream outT = outputTriples;
        OutputStream outQ = outputQuads;
        dsg.executeWrite(() -> {
            Pair<Long, Long> p = ProcIngestDataX.build(dsg, monitor, outT, outQ, datafiles);
            String str2 = DateTimeUtils.nowAsXSDDateTimeString();
            long cTriple = p.getLeft();
            long cQuad = p.getRight();
            FmtLog.info(BulkLoaderX.LOG_Data, "Triples = %,d ; Quads = %,d", cTriple, cQuad);
            JsonObject obj = JSON.buildObject(b -> {
                b.pair("ingested", str2);
                b.key("data").startArray();
                datafiles.forEach(fn -> b.value((String)fn));
                b.finishArray();
                b.pair("triples", cTriple);
                b.pair("quads", cQuad);
            });
            try (OutputStream out = IO.openOutputFile(loaderFiles.loadInfo);){
                JSON.write(out, (JsonValue)obj);
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        });
        TDBInternal.expel(dsg);
        SystemIRIx.setProvider(provider);
    }

    private static DatasetGraph getDatasetGraph(String location) {
        Location loc = Location.create(location);
        DatasetGraph dsg0 = DatabaseMgr.connectDatasetGraph(location);
        StoreParams storeParams = TDBInternal.getDatasetGraphTDB(dsg0).getStoreParams();
        TDBInternal.expel(dsg0);
        storeParams = StoreParams.builder("xloader", storeParams).node2NodeIdCacheSize(10000000).build();
        DatasetGraph dsg = DatabaseConnection.connectCreate(loc, storeParams, null).getDatasetGraph();
        StoreParams storeParamsActual = TDBInternal.getDatasetGraphTDB(dsg).getStoreParams();
        return dsg;
    }

    private static Pair<Long, Long> build(DatasetGraph dsg, ProgressMonitor monitor, OutputStream outputTriples, OutputStream outputQuads, List<String> datafiles) {
        Location location;
        DatasetGraphTDB dsgtdb = TDBInternal.getDatasetGraphTDB(dsg);
        outputTriples = IO.ensureBuffered(outputTriples);
        outputQuads = IO.ensureBuffered(outputQuads);
        IngestData sink = new IngestData(dsgtdb, monitor, outputTriples, outputQuads, false);
        Timer timer = new Timer();
        timer.startTimer();
        monitor.start();
        sink.startBulk();
        AsyncParser.asyncParse(datafiles, (StreamRDF)sink);
        sink.finishBulk();
        IO.close(outputTriples);
        IO.close(outputQuads);
        long cTriple = sink.tripleCount();
        long cQuad = sink.quadCount();
        if (sink.getCollector() != null && !(location = dsgtdb.getLocation()).isMem()) {
            Stats.write(location.getPath("stats.opt"), sink.getCollector().results());
        }
        monitor.finish();
        long time = timer.endTimer();
        long total = monitor.getTicks();
        float elapsedSecs = (float)time / 1000.0f;
        float rate = elapsedSecs != 0.0f ? (float)total / elapsedSecs : 0.0f;
        String str2 = String.format("%s Total: %,d tuples : %,.2f seconds : %,.2f tuples/sec [%s]", "==-==-==", total, Float.valueOf(elapsedSecs), Float.valueOf(rate), DateTimeUtils.nowAsString());
        BulkLoaderX.LOG_Data.info(str2);
        return Pair.create(cTriple, cQuad);
    }

    static class IngestData
    implements StreamRDF {
        private DatasetGraphTDB dsg;
        private NodeTable nodeTable;
        long countTriples = 0L;
        long countQuads = 0L;
        private WriteRows writerTriples;
        private WriteRows writerQuads;
        private ProgressMonitor monitor;
        private StatsCollectorNodeId stats;

        IngestData(DatasetGraphTDB dsg, ProgressMonitor monitor, OutputStream outputTriples, OutputStream outputQuads, boolean collectStats) {
            this.dsg = dsg;
            this.monitor = monitor;
            NodeTupleTable ntt = dsg.getTripleTable().getNodeTupleTable();
            this.nodeTable = ntt.getNodeTable();
            this.writerTriples = new WriteRows(outputTriples, 3, 100000);
            this.writerQuads = new WriteRows(outputQuads, 4, 100000);
            if (collectStats) {
                this.stats = new StatsCollectorNodeId(this.nodeTable);
            }
        }

        public void startBulk() {
        }

        @Override
        public void start() {
        }

        @Override
        public void finish() {
        }

        public void finishBulk() {
            this.writerTriples.flush();
            this.writerQuads.flush();
            this.nodeTable.sync();
        }

        @Override
        public void triple(Triple triple) {
            ++this.countTriples;
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.process(Quad.tripleInQuad, s, p, o);
        }

        @Override
        public void quad(Quad quad) {
            ++this.countQuads;
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = null;
            if (!quad.isTriple() && !quad.isDefaultGraph()) {
                g = quad.getGraph();
            }
            this.process(g, s, p, o);
        }

        private static long encode(NodeId nodeId) {
            long x = nodeId.getPtrLocation();
            switch (nodeId.type()) {
                case PTR: {
                    return x;
                }
                case XSD_DOUBLE: {
                    x = DoubleNode62.insertType(x);
                    return x;
                }
            }
            x = BitsLong.pack(x, nodeId.getTypeValue(), 56, 62);
            x = BitsLong.set(x, 63);
            return x;
        }

        private void write(WriteRows out, NodeId nodeId) {
            long x = IngestData.encode(nodeId);
            out.write(x);
        }

        private void process(Node g, Node s, Node p, Node o) {
            NodeId sId = this.nodeTable.getAllocateNodeId(s);
            NodeId pId = this.nodeTable.getAllocateNodeId(p);
            NodeId oId = this.nodeTable.getAllocateNodeId(o);
            if (g != null) {
                NodeId gId = this.nodeTable.getAllocateNodeId(g);
                this.write(this.writerQuads, gId);
                this.write(this.writerQuads, sId);
                this.write(this.writerQuads, pId);
                this.write(this.writerQuads, oId);
                this.writerQuads.endOfRow();
                if (this.stats != null) {
                    this.stats.record(gId, sId, pId, oId);
                }
            } else {
                this.write(this.writerTriples, sId);
                this.write(this.writerTriples, pId);
                this.write(this.writerTriples, oId);
                this.writerTriples.endOfRow();
                if (this.stats != null) {
                    this.stats.record((Object)null, sId, pId, oId);
                }
            }
            this.monitor.tick();
        }

        public StatsCollectorNodeId getCollector() {
            return this.stats;
        }

        public long tripleCount() {
            return this.countTriples;
        }

        public long quadCount() {
            return this.countQuads;
        }

        @Override
        public void base(String base) {
        }

        @Override
        public void prefix(String prefix, String iri) {
            this.dsg.prefixes().add(prefix, iri);
        }
    }
}

