/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.TargetExtensions;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.validation.EvalSparql;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.system.G;

public class TargetOps {
    public static String strTargets(Collection<Target> targets, NodeFormatter nodeFmt) {
        if (targets.size() == 1) {
            return TargetOps.strTarget(CollectionUtils.oneElt(targets), nodeFmt);
        }
        StringJoiner sj = new StringJoiner(", ", "(", ")");
        targets.forEach(t -> sj.add(TargetOps.strTarget(t, nodeFmt)));
        return sj.toString();
    }

    public static String strTarget(Target target, NodeFormatter nodeFmt) {
        if (nodeFmt == null) {
            nodeFmt = ShLib.nodeFmtAbbrev;
        }
        switch (target.getTargetType()) {
            case implicitClass: {
                return "T/Impl [" + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
            case targetClass: {
                return "T/Class [?x rdf:type " + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
            case targetNode: {
                return "T/Node [?x = " + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
            case targetObjectsOf: {
                return "T/Obj [_ " + ShLib.displayStr(target.getObject(), nodeFmt) + " ?x]";
            }
            case targetSubjectsOf: {
                return "T/Subj [?x " + ShLib.displayStr(target.getObject(), nodeFmt) + " _]";
            }
            case targetExtension: {
                return "T/Ext [" + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
        }
        return "** Unknown **";
    }

    public static Set<Node> shapesTargetClass(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetClass, null).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> shapesTargetNode(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetNode, Node.ANY).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> shapesTargetObjectsOf(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetObjectsOf, Node.ANY).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> shapesTargetSubjectsOf(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetSubjectsOf, Node.ANY).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> implicitClassTargets(Graph shapesGraph) {
        Set<Node> allClasses = G.allNodesOfTypeRDFS(shapesGraph, C.rdfsClass);
        if (allClasses.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Node> nodeShapes = G.allNodesOfTypeRDFS(shapesGraph, SHACL.NodeShape);
        Set<Node> propertyShapes = G.allNodesOfTypeRDFS(shapesGraph, SHACL.PropertyShape);
        nodeShapes.retainAll(allClasses);
        propertyShapes.retainAll(allClasses);
        HashSet<Node> acc = new HashSet<Node>();
        acc.addAll(nodeShapes);
        acc.addAll(propertyShapes);
        return acc;
    }

    public static Set<Node> shapesTargetExtension(Graph shapesGraph) {
        HashSet x = new HashSet();
        return G.allPO(shapesGraph, SHACL.target, null);
    }

    private static Set<Node> shapesTargetSPARQL(Graph shapesGraph) {
        return G.find(shapesGraph, null, SHACL.target, null).filterKeep(t -> G.hasOneSP(shapesGraph, t.getObject(), SHACL.select)).mapWith(Triple::getSubject).toSet();
    }

    private static Set<Node> shapesSPARQLTargetType(Graph shapesGraph) {
        return G.find(shapesGraph, null, SHACL.target, null).filterKeep(t -> G.isOfType(shapesGraph, t.getObject(), SHACL.Target)).mapWith(Triple::getSubject).toSet();
    }

    public static Collection<Node> focusTargetClass(Graph data, Target target) {
        return G.allNodesOfTypeRDFS(data, target.getObject());
    }

    public static Collection<Node> focusImplicitClass(Graph data, Target target) {
        return TargetOps.focusTargetClass(data, target);
    }

    public static Collection<Node> focusTargetNode(Graph data, Target target) {
        return Collections.singletonList(target.getObject());
    }

    public static Collection<Node> focusSubjectsOf(Graph data, Target target) {
        return G.allPO(data, target.getObject(), null);
    }

    public static Collection<Node> focusObjectsOf(Graph data, Target target) {
        return G.allSP(data, null, target.getObject());
    }

    public static Collection<Node> focusTargetExt(Graph data, Target target) {
        Node targetArg;
        Graph shapesGraph = Objects.requireNonNull(target.getShapesGraph());
        if (G.hasOneSP(shapesGraph, targetArg = target.getObject(), SHACL.select)) {
            Query query = ShLib.extractSPARQLQuery(shapesGraph, targetArg);
            if (!query.isSelectType()) {
                throw new ShaclException("Not a SELECT query");
            }
            DatasetGraph dsg = DatasetGraphFactory.wrap(data);
            QueryExecution qExec = QueryExecutionFactory.create(query, dsg);
            return EvalSparql.evalSparqlOneVar(qExec);
        }
        List<Node> targetExt = G.typesOfNodeAsList(shapesGraph, targetArg);
        for (Node ext : targetExt) {
            Node type;
            if (!G.isOfType(shapesGraph, ext, SHACL.SPARQLTargetType)) continue;
            List<Node> types = G.typesOfNodeAsList(shapesGraph, targetArg);
            if (types.size() == 1) {
                type = CollectionUtils.oneElt(types);
            } else {
                Set<Node> allClasses = G.subClasses(shapesGraph, SHACL.Target);
                Optional<Node> x = types.stream().filter(t -> allClasses.contains(t)).findFirst();
                type = x.orElseThrow();
            }
            SparqlComponent sparqlComponent = TargetExtensions.sparqlTargetType(shapesGraph, type);
            return EvalSparql.evalSparqlComponent(data, target.getObject(), sparqlComponent);
        }
        throw new ShaclException("Unknown target extension");
    }
}

