/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.riot.protobuf.PBufRDF;
import org.apache.jena.riot.protobuf.Protobuf2StreamRDF;
import org.apache.jena.riot.protobuf.StreamRDF2Protobuf;
import org.apache.jena.riot.protobuf.wire.PB_RDF;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;

public class ProtobufRDF_Blk {
    public static void inputStreamBlkToStreamRDF(InputStream input, StreamRDF stream) {
        Protobuf2StreamRDF visitor = new Protobuf2StreamRDF(PrefixMapFactory.create(), stream);
        try {
            PB_RDF.RDF_Stream rdfStream2 = PB_RDF.RDF_Stream.parseFrom(input);
            stream.start();
            rdfStream2.getRowList().forEach(sr -> PBufRDF.visit(sr, visitor));
            stream.finish();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void streamToOutputStreamBlk(OutputStream outputStream, Consumer<StreamRDF> streamDest) {
        outputStream = IO.ensureBuffered(outputStream);
        try {
            StreamRDF2Protobuf.writeBlk(outputStream, streamDest, false);
        }
        finally {
            IO.flush(outputStream);
        }
    }
}

