/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIRemoveServerController
extends AbstractEMFStoreUIController<Void> {
    private final ServerInfo serverInfo;

    public UIRemoveServerController(Shell shell, ESServer server) {
        super(shell);
        this.serverInfo = (ServerInfo)((ESServerImpl)server).toInternalAPI();
    }

    @Override
    public Void doRun(IProgressMonitor monitor) throws ESException {
        boolean shouldDelete = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.UIRemoveServerController_Confirmation, (String)String.format(Messages.UIRemoveServerController_DeleteProject_Prompt, this.serverInfo.getName()));
        if (!shouldDelete) {
            return null;
        }
        Workspace workspace = ESWorkspaceProviderImpl.getInstance().getInternalWorkspace();
        workspace.getServerInfos().remove((Object)this.serverInfo);
        LinkedHashSet<Usersession> invalidSessions = new LinkedHashSet<Usersession>();
        for (Usersession session : ESWorkspaceProviderImpl.getInstance().getInternalWorkspace().getUsersessions()) {
            if (session.getServerInfo() != this.serverInfo) continue;
            invalidSessions.add(session);
        }
        workspace.getUsersessions().removeAll(invalidSessions);
        workspace.save();
        return null;
    }
}

