/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.log.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.fx.core.log.Condition;
import org.eclipse.fx.core.log.FluentLogContext;
import org.eclipse.fx.core.log.FluentLogger;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.jdt.annotation.NonNull;

public class FluentLoggerImpl
implements FluentLogger {
    private final @NonNull Logger logger;
    private static final FluentLogContext NO_LOG = new NoOpLogContextImpl();

    public FluentLoggerImpl(@NonNull Logger logger) {
        this.logger = logger;
    }

    @Override
    public FluentLogContext at(@NonNull Logger.Level level) {
        if (this.logger.isEnabled(level)) {
            return new FluentLogContextImpl(level, this.logger);
        }
        return NO_LOG;
    }

    static class FluentLogContextImpl
    implements FluentLogContext {
        private final @NonNull Logger logger;
        private final @NonNull Logger.Level level;
        private Throwable t;
        private List<Predicate<FluentLogContext.MutableState>> whenList;
        private final MutableStateImpl state;
        private static final @NonNull String FQN = FluentLogContextImpl.class.getCanonicalName();

        public FluentLogContextImpl(@NonNull Logger.Level level, @NonNull Logger logger) {
            this.level = level;
            this.logger = logger;
            this.state = new MutableStateImpl();
        }

        @Override
        public FluentLogContext when(Predicate<FluentLogContext.MutableState> t) {
            if (this.whenList == null) {
                this.whenList = new CopyOnWriteArrayList<Predicate<FluentLogContext.MutableState>>();
            }
            this.whenList.add(t);
            return this;
        }

        @Override
        public <T extends Condition> T with(Function<FluentLogContext, T> condition) {
            return (T)((Condition)condition.apply(this));
        }

        private boolean shouldLog() {
            boolean rv;
            this.state.incrementCallCount();
            if (this.whenList == null) {
                return true;
            }
            boolean bl = this.whenList == null ? true : (rv = this.whenList.stream().mapToInt(w -> w.test(this.state) ? 1 : 0).sum() == this.whenList.size());
            if (rv) {
                this.state.recordLastLog();
            }
            return rv;
        }

        @Override
        public void log(CharSequence message) {
            if (this.shouldLog()) {
                Throwable t = this.t;
                if (t == null) {
                    this.logger.log(FQN, this.level, message);
                } else {
                    this.logger.log(FQN, this.level, message, t);
                }
            }
        }

        @Override
        public void log(@NonNull String message, Object ... arguments) {
            if (this.shouldLog()) {
                Throwable t = this.t;
                if (t == null) {
                    this.logger.logf(FQN, this.level, message, arguments);
                } else {
                    this.logger.logf(FQN, this.level, message, t, arguments);
                }
            }
        }

        @Override
        public void log(@NonNull Supplier<@NonNull CharSequence> messageSupplier) {
            this.log(messageSupplier.get());
        }

        @Override
        public <T> void log(@NonNull Function<T, @NonNull CharSequence> messageSupplier, T type) {
            this.log(messageSupplier.apply(type));
        }

        @Override
        public FluentLogContext withException(Throwable t) {
            this.t = t;
            return this;
        }
    }

    public static class MutableStateImpl
    implements FluentLogContext.MutableState {
        private AtomicLong callCount = new AtomicLong();
        private AtomicLong lastLogCount = new AtomicLong();
        private AtomicLong lastLogTime = new AtomicLong();

        public long incrementCallCount() {
            return this.callCount.incrementAndGet();
        }

        @Override
        public long currentCallCount() {
            return this.callCount.get();
        }

        public void recordLastLog() {
            this.lastLogTime.set(System.nanoTime());
            this.lastLogCount.set(this.currentCallCount());
        }

        @Override
        public long lastLogCount() {
            return this.lastLogCount.get();
        }

        @Override
        public long lastLogTime() {
            return this.lastLogTime.get();
        }
    }

    static class NoOpLogContextImpl
    implements FluentLogContext {
        NoOpLogContextImpl() {
        }

        @Override
        public <T> void log(@NonNull Function<T, @NonNull CharSequence> messageSupplier, T type) {
        }

        @Override
        public void log(@NonNull Supplier<@NonNull CharSequence> messageSupplier) {
        }

        @Override
        public void log(CharSequence message) {
        }

        @Override
        public void log(String message, Object ... arguments) {
        }

        @Override
        public FluentLogContext withException(Throwable t) {
            return this;
        }

        @Override
        public FluentLogContext when(Predicate<FluentLogContext.MutableState> t) {
            return this;
        }

        @Override
        public <T extends Condition> T with(Function<FluentLogContext, T> condition) {
            return (T)((Condition)condition.apply(this));
        }
    }
}

