/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindowElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.controls.stage.Frame;
import org.eclipse.fx.ui.controls.stage.TrimmedWindow;
import org.eclipse.fx.ui.controls.stage.Window;
import org.eclipse.fx.ui.di.InjectingFXMLLoader;
import org.eclipse.fx.ui.panes.FillLayoutPane;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.fx.key.KeyBindingDispatcher;
import org.eclipse.fx.ui.workbench.renderers.base.BaseWindowRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.services.MaximizationTransitionService;
import org.eclipse.fx.ui.workbench.renderers.base.services.WindowTransitionService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWindow;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.DefaultSaveDialogPresenter;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.Messages;
import org.eclipse.fx.ui.workbench.renderers.fx.services.LightweightDialogTransitionService;
import org.eclipse.fx.ui.workbench.renderers.fx.services.SaveDialogPresenter;
import org.eclipse.fx.ui.workbench.renderers.fx.services.SaveDialogPresenterTypeProvider;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.Bundle;

public class DefWindowRenderer
extends BaseWindowRenderer<Stage> {
    private static final String CSS_TRIM_CONTAINER = "window-trim-container";
    private static final String CSS_CONTENT_CONTAINER = "window-content-container";
    private static final String ID_CLIENT_AREA = "client-area";
    private static final String ID_MENU_BAR_AREA = "menu-bar-area";
    private static final String ID_TOP_TRIM_AREA = "top-trim-area";
    private static final String ID_BOTTOM_TRIM_AREA = "bottom-trim-area";
    private static final String ID_LEFT_TRIM_AREA = "left-trim-area";
    private static final String ID_RIGHT_TRIM_AREA = "right-trim-area";
    private static final String TAG_LIGHTWEIGHT_DIALOGS = "efx-lightweight-dialogs";
    private static final String TAG_CENTER_ON_SCREEN = "efx-center-on-screen";
    @Inject
    @Translation
    @NonNull Messages messages;
    @Inject
    @Optional
    SaveDialogPresenterTypeProvider presenterTypeProvider;

    protected @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ISaveHandler.Save> promptToSave(@NonNull MWindow element, @NonNull Collection<MPart> dirtyParts, @NonNull WWindow<Stage> widget) {
        Object[] response = new ISaveHandler.Save[dirtyParts.size()];
        IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        if (modelContext == null) {
            this.getLogger().error("Model context should not be null at this point");
            Arrays.fill(response, ISaveHandler.Save.CANCEL);
            return Arrays.asList(response);
        }
        SaveDialogPresenter presenter = this.presenterTypeProvider == null ? (SaveDialogPresenter)ContextInjectionFactory.make(DefaultSaveDialogPresenter.class, (IEclipseContext)modelContext) : (SaveDialogPresenter)ContextInjectionFactory.make(this.presenterTypeProvider.getType(), (IEclipseContext)modelContext);
        return presenter.promptToSave(new SaveDialogPresenter.SaveData(element.getTags().contains(TAG_LIGHTWEIGHT_DIALOGS), dirtyParts, widget, (javafx.stage.Window)((Stage)widget.getWidget())));
    }

    protected ISaveHandler.Save promptToSave(MWindow element, MPart dirtyPart, WWindow<Stage> widget) {
        IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        if (modelContext == null) {
            this.getLogger().error("Model context should not be null at this point");
            return ISaveHandler.Save.CANCEL;
        }
        SaveDialogPresenter presenter = this.presenterTypeProvider == null ? (SaveDialogPresenter)ContextInjectionFactory.make(DefaultSaveDialogPresenter.class, (IEclipseContext)modelContext) : (SaveDialogPresenter)ContextInjectionFactory.make(this.presenterTypeProvider.getType(), (IEclipseContext)modelContext);
        List<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ISaveHandler.Save> promptToSave = presenter.promptToSave(new SaveDialogPresenter.SaveData(element.getTags().contains(TAG_LIGHTWEIGHT_DIALOGS), Collections.singletonList(dirtyPart), widget, (javafx.stage.Window)((Stage)widget.getWidget())));
        return promptToSave.isEmpty() ? ISaveHandler.Save.CANCEL : promptToSave.get(0);
    }

    protected Class<? extends WWindow<Stage>> getWidgetClass(MWindow window) {
        return WWindowImpl.class;
    }

    public static class WWindowImpl
    extends WLayoutedWidgetImpl<Stage, Pane, MWindow>
    implements WWindow<Stage> {
        private boolean support3d;
        private Pane rootPane;
        private BorderPane trimPane;
        private FillLayoutPane contentPane;
        private KeyBindingDispatcher dispatcher;
        private BorderPane decoratorPane;
        WindowResizeButton windowResizeButton;
        Stage stage;
        @Inject
        @Optional
        ThemeManager themeManager;
        private ThemeManager.Registration sceneRegistration;
        private String decorationFXML;
        private String rootFXML;
        private boolean fullscreen;
        IEclipseContext modelContext;
        @NonNull MWindow mWindow;
        @Inject
        TranslationService translationService;
        @Inject
        @NonNull BundleLocalization localizationService;
        @Inject
        @Optional
        WindowTransitionService<Stage> windowTransitionService;
        @Inject
        @Optional
        LightweightDialogTransitionService dialogTransitionService;
        @Inject
        private GraphicsLoader graphicsLoader;
        @Inject
        private IEventBroker eventBroker;
        boolean initDone;
        private boolean undecorated;
        private StageStyle stageStyle;
        IEclipseContext applicationContext;
        private List<WWindow<?>> windows = new ArrayList();
        WCallback<WWindow<Stage>, Boolean> onCloseCallback;
        private boolean maximizedShell;
        List<WWidget<?>> lastActivationTree = new ArrayList();
        List<WWidget<?>> queuedTree = new ArrayList();
        private static final String KEY_SCENE_3D_DEPRECATED = "fx.scene.3d";
        private static final String KEY_SCENE_3D = "efx.window.scene.3d";
        private static final String KEY_STAGE_DECORATION_DEPRECATED = "fx.stage.decoration";
        private static final String KEY_STAGE_DECORATION = "efx.window.decoration.fxml";
        private static final String KEY_STAGE_STYLE = "efx.window.stagestyle";
        private static final String KEY_STAGE_MODALITY = "efx.window.stagemodality";
        private static final String KEY_STAGE_UNDECORATED_DEPRECATED = "efx.window.undecorated";
        private static final String KEY_STAGE_ROOT_CONTENT = "efx.window.root.fxml";
        private StackPane overlayContainer;
        private FillLayoutPane greyPane;
        private FillLayoutPane maximizationContainer;
        private WLayoutedWidget<? extends MUIElement> maximizedWidget;
        @Inject
        @Optional
        private MaximizationTransitionService<Pane, Region> maximizationTransition;

        @Inject
        public WWindowImpl(@Named(value="fx.rendering.domElement") @NonNull MWindow mWindow, @Optional KeyBindingDispatcher dispatcher, MApplication application, @Log Logger logger) {
            this.mWindow = mWindow;
            this.applicationContext = application.getContext();
            if (mWindow.getPersistedState().get(KEY_SCENE_3D_DEPRECATED) != null) {
                logger.warning("Usage of deprecated persisted state 'fx.scene.3d' please use 'efx.window.scene.3d' instead.");
                this.support3d = Boolean.parseBoolean((String)mWindow.getPersistedState().get(KEY_SCENE_3D_DEPRECATED));
            } else {
                this.support3d = Boolean.parseBoolean((String)mWindow.getPersistedState().get(KEY_SCENE_3D));
            }
            this.dispatcher = dispatcher;
            this.modelContext = mWindow.getContext();
            this.decorationFXML = (String)mWindow.getPersistedState().get(KEY_STAGE_DECORATION_DEPRECATED);
            if (this.decorationFXML == null) {
                this.decorationFXML = (String)mWindow.getPersistedState().get(KEY_STAGE_DECORATION);
            } else {
                logger.warning("Useage of deprecated persisted state 'fx.stage.decoration' please use 'efx.window.decoration.fxml' instead.");
            }
            if (mWindow.getPersistedState().get(KEY_STAGE_STYLE) != null) {
                this.stageStyle = StageStyle.valueOf((String)((String)mWindow.getPersistedState().get(KEY_STAGE_STYLE)));
            } else if (mWindow.getPersistedState().get(KEY_STAGE_UNDECORATED_DEPRECATED) != null) {
                logger.warning("Usage of deprecated persisted state 'efx.window.undecorated' please use 'efx.window.stagestyle'");
                this.undecorated = Boolean.parseBoolean((String)mWindow.getPersistedState().get(KEY_STAGE_UNDECORATED_DEPRECATED));
            }
            this.rootFXML = (String)mWindow.getPersistedState().get(KEY_STAGE_ROOT_CONTENT);
            if (this.decorationFXML != null && this.rootFXML != null) {
                logger.warning("You've specified a decorationXML and a rootFXML. Only rootFXML is used");
            }
        }

        @Override
        @PostConstruct
        protected void init() {
            this.initDone = true;
            super.init();
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            this.sceneRegistration.dispose();
        }

        private static MWindow findParent(EObject tmp) {
            EObject e = tmp;
            if (e.eContainer() instanceof MApplication) {
                return null;
            }
            do {
                if (!((e = e.eContainer()) instanceof MWindow)) continue;
                return (MWindow)e;
            } while (e.eContainer() != null);
            return null;
        }

        public void setDialog(Object dialogNode) {
            @NonNull Pane staticLayoutNode = (Pane)this.getStaticLayoutNode();
            if (dialogNode == null) {
                if (this.overlayContainer != null) {
                    if (this.dialogTransitionService != null) {
                        this.dialogTransitionService.hideDialog((MUIElement)this.mWindow, staticLayoutNode, (Pane)this.overlayContainer, (Node)this.overlayContainer, this.overlayContainer.getChildren().size() == 1 ? (Node)this.overlayContainer.getChildren().get(0) : null, () -> {
                            staticLayoutNode.getChildren().remove((Object)this.overlayContainer);
                            this.overlayContainer.getChildren().clear();
                        });
                    } else {
                        staticLayoutNode.getChildren().remove((Object)this.overlayContainer);
                        this.overlayContainer.getChildren().clear();
                    }
                }
            } else {
                if (this.overlayContainer == null) {
                    this.overlayContainer = new StackPane(){

                        protected void layoutChildren() {
                            Insets insets = this.getInsets();
                            double w = this.getWidth() - insets.getLeft() - insets.getRight();
                            double h = this.getHeight() - insets.getTop() - insets.getBottom();
                            for (Node n : this.getManagedChildren()) {
                                double y;
                                double x;
                                n.autosize();
                                if (n instanceof Region) {
                                    x = w / 2.0 - Math.min(w, ((Region)n).getWidth()) / 2.0;
                                    y = h / 2.0 - Math.min(h, ((Region)n).getHeight()) / 2.0;
                                } else {
                                    x = w / 2.0 - Math.min(w, n.prefWidth(-1.0)) / 2.0;
                                    y = h / 2.0 - Math.min(h, n.prefHeight(-1.0)) / 2.0;
                                }
                                n.relocate(x, y);
                            }
                        }
                    };
                    this.overlayContainer.getStyleClass().add((Object)"overlay-container");
                    this.overlayContainer.setManaged(false);
                    this.overlayContainer.setMouseTransparent(false);
                    staticLayoutNode.layoutBoundsProperty().addListener(o -> {
                        staticLayoutNode.layoutBoundsProperty().get();
                        this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                    });
                }
                this.overlayContainer.resize(staticLayoutNode.getWidth(), staticLayoutNode.getHeight());
                this.overlayContainer.getChildren().setAll((Object[])new Node[]{(Node)dialogNode});
                this.overlayContainer.layout();
                staticLayoutNode.getChildren().add((Object)this.overlayContainer);
                if (this.dialogTransitionService != null) {
                    this.dialogTransitionService.showDialog((MUIElement)this.mWindow, staticLayoutNode, (Pane)this.overlayContainer, (Node)this.overlayContainer, (Node)dialogNode, null);
                }
            }
        }

        @Override
        protected Stage createWidget() {
            URL url;
            Scene s;
            Stage stage;
            this.stage = stage = new Stage();
            this.modelContext.set("localActiveShell", (Object)stage);
            MWindow parent = WWindowImpl.findParent((EObject)this.mWindow);
            if (parent != null) {
                this.stage.initOwner((javafx.stage.Window)((WWindow)parent.getWidget()).getWidget());
            }
            this.stage.setOnCloseRequest(this::handleOnCloseRequest);
            this.stage.focusedProperty().addListener(this::handledFocus);
            this.stage.setFullScreen(this.fullscreen);
            this.stage.maximizedProperty().addListener(o -> {
                if (this.stage.isMaximized()) {
                    this.mWindow.getTags().add("shellMaximized");
                } else {
                    this.mWindow.getTags().remove("shellMaximized");
                }
            });
            if (this.mWindow.getPersistedState().containsKey(KEY_STAGE_MODALITY)) {
                this.stage.initModality(Modality.valueOf((String)((String)this.mWindow.getPersistedState().get(KEY_STAGE_MODALITY))));
            }
            this.stage.fullScreenProperty().addListener(this::handleFullscreen);
            if (this.dispatcher != null) {
                this.stage.addEventFilter(KeyEvent.KEY_PRESSED, this.dispatcher.getKeyHandler());
            }
            this.trimPane = new BorderPane();
            this.trimPane.getStyleClass().add((Object)DefWindowRenderer.CSS_TRIM_CONTAINER);
            this.contentPane = new FillLayoutPane();
            this.contentPane.getStyleClass().add((Object)DefWindowRenderer.CSS_CONTENT_CONTAINER);
            this.trimPane.setCenter((Node)new StackPane(new Node[]{this.contentPane}));
            if (this.rootFXML != null) {
                this.rootPane = this.createRootContainer(stage);
                if (this.rootPane != null) {
                    if (this.rootPane instanceof Frame) {
                        ((Frame)this.rootPane).setClientArea((Node)this.trimPane);
                    } else if (this.rootPane instanceof BorderPane) {
                        Node clientArea = this.rootPane.lookup("#client-area");
                        if (clientArea != null) {
                            this.addNodeToCustomParent(java.util.Optional.ofNullable(this.trimPane), clientArea, DefWindowRenderer.ID_CLIENT_AREA);
                        } else {
                            ((BorderPane)this.rootPane).setCenter((Node)this.trimPane);
                        }
                    } else {
                        this.logger.warning("Unhandled type of root pane: " + this.rootPane.getClass().getName());
                    }
                }
            }
            if (this.rootPane == null) {
                BorderPane rootPane = new BorderPane(){

                    protected void layoutChildren() {
                        super.layoutChildren();
                        if (windowResizeButton != null) {
                            windowResizeButton.autosize();
                            windowResizeButton.setLayoutX(this.getWidth() - windowResizeButton.getLayoutBounds().getWidth());
                            windowResizeButton.setLayoutY(this.getHeight() - windowResizeButton.getLayoutBounds().getHeight());
                        }
                    }
                };
                this.rootPane = rootPane;
                rootPane.setCenter((Node)this.trimPane);
                if (this.decorationFXML != null) {
                    this.windowResizeButton = new WindowResizeButton(this.stage, 50.0, 50.0);
                    this.decoratorPane = new BorderPane();
                    this.decoratorPane.setTop(this.createTopDecoration(this.stage));
                    rootPane.setTop((Node)this.decoratorPane);
                }
            }
            if (this.stageStyle != null) {
                this.stage.initStyle(this.stageStyle);
            } else if (this.undecorated) {
                this.stage.initStyle(StageStyle.UNDECORATED);
            }
            if (this.support3d && Platform.isSupported((ConditionalFeature)ConditionalFeature.SCENE3D)) {
                s = new Scene((Parent)this.rootPane, (double)this.mWindow.getWidth(), (double)this.mWindow.getHeight(), true);
                s.setCamera((Camera)new PerspectiveCamera());
            } else {
                s = new Scene((Parent)this.rootPane, (double)this.mWindow.getWidth(), (double)this.mWindow.getHeight());
            }
            if (!Util.isMacOS() && org.eclipse.fx.ui.controls.Util.MNEMONICS_FIX) {
                s.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
                    if (e.isAltDown() && e.isControlDown()) {
                        e.consume();
                    } else if (e.isAltDown() && e.getCode() == KeyCode.TAB) {
                        e.consume();
                    }
                });
            }
            if (this.stage.getStyle() == StageStyle.TRANSPARENT) {
                s.setFill((Paint)Color.TRANSPARENT);
            }
            if ((url = WWindowImpl.class.getClassLoader().getResource("css/efx-default.css")) != null) {
                s.getStylesheets().add((Object)url.toExternalForm());
            } else {
                this.logger.error("Unable to load css 'css/efx-default.css'");
            }
            s.focusOwnerProperty().addListener(this::handleFocusOwner);
            if (this.themeManager != null) {
                this.sceneRegistration = this.themeManager.registerScene(s);
            }
            if (this.windowResizeButton != null) {
                this.rootPane.getChildren().add((Object)this.windowResizeButton);
            }
            this.stage.setScene(s);
            this.modelContext.set(Stage.class, (Object)this.stage);
            this.modelContext.set(Scene.class, (Object)s);
            return stage;
        }

        private void handleOnCloseRequest(WindowEvent event) {
            if (this.onCloseCallback != null && !Boolean.TRUE.equals(this.onCloseCallback.call((Object)this))) {
                event.consume();
            }
        }

        @Override
        public @NonNull Node getStaticLayoutNode() {
            return this.rootPane;
        }

        private void handleFullscreen(ObservableValue<? extends Boolean> obs, Boolean oldValue, Boolean newValue) {
            this.mWindow.getPersistedState().put("efx.window.fullscreen", newValue.toString());
        }

        private void handledFocus(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                this.activateWindow();
            } else {
                this.deactivate();
            }
        }

        private void activateWindow() {
            if (this.stage.getScene() != null) {
                this.applicationContext.set("efx_APP_FOCUS_NODE", (Object)this.stage.getScene().getFocusOwner());
            }
            if (!this.isActive()) {
                this.activate();
                this.eventBroker.send("org/eclipse/fx/MWindow/Activated", this.getDomElement());
            }
        }

        @Override
        public void activate() {
            super.activate();
            if (this.stage != null && !this.stage.isFocused()) {
                this.stage.requestFocus();
            }
        }

        private void handleFocusOwner(ObservableValue<? extends Node> observable, Node oldValue, Node _newValue) {
            Node newValue = _newValue;
            this.modelContext.set("efx_WINDOW_FOCUS_NODE", (Object)newValue);
            if (this.stage.isFocused()) {
                this.applicationContext.set("efx_APP_FOCUS_NODE", (Object)newValue);
            }
            if (newValue != null) {
                final ArrayList activationTree = new ArrayList();
                do {
                    if (!(newValue.getUserData() instanceof WWidget)) continue;
                    activationTree.add((WWidget)newValue.getUserData());
                } while ((newValue = newValue.getParent()) != null);
                if (!this.lastActivationTree.equals(activationTree)) {
                    final ArrayList oldTreeReversed = new ArrayList(this.lastActivationTree);
                    final ArrayList newTreeReversed = new ArrayList(activationTree);
                    Collections.reverse(oldTreeReversed);
                    Collections.reverse(newTreeReversed);
                    Iterator it = newTreeReversed.iterator();
                    while (it.hasNext()) {
                        if (oldTreeReversed.isEmpty() || oldTreeReversed.get(0) != it.next()) break;
                        oldTreeReversed.remove(0);
                        it.remove();
                    }
                    Collections.reverse(oldTreeReversed);
                    Collections.reverse(newTreeReversed);
                    this.queuedTree = activationTree;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (queuedTree == activationTree) {
                                lastActivationTree = activationTree;
                                for (WWidget w : oldTreeReversed) {
                                    w.deactivate();
                                }
                                for (WWidget w : newTreeReversed) {
                                    w.activate();
                                }
                            }
                        }
                    });
                }
            }
        }

        private Pane createRootContainer(Stage stage) {
            URI uri = URI.createURI((String)this.rootFXML);
            if (uri != null) {
                stage.initStyle(StageStyle.UNDECORATED);
                Bundle b = org.eclipse.core.runtime.Platform.getBundle((String)uri.segment(1));
                if (b != null) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        int i = 2;
                        while (i < uri.segmentCount()) {
                            if (sb.length() != 0) {
                                sb.append("/");
                            }
                            sb.append(uri.segment(i));
                            ++i;
                        }
                        InjectingFXMLLoader loader = InjectingFXMLLoader.create((IEclipseContext)this.modelContext, (Bundle)b, (String)sb.toString());
                        ResourceBundle resourceBundle = this.localizationService.getLocalization(b, Locale.getDefault().toString());
                        if (resourceBundle != null) {
                            loader.resourceBundle(resourceBundle);
                        }
                        Pane load = (Pane)loader.load();
                        ContextInjectionFactory.inject((Object)load, (IEclipseContext)this.modelContext);
                        return load;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        private Node createTopDecoration(Stage stage) {
            URI uri = URI.createURI((String)this.decorationFXML);
            if (uri != null) {
                stage.initStyle(StageStyle.UNDECORATED);
                Bundle b = org.eclipse.core.runtime.Platform.getBundle((String)uri.segment(1));
                if (b != null) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        int i = 2;
                        while (i < uri.segmentCount()) {
                            if (sb.length() != 0) {
                                sb.append("/");
                            }
                            sb.append(uri.segment(i));
                            ++i;
                        }
                        InjectingFXMLLoader loader = InjectingFXMLLoader.create((IEclipseContext)this.modelContext, (Bundle)b, (String)sb.toString());
                        ResourceBundle resourceBundle = this.localizationService.getLocalization(b, Locale.getDefault().toString());
                        if (resourceBundle != null) {
                            loader.resourceBundle(resourceBundle);
                        }
                        return (Node)loader.load();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }

        @Override
        protected void bindProperties(Stage widget) {
            super.bindProperties(widget);
            this.bindProperty("x", (ObservableValue<Object>)widget.xProperty());
            this.bindProperty("y", (ObservableValue<Object>)widget.yProperty());
            this.bindProperty("width", (ObservableValue<Object>)widget.widthProperty());
            this.bindProperty("height", (ObservableValue<Object>)widget.heightProperty());
        }

        public void setMainMenu(WLayoutedWidget<MMenu> menuWidget) {
            Node node = WWindowImpl.getStaticLayoutNodeOrNull(menuWidget);
            if (this.decoratorPane == null) {
                if (this.rootPane instanceof Window) {
                    ((Window)this.rootPane).setMenuBar(node);
                } else {
                    Node menuBarArea = this.rootPane.lookup("#menu-bar-area");
                    if (menuBarArea != null) {
                        this.addNodeToCustomParent(java.util.Optional.ofNullable(node), menuBarArea, DefWindowRenderer.ID_MENU_BAR_AREA);
                    } else {
                        ((BorderPane)this.rootPane).setTop(node);
                    }
                }
            } else {
                this.decoratorPane.setBottom(node);
            }
        }

        private void addNodeToCustomParent(java.util.Optional<Node> optionalNode, Node customParent, String id) {
            if (customParent instanceof BorderPane) {
                if (id.equals(DefWindowRenderer.ID_MENU_BAR_AREA)) {
                    ((BorderPane)customParent).setTop((Node)optionalNode.orElse(null));
                } else {
                    ((BorderPane)customParent).setCenter((Node)optionalNode.orElse(null));
                }
            } else if (customParent instanceof Pane) {
                if (optionalNode.isPresent()) {
                    Node node = optionalNode.get();
                    ((Pane)customParent).getChildren().add(0, (Object)node);
                    if (customParent instanceof HBox) {
                        HBox.setHgrow((Node)node, (Priority)Priority.ALWAYS);
                    } else if (customParent instanceof HBox) {
                        VBox.setVgrow((Node)node, (Priority)Priority.ALWAYS);
                    } else if (customParent instanceof AnchorPane) {
                        AnchorPane.setTopAnchor((Node)node, (Double)new Double(0.0));
                        AnchorPane.setRightAnchor((Node)node, (Double)new Double(0.0));
                        AnchorPane.setBottomAnchor((Node)node, (Double)new Double(0.0));
                        AnchorPane.setLeftAnchor((Node)node, (Double)new Double(0.0));
                    }
                } else {
                    ((Pane)customParent).getChildren().remove(0);
                }
            } else {
                this.logger.error("Could not add child to customParent: Expecting BorderPane or Pane");
            }
        }

        @Override
        public Pane getWidgetNode() {
            return this.rootPane;
        }

        public void setOnCloseCallback(WCallback<WWindow<Stage>, Boolean> onCloseCallback) {
            this.onCloseCallback = onCloseCallback;
        }

        @Inject
        public void setX(@Named(value="x") int _x) {
            if (!this.isPropertyChangeInProgress("x")) {
                int x = _x;
                if (x == Integer.MIN_VALUE) {
                    x = 0;
                }
                ((Stage)this.getWidget()).setX((double)x);
            }
        }

        @Inject
        public void setY(@Named(value="y") int _y) {
            if (!this.isPropertyChangeInProgress("y")) {
                int y = _y;
                if (y == Integer.MIN_VALUE) {
                    y = 0;
                }
                ((Stage)this.getWidget()).setY((double)y);
            }
        }

        @Inject
        public void setWidth(@Named(value="width") int w) {
            if (!this.isPropertyChangeInProgress("width")) {
                Stage widget = (Stage)this.getWidget();
                double cw = Util.unsignedConstraintValue((double)w, (double)this.rootPane.getMinWidth(), (double)this.rootPane.getMaxWidth());
                widget.setWidth(cw);
            }
        }

        @Inject
        public void setHeight(@Named(value="height") int h) {
            if (!this.isPropertyChangeInProgress("height")) {
                Stage widget = (Stage)this.getWidget();
                double ch = Util.unsignedConstraintValue((double)h, (double)this.rootPane.getMinHeight(), (double)this.rootPane.getMaxHeight());
                widget.setHeight(ch);
            }
        }

        @Inject
        public void setVisible(@Named(value="visible") boolean visible) {
            if (!this.initDone) {
                return;
            }
            if (visible) {
                this.internalShow();
            } else {
                this.internalHide();
            }
        }

        @Inject
        public void setTags(@Optional @Named(value="tags") List<String> tags) {
            if (tags != null) {
                this.maximizedShell = tags.contains("shellMaximized");
                if (this.stage != null) {
                    this.stage.setMaximized(this.maximizedShell);
                }
            }
        }

        @Inject
        public void setFullscreen(@Named(value="persistedState_efx.window.fullscreen") @Optional String fullScreen) {
            if (fullScreen != null) {
                this.fullscreen = Boolean.parseBoolean(fullScreen);
                if (this.stage != null) {
                    this.stage.setFullScreen(this.fullscreen);
                }
            } else {
                this.fullscreen = false;
            }
        }

        @Override
        public void addStyleClasses(List<String> classnames) {
            this.rootPane.getStyleClass().addAll(classnames);
        }

        @Override
        public void setStyleId(String id) {
            this.rootPane.setId(id);
        }

        public void show() {
            this.internalShow();
            ((Stage)this.getWidget()).toFront();
        }

        public void close() {
            if (this.rootPane instanceof Frame) {
                ((Frame)this.rootPane).close();
            } else {
                ((Stage)this.getWidget()).close();
            }
        }

        public void addChildWindow(WWindow<?> widget) {
            this.windows.add(widget);
            if (this.initDone && this.stage.isShowing()) {
                Stage s = (Stage)widget.getWidget();
                s.show();
            }
        }

        public void removeChildWindow(@NonNull WWindow<?> widget) {
            Stage s = (Stage)widget.getWidget();
            s.hide();
            this.windows.remove(widget);
        }

        private void internalShow() {
            if (((Stage)this.getWidget()).isShowing()) {
                return;
            }
            if (this.mWindow.getTags().contains(DefWindowRenderer.TAG_CENTER_ON_SCREEN)) {
                ((Stage)this.getWidget()).centerOnScreen();
            }
            if (this.windowTransitionService != null) {
                WindowTransitionService.AnimationDelegate delegate = this.windowTransitionService.getShowDelegate(this.mWindow);
                if (delegate != null) {
                    delegate.animate((Object)((Stage)this.getWidget()), () -> {
                        this.activateWindow();
                        Platform.runLater(() -> this.stage.setMaximized(this.maximizedShell));
                        this.eventBroker.send("org/eclipse/fx/MWindow/Shown", (Object)this.mWindow);
                    });
                } else {
                    ((Stage)this.getWidget()).show();
                    this.activateWindow();
                    Platform.runLater(() -> this.stage.setMaximized(this.maximizedShell));
                    this.eventBroker.send("org/eclipse/fx/MWindow/Shown", (Object)this.mWindow);
                }
            } else {
                ((Stage)this.getWidget()).show();
                this.activateWindow();
                Platform.runLater(() -> this.stage.setMaximized(this.maximizedShell));
                this.eventBroker.send("org/eclipse/fx/MWindow/Shown", (Object)this.mWindow);
            }
            for (WWindow<?> c : this.windows) {
                c.show();
                this.eventBroker.send("org/eclipse/fx/MWindow/Shown", (Object)this.mWindow);
            }
            if (this.windows.size() > 0) {
                this.stage.requestFocus();
                this.activateWindow();
            }
        }

        private void internalHide() {
            if (this.windowTransitionService != null) {
                WindowTransitionService.AnimationDelegate delegate = this.windowTransitionService.getShowDelegate(this.mWindow);
                if (delegate != null) {
                    delegate.animate((Object)((Stage)this.getWidget()), () -> this.eventBroker.send("org/eclipse/fx/MWindow/Hidden", (Object)this.mWindow));
                } else {
                    ((Stage)this.getWidget()).hide();
                    this.eventBroker.send("org/eclipse/fx/MWindow/Hidden", (Object)this.mWindow);
                }
            } else {
                ((Stage)this.getWidget()).hide();
                this.eventBroker.send("org/eclipse/fx/MWindow/Hidden", (Object)this.mWindow);
            }
        }

        @Inject
        public void setTitle(@Named(value="localizedLabel") String title) {
            ((Stage)this.getWidget()).setTitle(title);
            if (this.rootPane instanceof Window) {
                ((Window)this.rootPane).setTitle(title);
            }
        }

        @Inject
        public void setImageUrl(@Named(value="iconURI") @Optional String iconUri) {
            if (!Strings.isNullOrEmpty((String)iconUri)) {
                String[] split = iconUri.split(";");
                ArrayList<Image> images = new ArrayList<Image>();
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String uri = stringArray[n2];
                    Image img = this.graphicsLoader.getImage((org.eclipse.fx.core.URI)new EMFUri(URI.createURI((String)uri)));
                    if (img != null) {
                        images.add(img);
                    }
                    ++n2;
                }
                ((Stage)this.getWidget()).getIcons().setAll(images);
            } else {
                ((Stage)this.getWidget()).getIcons().clear();
            }
        }

        public void setBottomTrim(WLayoutedWidget<MTrimBar> trimBar) {
            Node node = WWindowImpl.getStaticLayoutNodeOrNull(trimBar);
            if (this.rootPane instanceof TrimmedWindow) {
                ((TrimmedWindow)this.rootPane).setBottomTrim(node);
            } else {
                Node area = this.rootPane.lookup("#bottom-trim-area");
                if (area != null) {
                    this.addNodeToCustomParent(java.util.Optional.ofNullable(node), area, DefWindowRenderer.ID_BOTTOM_TRIM_AREA);
                } else {
                    this.trimPane.setBottom(node);
                }
            }
        }

        public void setLeftTrim(WLayoutedWidget<MTrimBar> trimBar) {
            Node node = WWindowImpl.getStaticLayoutNodeOrNull(trimBar);
            if (this.rootPane instanceof TrimmedWindow) {
                ((TrimmedWindow)this.rootPane).setLeftTrim(node);
            } else {
                Node area = this.rootPane.lookup("#left-trim-area");
                if (area != null) {
                    this.addNodeToCustomParent(java.util.Optional.ofNullable(node), area, DefWindowRenderer.ID_LEFT_TRIM_AREA);
                } else {
                    this.trimPane.setLeft(node);
                }
            }
        }

        public void setRightTrim(WLayoutedWidget<MTrimBar> trimBar) {
            Node node = WWindowImpl.getStaticLayoutNodeOrNull(trimBar);
            if (this.rootPane instanceof TrimmedWindow) {
                ((TrimmedWindow)this.rootPane).setRightTrim(node);
            } else {
                Node area = this.rootPane.lookup("#right-trim-area");
                if (area != null) {
                    this.addNodeToCustomParent(java.util.Optional.ofNullable(node), area, DefWindowRenderer.ID_RIGHT_TRIM_AREA);
                } else {
                    this.trimPane.setRight(node);
                }
            }
        }

        public void setTopTrim(WLayoutedWidget<MTrimBar> trimBar) {
            Node node = WWindowImpl.getStaticLayoutNodeOrNull(trimBar);
            if (this.rootPane instanceof TrimmedWindow) {
                ((TrimmedWindow)this.rootPane).setTopTrim(node);
            } else {
                Node area = this.rootPane.lookup("#top-trim-area");
                if (area != null) {
                    this.addNodeToCustomParent(java.util.Optional.ofNullable(node), area, DefWindowRenderer.ID_TOP_TRIM_AREA);
                } else {
                    this.trimPane.setTop(node);
                }
            }
        }

        private static Node getStaticLayoutNodeOrNull(WLayoutedWidget<?> trimBar) {
            if (trimBar != null) {
                return (Node)trimBar.getStaticLayoutNode();
            }
            return null;
        }

        public void addChild(WLayoutedWidget<MWindowElement> widget) {
            this.contentPane.getChildren().add((Object)((Node)widget.getStaticLayoutNode()));
        }

        public void removeChild(WLayoutedWidget<MWindowElement> widget) {
            this.contentPane.getChildren().remove((Object)((Node)widget.getStaticLayoutNode()));
        }

        public void addChild(int idx, WLayoutedWidget<MWindowElement> widget) {
            this.contentPane.getChildren().add(idx, (Object)((Node)widget.getStaticLayoutNode()));
        }

        public void setMaximizedContent(WLayoutedWidget<? extends MUIElement> widget) {
            if (this.maximizedWidget != null) {
                return;
            }
            WLayoutedWidget<? extends MUIElement> childWidget = widget;
            Pane staticLayoutNode = (Pane)this.trimPane.getCenter();
            this.maximizedWidget = widget;
            FillLayoutPane maximizationContainer = new FillLayoutPane();
            FillLayoutPane greyPane = new FillLayoutPane();
            greyPane.getStyleClass().add((Object)"maximization-container");
            greyPane.setOpacity(0.0);
            int size = staticLayoutNode.getChildren().size();
            if (this.overlayContainer == staticLayoutNode.getChildren().get(size - 1)) {
                staticLayoutNode.getChildren().add(size - 1, (Object)greyPane);
                staticLayoutNode.getChildren().add(size, (Object)maximizationContainer);
            } else {
                staticLayoutNode.getChildren().add((Object)greyPane);
                staticLayoutNode.getChildren().add((Object)maximizationContainer);
            }
            Runnable finisher = () -> {
                staticLayoutNode.getChildren().stream().forEach(n -> n.setVisible(false));
                maximizationContainer.setVisible(true);
                maximizationContainer.getChildren().clear();
                maximizationContainer.getChildren().add((Object)((Region)childWidget.getWidgetNode()));
                greyPane.setOpacity(1.0);
                this.maximizationContainer = maximizationContainer;
                this.greyPane = greyPane;
            };
            if (this.maximizationTransition != null) {
                this.maximizationTransition.maximize((Object)staticLayoutNode, (Object)greyPane, (Object)maximizationContainer, (Object)((Region)childWidget.getWidgetNode()), finisher);
            } else {
                finisher.run();
            }
        }

        public void removeMaximizedContent() {
            if (this.maximizationContainer != null) {
                Pane staticLayoutNode = (Pane)this.trimPane.getCenter();
                Pane childStaticNode = (Pane)this.maximizedWidget.getStaticLayoutNode();
                Region childPane = (Region)this.maximizedWidget.getWidgetNode();
                FillLayoutPane maximizationContainer = this.maximizationContainer;
                FillLayoutPane greyPane = this.greyPane;
                this.maximizationContainer = null;
                this.maximizedWidget = null;
                Runnable finisher = () -> {
                    staticLayoutNode.getChildren().remove((Object)greyPane);
                    staticLayoutNode.getChildren().remove((Object)maximizationContainer);
                    childStaticNode.getChildren().add((Object)childPane);
                    staticLayoutNode.getChildren().stream().forEach(n -> n.setVisible(true));
                };
                if (this.maximizationTransition != null) {
                    this.maximizationTransition.restore((Object)staticLayoutNode, (Object)greyPane, (Object)maximizationContainer, (Object)childStaticNode, (Object)childPane, finisher);
                } else {
                    finisher.run();
                }
            }
        }
    }

    static class WindowResizeButton
    extends Region {
        double dragOffsetX;
        double dragOffsetY;
        final Stage stage;
        final double stageMinimumWidth;
        final double stageMinimumHeight;

        public WindowResizeButton(Stage stage, double stageMinimumWidth, double stageMinimumHeight) {
            this.stage = stage;
            this.stageMinimumWidth = stageMinimumWidth;
            this.stageMinimumHeight = stageMinimumHeight;
            this.setId("window-resize-button");
            this.setPrefSize(11.0, 11.0);
            this.setOnMousePressed(this::handleMousePressed);
            this.setOnMouseDragged(this::handleMouseDragged);
        }

        void handleMousePressed(MouseEvent e) {
            this.dragOffsetX = this.stage.getX() + this.stage.getWidth() - e.getScreenX();
            this.dragOffsetY = this.stage.getY() + this.stage.getHeight() - e.getScreenY();
            e.consume();
        }

        void handleMouseDragged(MouseEvent e) {
            ObservableList screens = Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)1.0, (double)1.0);
            Screen screen = screens.size() > 0 ? (Screen)Screen.getScreensForRectangle((double)this.stage.getX(), (double)this.stage.getY(), (double)1.0, (double)1.0).get(0) : (Screen)Screen.getScreensForRectangle((double)0.0, (double)0.0, (double)1.0, (double)1.0).get(0);
            Rectangle2D visualBounds = screen.getVisualBounds();
            double maxX = Math.min(visualBounds.getMaxX(), e.getScreenX() + this.dragOffsetX);
            double maxY = Math.min(visualBounds.getMaxY(), e.getScreenY() - this.dragOffsetY);
            this.stage.setWidth(Math.max(this.stageMinimumWidth, maxX - this.stage.getX()));
            this.stage.setHeight(Math.max(this.stageMinimumHeight, maxY - this.stage.getY()));
            e.consume();
        }
    }
}

