/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding;

import java.util.ArrayList;
import java.util.Iterator;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.jdt.annotation.NonNull;

public class TreeUtil {
    public static <T> @NonNull TreeItem<T> createModel(@NonNull T root, @NonNull ObservableFactory<T> factory) {
        return new TreeItemImpl<T>(root, factory);
    }

    public static interface ObservableFactory<T> {
        public IObservableList createObservable(@NonNull T var1);
    }

    static class TreeItemImpl<T>
    extends TreeItem<T> {
        private IObservableList list;
        @NonNull ObservableFactory<T> factory;
        private boolean hasLoadedChildren = false;

        public TreeItemImpl(@NonNull T element, @NonNull ObservableFactory<T> factory) {
            this.setValue(element);
            this.factory = factory;
            this.list = factory.createObservable(element);
            this.getChildren().add((Object)new TreeItem());
            this.expandedProperty().addListener(o -> {
                if (this.isExpanded() && !this.hasLoadedChildren) {
                    this.loadChildren();
                }
            });
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void loadChildren() {
            this.hasLoadedChildren = true;
            if (this.list != null) {
                final @NonNull @NonNull ObservableList itemList = this.getChildren();
                this.list.addListChangeListener(new IListChangeListener(){

                    public void handleListChange(ListChangeEvent event) {
                        event.diff.accept(new ListDiffVisitor(){

                            public void handleRemove(int index, Object element) {
                                if (itemList.size() < index) {
                                    TreeItem t = (TreeItem)itemList.get(index);
                                    if (t.getValue() == element) {
                                        itemList.remove(index);
                                    } else {
                                        Iterator it = itemList.iterator();
                                        while (it.hasNext()) {
                                            if (((TreeItem)it.next()).getValue() != element) continue;
                                            it.remove();
                                            break;
                                        }
                                    }
                                }
                            }

                            public void handleAdd(int index, Object element) {
                                if (itemList.size() > index) {
                                    itemList.add(index, new TreeItemImpl<Object>(element, factory));
                                } else {
                                    itemList.add(new TreeItemImpl<Object>(element, factory));
                                }
                            }
                        });
                    }
                });
                ArrayList<TreeItemImpl<@NonNull E>> l = new ArrayList(this.list.size());
                Iterator iterator = this.list.iterator();
                while (iterator.hasNext()) {
                    Object o;
                    Object t = o = iterator.next();
                    l.add(new TreeItemImpl(t, this.factory));
                }
                itemList.setAll(l);
            }
        }
    }
}

