/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.list;

import java.util.function.Function;
import javafx.beans.binding.StringExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import org.eclipse.fx.ui.controls.list.SimpleListCell;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ListComboUtil {
    public static <T> ComboBox<T> setupCombo(ComboBox<T> comboBox, ObservableList<T> items, @NonNull Function<@Nullable T, @Nullable CharSequence> labelExtractor) {
        comboBox.setCellFactory(v -> new SimpleListCell(labelExtractor));
        comboBox.setButtonCell(new SimpleListCell<T>(labelExtractor));
        comboBox.setItems(items);
        return comboBox;
    }

    public static <T> ListView<T> setupList(ListView<T> listView, ObservableList<T> items, final Function<T, StringExpression> labelPropertyExtractor) {
        listView.setCellFactory(v -> new ListCell<T>(){

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                this.textProperty().unbind();
                if (item != null && !empty) {
                    this.textProperty().bind((ObservableValue)labelPropertyExtractor.apply(item));
                } else {
                    this.setText(null);
                }
            }
        });
        listView.setItems(items);
        return listView;
    }
}

