/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.eclipse.fx.core.RankedService;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.core.function.ExExecutor;
import org.eclipse.fx.core.internal.sm.Component;
import org.eclipse.fx.core.internal.sm.Component11;
import org.eclipse.fx.core.internal.sm.Component12;
import org.eclipse.fx.core.internal.sm.Properties;
import org.eclipse.fx.core.internal.sm.Reference;
import org.eclipse.jdt.annotation.NonNull;

public class JavaDSServiceProcessor {
    private Map<String, Component> componentCache;
    private Map<String, List<Component>> serviceList;
    private Map<Class<?>, List<?>> serviceCache = new HashMap();
    private static JavaDSServiceProcessor INSTANCE;

    public static synchronized <S> @NonNull List<@NonNull S> lookupServiceList(Class<?> requestor, Class<S> clazz) {
        if (INSTANCE == null) {
            INSTANCE = new JavaDSServiceProcessor();
        }
        return INSTANCE._lookupServiceList(requestor, clazz);
    }

    private synchronized <S> @NonNull List<@NonNull S> _lookupServiceList(Class<?> requestor, Class<S> clazz) {
        List<?> list = this.serviceCache.get(clazz);
        if (list != null) {
            return list;
        }
        this.initializeComponentCache();
        List<Component> componentList = this.serviceList.get(clazz.getName());
        if (componentList != null) {
            List collect = componentList.stream().map(c -> c.getImplementation().getClazz()).map(c -> ExExecutor.executeFunction(c, className -> Class.forName(className), "Could not load class '" + c + "'").orElse(null)).filter(c -> c != null).map(c -> {
                if (c != null) {
                    return ExExecutor.executeSupplier(c::newInstance, "Could not create instance").get();
                }
                return null;
            }).filter(c -> c != null).sorted((o1, o2) -> {
                if (o1 instanceof RankedService && o2 instanceof RankedService) {
                    return -1 * Integer.compare(((RankedService)o1).getRanking(), ((RankedService)o2).getRanking());
                }
                return 0;
            }).collect(Collectors.toList());
            this.serviceCache.put(clazz, collect);
            collect.stream().forEach(this::process);
            return collect;
        }
        return Collections.emptyList();
    }

    private void process(Object o) {
        Component component = this.componentCache.get(o.getClass().getName());
        if (component != null) {
            component.getReference().stream().forEach(r -> this.handleReference(o, (Reference)r));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void logError(String message, Throwable t) {
        System.err.println(String.valueOf(JavaDSServiceProcessor.class.getSimpleName()) + " - " + message);
        if (t == null) return;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                StringWriter s = new StringWriter();
                try {
                    try (PrintWriter w = new PrintWriter(s);){
                        t.printStackTrace(w);
                        System.err.println(String.valueOf(JavaDSServiceProcessor.class.getSimpleName()) + " - " + s);
                    }
                    if (s == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (s == null) throw throwable;
                    s.close();
                    throw throwable;
                }
                s.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeComponentCache() {
        if (this.componentCache == null) {
            this.componentCache = new HashMap<String, Component>();
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Enumeration<URL> resources = cl.getResources("META-INF/MANIFEST.MF");
                while (resources.hasMoreElements()) {
                    Map<String, Component> collect;
                    String value;
                    URL url = resources.nextElement();
                    Manifest m = null;
                    try {
                        Throwable throwable = null;
                        Object var6_9 = null;
                        try (InputStream in = url.openStream();){
                            m = new Manifest(in);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e2) {
                        JavaDSServiceProcessor.logError("Unable to read manifest of " + url, e2);
                    }
                    if (m == null || (value = m.getMainAttributes().getValue("Service-Component")) == null) continue;
                    Map<String, Component> map = collect = Stream.of(value.split(",")).map(String::trim).map(e -> cl.getResource((String)e)).map(this::handle).filter(c -> c != null).collect(Collectors.toMap(c -> c.getImplementation().getClazz(), c -> c));
                    synchronized (map) {
                        this.componentCache.putAll(collect);
                    }
                }
                this.serviceList = new HashMap<String, List<Component>>();
                this.componentCache.values().forEach(c -> {
                    this.serviceList.computeIfAbsent(c.getImplementation().getClazz(), i -> new ArrayList()).add(c);
                    if (c.getService() != null) {
                        c.getService().getProvide().forEach(s -> this.serviceList.computeIfAbsent(s.getIface(), i -> new ArrayList()).add(c));
                    }
                });
            }
            catch (IOException e3) {
                JavaDSServiceProcessor.logError("Failed loading data into component cache", e3);
            }
        }
    }

    private static Method getMethod(Class<?> cl, String name, Class<?> serviceType) {
        if (name == null) {
            return null;
        }
        Method register = null;
        try {
            register = cl.getDeclaredMethod(name, serviceType, Map.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {}
        try {
            register = cl.getDeclaredMethod(name, serviceType);
        }
        catch (NoSuchMethodException | SecurityException exception) {}
        if (register == null && cl.getSuperclass() != Object.class) {
            register = JavaDSServiceProcessor.getMethod(cl.getSuperclass(), name, serviceType);
        }
        return register;
    }

    private void handleReference(Object o, Reference r) {
        block14: {
            try {
                Class<?> serviceInterface = Class.forName(r.getIface());
                Method bind = JavaDSServiceProcessor.getMethod(o.getClass(), r.getBind(), serviceInterface);
                if (bind != null) {
                    boolean changeAccessible = false;
                    if (!bind.isAccessible()) {
                        bind.setAccessible(true);
                        changeAccessible = true;
                    }
                    try {
                        Reference.ReferenceCardinality cardinality = Reference.ReferenceCardinality.fromString(r.getCardinality());
                        switch (cardinality) {
                            case MULTIPLE: 
                            case AT_LEAST_ONE: {
                                List<?> list = Util.lookupServiceList(serviceInterface);
                                if (cardinality == Reference.ReferenceCardinality.AT_LEAST_ONE && list.isEmpty()) {
                                    JavaDSServiceProcessor.logError("Unsatisfied dependency '" + r.getIface() + "'. There must be at least one component providing this service", null);
                                    break;
                                }
                                list.stream().forEach(s -> JavaDSServiceProcessor.invoke(bind, o, s, this.getProperties(s)));
                                break;
                            }
                            case OPTIONAL: 
                            case MANDATORY: {
                                Optional<?> service = Util.getService(serviceInterface);
                                if (Reference.ReferenceCardinality.MANDATORY == cardinality && !service.isPresent()) {
                                    JavaDSServiceProcessor.logError("Unsatisfied dependency '" + r.getIface() + "'. There must be at least one component providing this service", null);
                                    break;
                                }
                                Object s2 = service.get();
                                JavaDSServiceProcessor.invoke(bind, o, s2, this.getProperties(s2));
                                break;
                            }
                        }
                        break block14;
                    }
                    finally {
                        if (changeAccessible) {
                            bind.setAccessible(false);
                        }
                    }
                }
                System.err.println("Could not find bind method '" + r.getBind() + "'");
            }
            catch (Throwable t) {
                JavaDSServiceProcessor.logError("Failed to resolve references", t);
            }
        }
    }

    private Map<String, Object> getProperties(Object serviceObject) {
        Component component = this.componentCache.get(serviceObject.getClass().getName());
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (component != null) {
            data.putAll(component.getProperty().stream().collect(Collectors.toMap(p -> p.getName(), p -> p.getValue())));
            data.putAll(component.getProperties().stream().map(Properties::getEntry).map(e -> serviceObject.getClass().getClassLoader().getResource((String)e)).map(eu -> {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (InputStream in = eu.openStream();){
                        java.util.Properties p = new java.util.Properties();
                        p.load(in);
                        return p.entrySet();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable t) {
                    JavaDSServiceProcessor.logError("Unable to load properties file", t);
                    return null;
                }
            }).filter(m -> m != null).flatMap(m -> m.stream()).collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue())));
        }
        return data;
    }

    private static void invoke(Method m, Object o, Object s, Map<String, Object> properties) {
        try {
            if (m.getParameterCount() == 2) {
                m.invoke(o, s, properties);
            } else {
                m.invoke(o, s);
            }
        }
        catch (Throwable t) {
            JavaDSServiceProcessor.logError("Failed to invoke bind method", t);
        }
    }

    private Component handle(URL resource) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = resource.openStream();){
                String data = Util.readToString(in, Charset.forName("UTF-8"));
                JAXBContext jaxbContext = data.contains("http://www.osgi.org/xmlns/scr/v1.1.0") ? JAXBContext.newInstance((Class[])new Class[]{Component11.class}) : JAXBContext.newInstance((Class[])new Class[]{Component12.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                return (Component)jaxbUnmarshaller.unmarshal((Reader)new StringReader(data));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            JavaDSServiceProcessor.logError("Unable to load component '" + resource + "'", e);
            return null;
        }
    }
}

