/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.fx.ui.panes.GridData;
import org.eclipse.fx.ui.panes.GridLayoutPane;
import org.eclipse.fx.ui.panes.SashPane;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseSashRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WSash;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DefSashRenderer
extends BaseSashRenderer<Node> {
    protected Class<? extends WSash<Node>> getWidgetClass(MPartSashContainer container) {
        if (container.getTags().contains("fx_fixedLayout")) {
            return WFixedSashImpl.class;
        }
        if (Boolean.getBoolean("efxclipse.eclipse.compat.sash")) {
            System.err.println("======> CUSTOM IMPL");
            return WResizableSashImpl_2.class;
        }
        return WResizableSashImpl.class;
    }

    static class WFixedSashImpl
    extends WLayoutedWidgetImpl<GridLayoutPane, Node, MPartSashContainer>
    implements WSash<Node> {
        private final @NonNull MPartSashContainer mPartSashContainer;

        private static @NonNull GridData toGridData(Map<String, String> dataMap) {
            GridData gd = new GridData();
            if (dataMap.containsKey("fx_layout_width")) {
                gd.widthHintProperty().set(Integer.parseInt(dataMap.get("fx_layout_width")));
                if (!dataMap.containsKey("fx_layout_height")) {
                    gd.grabExcessVerticalSpaceProperty().set(true);
                    gd.verticalAlignmentProperty().set((Object)GridData.Alignment.FILL);
                }
            } else {
                gd.horizontalAlignmentProperty().set((Object)GridData.Alignment.FILL);
            }
            if (dataMap.containsKey("fx_layout_height")) {
                gd.heightHintProperty().set(Integer.parseInt(dataMap.get("fx_layout_height")));
                if (!dataMap.containsKey("fx_layout_width")) {
                    gd.grabExcessHorizontalSpaceProperty().set(true);
                    gd.horizontalAlignmentProperty().set((Object)GridData.Alignment.FILL);
                }
            } else {
                gd.verticalAlignmentProperty().set((Object)GridData.Alignment.FILL);
            }
            if (dataMap.containsKey("fx_layout_grab_horizontal")) {
                gd.grabExcessHorizontalSpaceProperty().set(Boolean.parseBoolean(dataMap.get("fx_layout_grab_horizontal")));
                gd.horizontalAlignmentProperty().set((Object)GridData.Alignment.FILL);
            }
            if (dataMap.containsKey("fx_layout_grab_vertical")) {
                gd.grabExcessVerticalSpaceProperty().set(Boolean.parseBoolean(dataMap.get("fx_layout_grab_vertical")));
                gd.verticalAlignmentProperty().set((Object)GridData.Alignment.FILL);
            }
            return gd;
        }

        @Inject
        public WFixedSashImpl(@Named(value="fx.rendering.domElement") @NonNull MPartSashContainer mPartSashContainer) {
            this.mPartSashContainer = mPartSashContainer;
        }

        public void addItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            MPartSashContainerElement domElement2;
            Node n = (Node)widget.getStaticLayoutNode();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            MPartSashContainer element = (MPartSashContainer)this.getDomElement();
            if (element != null && element.isHorizontal()) {
                p.setNumColumns(p.getNumColumns() + 1);
            }
            if ((domElement2 = (MPartSashContainerElement)widget.getDomElement()) != null) {
                GridData gd = WFixedSashImpl.toGridData(domElement2.getPersistedState());
                GridLayoutPane.setConstraint((Node)n, (GridData)gd);
            }
            p.getChildren().add((Object)n);
        }

        public int getItemCount() {
            return ((GridLayoutPane)this.getWidget()).getChildren().size();
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            for (WLayoutedWidget<MPartSashContainerElement> w : list) {
                Node n = (Node)w.getStaticLayoutNode();
                MPartSashContainerElement element = (MPartSashContainerElement)w.getDomElement();
                if (element != null) {
                    GridData gd = WFixedSashImpl.toGridData(element.getPersistedState());
                    GridLayoutPane.setConstraint((Node)n, (GridData)gd);
                }
                nodeList.add(n);
            }
            MPartSashContainer element = (MPartSashContainer)this.getDomElement();
            if (element != null && element.isHorizontal()) {
                p.setNumColumns(p.getNumColumns() + nodeList.size());
            }
            p.getChildren().addAll(nodeList);
        }

        public void addItems(int index, List<WLayoutedWidget<MPartSashContainerElement>> list) {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            for (WLayoutedWidget<MPartSashContainerElement> w : list) {
                Node n = (Node)w.getStaticLayoutNode();
                MPartSashContainerElement element = (MPartSashContainerElement)w.getDomElement();
                if (element != null) {
                    GridData gd = WFixedSashImpl.toGridData(element.getPersistedState());
                    GridLayoutPane.setConstraint((Node)n, (GridData)gd);
                }
                nodeList.add(n);
            }
            MPartSashContainer element = (MPartSashContainer)this.getDomElement();
            if (element != null && element.isHorizontal()) {
                p.setNumColumns(p.getNumColumns() + nodeList.size());
            }
            p.getChildren().addAll(index, nodeList);
        }

        public void removeItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            Node n = (Node)widget.getStaticLayoutNode();
            GridLayoutPane p = (GridLayoutPane)this.getWidget();
            MPartSashContainer domElement = (MPartSashContainer)this.getDomElement();
            if (domElement != null && domElement.isHorizontal()) {
                p.setNumColumns(p.getNumColumns() - 1);
            }
            p.getChildren().remove((Object)n);
        }

        @Override
        public GridLayoutPane getWidgetNode() {
            return (GridLayoutPane)this.getWidget();
        }

        @Override
        protected GridLayoutPane createWidget() {
            GridLayoutPane p = new GridLayoutPane();
            p.setMarginWidth(0);
            p.setMarginHeight(0);
            p.setHorizontalSpacing(0);
            p.setVerticalSpacing(0);
            p.setNumColumns(this.mPartSashContainer.isHorizontal() ? 0 : 1);
            return p;
        }

        public void updateLayout() {
        }
    }

    static class WResizableSashImpl
    extends WLayoutedWidgetImpl<SplitPane, SplitPane, MPartSashContainer>
    implements WSash<Node> {
        private List<WLayoutedWidget<MPartSashContainerElement>> items = new ArrayList<WLayoutedWidget<MPartSashContainerElement>>();
        ChangeListener<Number> listener = new ChangeListener<Number>(){
            boolean queueing;

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (!this.queueing) {
                    this.queueing = true;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            this.recalcWeight();
                            queueing = false;
                        }
                    });
                }
            }
        };

        WResizableSashImpl() {
        }

        public void updateLayout() {
            this.updateDividers();
        }

        void recalcWeight() {
            @Nullable MPartSashContainer domElement = (MPartSashContainer)this.getDomElement();
            if (domElement != null) {
                BaseRenderer r = (BaseRenderer)domElement.getRenderer();
                r.syncUIModifications((MUIElement)domElement, this::doRecalcWeight);
            } else {
                this.logger.error("The domain object should not be null at this point");
            }
        }

        void doRecalcWeight() {
            if (this.state != WWidget.WidgetState.CREATED) {
                return;
            }
            double prev = 0.0;
            int idx = 0;
            if (this.items.isEmpty()) {
                return;
            }
            double[] dArray = ((SplitPane)this.getWidget()).getDividerPositions();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPartSashContainerElement element;
                double d = dArray[n2];
                if ((element = (MPartSashContainerElement)this.items.get(idx++).getDomElement()) != null) {
                    element.setContainerData(String.valueOf((d - prev) * 10.0));
                }
                prev = d;
                ++n2;
            }
            MPartSashContainerElement element = (MPartSashContainerElement)this.items.get(this.items.size() - 1).getDomElement();
            if (element != null) {
                element.setContainerData(String.valueOf((1.0 - prev) * 10.0));
            }
        }

        @Override
        protected void bindProperties(SplitPane widget) {
            super.bindProperties(widget);
            widget.getDividers().addListener((ListChangeListener)new ListChangeListener<SplitPane.Divider>(){

                public void onChanged(ListChangeListener.Change<? extends SplitPane.Divider> c) {
                    while (c.next()) {
                        for (SplitPane.Divider d : c.getAddedSubList()) {
                            d.positionProperty().addListener(listener);
                        }
                        for (SplitPane.Divider d : c.getRemoved()) {
                            d.positionProperty().removeListener(listener);
                        }
                    }
                }
            });
            for (SplitPane.Divider d : widget.getDividers()) {
                d.positionProperty().addListener(this.listener);
            }
        }

        @Override
        protected SplitPane createWidget() {
            SplitPane p = new SplitPane();
            return p;
        }

        @Inject
        void setOrientation(@Named(value="horizontal") boolean horizontal) {
            ((SplitPane)this.getWidget()).setOrientation(horizontal ? Orientation.HORIZONTAL : Orientation.VERTICAL);
        }

        @Override
        public SplitPane getWidgetNode() {
            return (SplitPane)this.getWidget();
        }

        private static void setResizableWithParent(WLayoutedWidget widget) {
            MUIElement domElement = widget.getDomElement();
            if (domElement != null) {
                SplitPane.setResizableWithParent((Node)((Node)widget.getStaticLayoutNode()), (Boolean)(!domElement.getTags().contains("fx_no_auto_resize") ? 1 : 0));
            }
        }

        public void addItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            WResizableSashImpl.setResizableWithParent(widget);
            p.getItems().add((Object)((Node)widget.getStaticLayoutNode()));
            this.items.add(widget);
            this.updateDividers();
        }

        public void addItems(int index, List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                WResizableSashImpl.setResizableWithParent(i);
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(index, l);
            this.items.addAll(index, list);
            this.updateDividers();
        }

        public void addItems(List<WLayoutedWidget<MPartSashContainerElement>> list) {
            SplitPane p = (SplitPane)this.getWidget();
            ArrayList<Node> l = new ArrayList<Node>();
            for (WLayoutedWidget<MPartSashContainerElement> i : list) {
                WResizableSashImpl.setResizableWithParent(i);
                l.add((Node)i.getStaticLayoutNode());
            }
            p.getItems().addAll(l);
            this.items.addAll(list);
            this.updateDividers();
        }

        @Override
        public void setWidgetState(WWidget.WidgetState state) {
            super.setWidgetState(state);
            if (state == WWidget.WidgetState.CREATED) {
                this.updateDividers();
            }
        }

        public void removeItem(WLayoutedWidget<MPartSashContainerElement> widget) {
            SplitPane p = (SplitPane)this.getWidget();
            p.getItems().remove(widget.getStaticLayoutNode());
            this.items.remove(widget);
            this.updateDividers();
        }

        @Override
        protected void doCleanup() {
            super.doCleanup();
            this.items.clear();
        }

        private void updateDividers() {
            if (this.items.size() <= 1) {
                return;
            }
            if (this.state != WWidget.WidgetState.CREATED) {
                return;
            }
            double total = 0.0;
            for (WLayoutedWidget<MPartSashContainerElement> w : this.items) {
                total += w.getWeight();
            }
            double[] deviders = new double[this.items.size() - 1];
            int i = 0;
            while (i < this.items.size() - 1) {
                deviders[i] = (i == 0 ? 0.0 : deviders[i - 1]) + this.items.get(i).getWeight() / total;
                ++i;
            }
            ((SplitPane)this.getWidget()).setDividerPositions(deviders);
        }

        public int getItemCount() {
            return ((SplitPane)this.getWidget()).getItems().size();
        }
    }

    static class WResizableSashImpl_2
    extends WLayoutedWidgetImpl<SashPane, Node, MPartSashContainer>
    implements WSash<Node> {
        private List<WLayoutedWidget<?>> items = new ArrayList();

        WResizableSashImpl_2() {
        }

        public int getItemCount() {
            SashPane p = (SashPane)this.getWidget();
            return p.getItems().size();
        }

        private static int getWeight(WLayoutedWidget<?> w) {
            double v = w.getWeight();
            if (v < 1.0) {
                return (int)(v * 100.0);
            }
            if (w.getDomElement().getContainerData() == null) {
                return 200;
            }
            return (int)v;
        }

        public void addItem(@NonNull WLayoutedWidget<MPartSashContainerElement> widget) {
            this.syncWeights();
            SashPane p = (SashPane)this.getWidget();
            int[] w = p.getWeights();
            p.getItems().add((Object)((Node)widget.getStaticLayoutNode()));
            int[] wn = new int[w.length + 1];
            System.arraycopy(w, 0, wn, 0, w.length);
            wn[wn.length - 1] = WResizableSashImpl_2.getWeight(widget);
            p.setWeights(wn);
            this.items.add(widget);
        }

        public void addItems(@NonNull List<WLayoutedWidget<MPartSashContainerElement>> list) {
            this.syncWeights();
            SashPane p = (SashPane)this.getWidget();
            int[] w = p.getWeights();
            p.getItems().addAll((Collection)list.stream().map(e -> (Node)e.getStaticLayoutNode()).collect(Collectors.toList()));
            int[] wn = new int[w.length + list.size()];
            System.arraycopy(w, 0, wn, 0, w.length);
            int i = w.length;
            while (i < wn.length) {
                wn[i] = WResizableSashImpl_2.getWeight(list.get(i - w.length));
                ++i;
            }
            p.setWeights(wn);
            this.items.addAll(list);
        }

        public void addItems(int index, @NonNull List<WLayoutedWidget<MPartSashContainerElement>> list) {
            this.syncWeights();
            SashPane p = (SashPane)this.getWidget();
            int[] w = p.getWeights();
            p.getItems().addAll(index, (Collection)list.stream().map(e -> (Node)e.getStaticLayoutNode()).collect(Collectors.toList()));
            int[] wn = new int[w.length + list.size()];
            System.arraycopy(w, 0, wn, 0, index);
            int i = 0;
            while (i < list.size()) {
                wn[i + index] = WResizableSashImpl_2.getWeight(list.get(i));
                ++i;
            }
            System.arraycopy(w, index, wn, index + 1, w.length - index);
            p.setWeights(wn);
            this.items.addAll(index, list);
        }

        public void removeItem(@NonNull WLayoutedWidget<MPartSashContainerElement> widget) {
            this.syncWeights();
            SashPane p = (SashPane)this.getWidget();
            p.getItems().remove(widget.getStaticLayoutNode());
            this.items.remove(widget);
        }

        public void updateLayout() {
        }

        private void syncWeights() {
            int[] weights = ((SashPane)this.getWidget()).getWeights();
            int i = 0;
            while (i < weights.length) {
                MUIElement domElement = this.items.get(i).getDomElement();
                if (domElement != null) {
                    domElement.setContainerData(String.valueOf(weights[i]));
                }
                ++i;
            }
        }

        @Override
        public @NonNull Node getWidgetNode() {
            return (Node)this.getWidget();
        }

        @Override
        protected @NonNull SashPane createWidget() {
            SashPane p = new SashPane();
            return p;
        }

        @Inject
        void setOrientation(@Named(value="horizontal") boolean horizontal) {
            ((SashPane)this.getWidget()).setHorizontal(horizontal);
        }
    }
}

