/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.DecoratingObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;

public class DecoratingObservableList
extends DecoratingObservableCollection
implements IObservableList {
    private IObservableList decorated;
    private IListChangeListener listChangeListener;

    public DecoratingObservableList(IObservableList decorated, boolean disposeDecoratedOnDispose) {
        super(decorated, disposeDecoratedOnDispose);
        this.decorated = decorated;
    }

    @Override
    public synchronized void addListChangeListener(IListChangeListener listener) {
        this.addListener(ListChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeListChangeListener(IListChangeListener listener) {
        this.removeListener(ListChangeEvent.TYPE, listener);
    }

    protected void fireListChange(ListDiff diff) {
        super.fireChange();
        this.fireEvent(new ListChangeEvent(this, diff));
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireListChange() instead");
    }

    @Override
    protected void firstListenerAdded() {
        if (this.listChangeListener == null) {
            this.listChangeListener = new IListChangeListener(){

                @Override
                public void handleListChange(ListChangeEvent event) {
                    DecoratingObservableList.this.handleListChange(event);
                }
            };
        }
        this.decorated.addListChangeListener(this.listChangeListener);
        super.firstListenerAdded();
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        if (this.listChangeListener != null) {
            this.decorated.removeListChangeListener(this.listChangeListener);
            this.listChangeListener = null;
        }
    }

    protected void handleListChange(ListChangeEvent event) {
        this.fireListChange(event.diff);
    }

    public void add(int index, Object o) {
        this.checkRealm();
        this.decorated.add(index, o);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        this.checkRealm();
        return this.decorated.addAll(index, c);
    }

    @Override
    public Object get(int index) {
        this.getterCalled();
        return this.decorated.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.getterCalled();
        return this.decorated.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.decorated.lastIndexOf(o);
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        this.getterCalled();
        final ListIterator iterator = this.decorated.listIterator(index);
        return new ListIterator(){

            public void add(Object o) {
                iterator.add(o);
            }

            @Override
            public boolean hasNext() {
                DecoratingObservableList.this.getterCalled();
                return iterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                DecoratingObservableList.this.getterCalled();
                return iterator.hasPrevious();
            }

            @Override
            public Object next() {
                DecoratingObservableList.this.getterCalled();
                return iterator.next();
            }

            @Override
            public int nextIndex() {
                DecoratingObservableList.this.getterCalled();
                return iterator.nextIndex();
            }

            public Object previous() {
                DecoratingObservableList.this.getterCalled();
                return iterator.previous();
            }

            @Override
            public int previousIndex() {
                DecoratingObservableList.this.getterCalled();
                return iterator.previousIndex();
            }

            @Override
            public void remove() {
                DecoratingObservableList.this.checkRealm();
                iterator.remove();
            }

            public void set(Object o) {
                DecoratingObservableList.this.checkRealm();
                iterator.set(o);
            }
        };
    }

    @Override
    public Object move(int oldIndex, int newIndex) {
        this.checkRealm();
        return this.decorated.move(oldIndex, newIndex);
    }

    @Override
    public Object remove(int index) {
        this.checkRealm();
        return this.decorated.remove(index);
    }

    @Override
    public Object set(int index, Object element) {
        this.checkRealm();
        return this.decorated.set(index, element);
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        this.getterCalled();
        return this.decorated.subList(fromIndex, toIndex);
    }

    @Override
    public synchronized void dispose() {
        if (this.decorated != null && this.listChangeListener != null) {
            this.decorated.removeListChangeListener(this.listChangeListener);
        }
        this.decorated = null;
        this.listChangeListener = null;
        super.dispose();
    }
}

