/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestBuilderWrapperImpl;
import org.osgi.service.http.context.ServletContextHelper;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 3586876493076122102L;
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String ETAG = "ETag";
    private String internalName;
    private ServletContextHelper servletContextHelper;
    private AccessControlContext acc;

    public ResourceServlet(String internalName, ServletContextHelper servletContextHelper, AccessControlContext acc) {
        this.internalName = internalName;
        if (internalName.equals("/")) {
            this.internalName = "";
        }
        this.servletContextHelper = servletContextHelper;
        this.acc = acc;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String method = req.getMethod();
        if (method.equals("GET") || method.equals("POST") || method.equals("HEAD")) {
            String resourcePath;
            URL resourceURL;
            String pathInfo = HttpServletRequestBuilderWrapperImpl.getDispatchPathInfo(req);
            if (pathInfo == null) {
                pathInfo = "";
            }
            if ((resourceURL = this.servletContextHelper.getResource(resourcePath = String.valueOf(this.internalName) + pathInfo)) != null) {
                this.writeResource(req, resp, resourcePath, resourceURL);
            } else {
                resp.sendError(404, "ProxyServlet: " + req.getRequestURI());
            }
        } else {
            resp.setStatus(405);
        }
    }

    private void writeResource(final HttpServletRequest req, final HttpServletResponse resp, final String resourcePath, final URL resourceURL) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public Boolean run() throws Exception {
                    String contentType;
                    String ifNoneMatch;
                    URLConnection connection = resourceURL.openConnection();
                    long lastModified = connection.getLastModified();
                    int contentLength = connection.getContentLength();
                    String etag = null;
                    if (lastModified != -1L && contentLength != -1) {
                        etag = "W/\"" + contentLength + "-" + lastModified + "\"";
                    }
                    if ((ifNoneMatch = req.getHeader(ResourceServlet.IF_NONE_MATCH)) != null && etag != null && ifNoneMatch.indexOf(etag) != -1) {
                        resp.setStatus(304);
                        return Boolean.TRUE;
                    }
                    long ifModifiedSince = req.getDateHeader(ResourceServlet.IF_MODIFIED_SINCE);
                    if (ifModifiedSince > -1L && lastModified > 0L && lastModified <= ifModifiedSince + 999L) {
                        resp.setStatus(304);
                        return Boolean.TRUE;
                    }
                    if (contentLength != -1) {
                        resp.setContentLength(contentLength);
                    }
                    if ((contentType = ResourceServlet.this.servletContextHelper.getMimeType(resourcePath)) == null) {
                        contentType = ResourceServlet.this.getServletConfig().getServletContext().getMimeType(resourcePath);
                    }
                    if (contentType != null) {
                        resp.setContentType(contentType);
                    }
                    if (lastModified > 0L) {
                        resp.setDateHeader(ResourceServlet.LAST_MODIFIED, lastModified);
                    }
                    if (etag != null) {
                        resp.setHeader(ResourceServlet.ETAG, etag);
                    }
                    if (contentLength == 0) return Boolean.TRUE;
                    InputStream is = null;
                    try {
                        is = connection.getInputStream();
                        try {
                            ServletOutputStream os = resp.getOutputStream();
                            int writtenContentLength = ResourceServlet.this.writeResourceToOutputStream(is, (OutputStream)os);
                            if (contentLength == -1 || contentLength != writtenContentLength) {
                                resp.setContentLength(writtenContentLength);
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            PrintWriter writer = resp.getWriter();
                            ResourceServlet.this.writeResourceToWriter(is, writer);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        ResourceServlet.this.sendError(resp, 403);
                        if (is == null) return Boolean.TRUE;
                        try {
                            is.close();
                            return Boolean.TRUE;
                        }
                        catch (IOException iOException) {}
                        return Boolean.TRUE;
                    }
                    catch (SecurityException securityException) {
                        try {
                            ResourceServlet.this.sendError(resp, 403);
                            if (is == null) return Boolean.TRUE;
                        }
                        catch (Throwable throwable) {
                            if (is == null) throw throwable;
                            try {
                                is.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            is.close();
                            return Boolean.TRUE;
                        }
                        catch (IOException iOException) {}
                        return Boolean.TRUE;
                    }
                    if (is == null) return Boolean.TRUE;
                    try {
                        is.close();
                        return Boolean.TRUE;
                    }
                    catch (IOException iOException) {}
                    return Boolean.TRUE;
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    void sendError(HttpServletResponse resp, int sc) throws IOException {
        try {
            resp.reset();
            resp.sendError(sc);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    int writeResourceToOutputStream(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[8192];
        int bytesRead = is.read(buffer);
        int writtenContentLength = 0;
        while (bytesRead != -1) {
            os.write(buffer, 0, bytesRead);
            writtenContentLength += bytesRead;
            bytesRead = is.read(buffer);
        }
        return writtenContentLength;
    }

    void writeResourceToWriter(InputStream is, Writer writer) throws IOException {
        InputStreamReader reader = new InputStreamReader(is);
        try {
            char[] buffer = new char[8192];
            int charsRead = reader.read(buffer);
            while (charsRead != -1) {
                writer.write(buffer, 0, charsRead);
                charsRead = reader.read(buffer);
            }
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }
}

