/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.antlr;

import java.util.Stack;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.xtext.parser.antlr.AbstractSplittingTokenSource;
import org.eclipse.xtext.parser.antlr.ITokenAcceptor;

public abstract class AbstractIndentationTokenSource
extends AbstractSplittingTokenSource {
    protected Stack<Integer> indentationStack = new Stack();
    protected int currentOffset;
    protected int currentIndentation;
    protected int currentEnd;
    protected int nextOffset;

    protected AbstractIndentationTokenSource(TokenSource delegate) {
        this.indentationStack.push(0);
        this.currentOffset = 0;
        this.currentIndentation = 0;
        this.currentEnd = 0;
        this.nextOffset = 0;
        this.setDelegate(delegate);
    }

    @Override
    protected boolean shouldSplitToken(Token token) {
        return token.getType() == -1 || this.shouldSplitTokenImpl(token);
    }

    protected abstract boolean shouldSplitTokenImpl(Token var1);

    @Override
    protected void doSplitToken(Token token, ITokenAcceptor result) {
        if (token.getType() == -1) {
            if (this.shouldEmitPendingEndTokens()) {
                while (this.indentationStack.size() > 1) {
                    this.indentationStack.pop();
                    result.accept(this.createEndToken(this.nextOffset));
                }
            }
            result.accept(token);
            return;
        }
        this.doSplitTokenImpl(token, result);
    }

    protected boolean shouldEmitPendingEndTokens() {
        return true;
    }

    @Override
    public Token nextToken() {
        Token result = super.nextToken();
        if (!(result instanceof CommonToken)) {
            throw new IllegalArgumentException(String.valueOf(result));
        }
        this.nextOffset = ((CommonToken)result).getStopIndex() + 1;
        return result;
    }

    protected void doSplitTokenImpl(Token token, ITokenAcceptor result) {
        String text = token.getText();
        int indentation = this.computeIndentation(text);
        if (indentation == -1 || indentation == this.currentIndentation) {
            result.accept(token);
        } else if (indentation > this.currentIndentation) {
            this.splitIntoBeginToken(token, indentation, result);
        } else if (indentation < this.currentIndentation) {
            while (indentation < this.currentIndentation) {
                this.indentationStack.pop();
                this.currentIndentation = this.indentationStack.peek();
                result.accept(this.createEndToken(this.nextOffset));
            }
            if (indentation > this.currentIndentation) {
                this.splitIntoBeginToken(token, indentation, result);
                return;
            }
            result.accept(token);
        } else {
            throw new IllegalStateException(String.valueOf(indentation));
        }
    }

    private void splitIntoBeginToken(Token token, int indentation, ITokenAcceptor result) {
        result.accept(token);
        this.indentationStack.push(indentation);
        this.currentIndentation = indentation;
        result.accept(this.createBeginToken(((CommonToken)token).getStopIndex() + 1));
    }

    protected Token createEndToken(int offset) {
        CommonToken result = new CommonToken(this.getEndTokenType());
        result.setText("");
        result.setChannel(0);
        result.setStartIndex(offset);
        result.setStopIndex(offset - 1);
        return result;
    }

    protected abstract int getEndTokenType();

    protected abstract int getBeginTokenType();

    protected Token createBeginToken(int offset) {
        CommonToken result = new CommonToken(this.getBeginTokenType());
        result.setText("");
        result.setChannel(0);
        result.setStartIndex(offset);
        result.setStopIndex(offset - 1);
        return result;
    }

    protected int computeIndentation(String text) {
        int result = 0;
        int i = text.length() - 1;
        while (i >= 0) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r') {
                return result;
            }
            result = c == '\t' ? (result += this.getTabWidth()) : ++result;
            --i;
        }
        return -1;
    }

    protected char getTabWidth() {
        return '\b';
    }
}

